/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.component.fileentry;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.icefaces.component.fileentry.FileEntry;
import org.icefaces.component.fileentry.FormScriptWriter;
import org.icefaces.util.EnvUtils;

public class FileEntryFormSubmit
implements SystemEventListener {
    static final String IFRAME_ID = "hiddenIframe";
    private static final String ID_SUFFIX = "_captureFileOnsubmit";
    private boolean partialStateSaving = EnvUtils.isPartialStateSaving((FacesContext)FacesContext.getCurrentInstance());

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        UIForm form = (UIForm)((PostAddToViewEvent)event).getComponent();
        if (!this.partialStateSaving) {
            for (UIComponent child : form.getChildren()) {
                String id = child.getId();
                if (null == id || !id.endsWith(ID_SUFFIX)) continue;
                return;
            }
        }
        if (!FileEntryFormSubmit.foundFileEntry((UIComponent)form)) {
            return;
        }
        form.getAttributes().put("DISABLE_CAPTURE_SUBMIT", "true");
        FormScriptWriter scriptWriter = new FormScriptWriter(null, ID_SUFFIX);
        form.getChildren().add(0, scriptWriter);
        UIOutput output = new UIOutput(){

            public void encodeBegin(FacesContext context) throws IOException {
                String clientId = this.getClientId(context);
                ResponseWriter writer = context.getResponseWriter();
                writer.startElement("iframe", (UIComponent)this);
                writer.writeAttribute("id", (Object)clientId, "clientId");
                writer.writeAttribute("name", (Object)clientId, "clientId");
                writer.writeAttribute("style", (Object)"display:none;", "style");
                writer.writeAttribute("src", (Object)"about:blank", "src");
                writer.endElement("iframe");
            }

            public void encodeEnd(FacesContext context) throws IOException {
            }
        };
        output.setId(IFRAME_ID);
        output.setTransient(true);
        form.getChildren().add(1, output);
    }

    private static boolean foundFileEntry(UIComponent parent) {
        Iterator kids = parent.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (kid instanceof FileEntry) {
                return true;
            }
            if (!FileEntryFormSubmit.foundFileEntry(kid)) continue;
            return true;
        }
        return false;
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof UIForm;
    }
}

