/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.component.pushbutton;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.render.Renderer;
import org.icefaces.component.pushbutton.PushButton;
import org.icefaces.component.utils.JSONBuilder;
import org.icefaces.component.utils.ScriptWriter;
import org.icefaces.component.utils.Utils;
import org.icefaces.render.MandatoryResourceComponent;
import org.icefaces.util.EnvUtils;

@MandatoryResourceComponent(value="org.icefaces.component.pushbutton.PushButton")
public class PushButtonRenderer
extends Renderer {
    List<UIParameter> uiParamChildren;

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        PushButton pushButton = (PushButton)uiComponent;
        String source = String.valueOf(requestParameterMap.get("ice.event.captured"));
        String clientId = pushButton.getClientId();
        if (clientId.equals(source)) {
            try {
                if (!pushButton.isDisabled()) {
                    uiComponent.queueEvent((FacesEvent)new ActionEvent(uiComponent));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        PushButton pushButton = (PushButton)uiComponent;
        this.uiParamChildren = Utils.captureParameters((UIComponent)pushButton);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)"ice-pushbutton", null);
        writer.startElement("span", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_span"), null);
        String yuiBaseClass = "yui-button yui-min yui-push-button";
        String styleClass = pushButton.getStyleClass();
        if (null != styleClass) {
            yuiBaseClass = yuiBaseClass + " " + String.valueOf(styleClass);
        }
        writer.writeAttribute("styleClass", (Object)yuiBaseClass, null);
        String style = pushButton.getStyle();
        if (style != null && style.trim().length() > 0) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.startElement("span", uiComponent);
        writer.writeAttribute("class", (Object)"first-child", null);
        writer.writeAttribute("id", (Object)(clientId + "_s2"), null);
        writer.startElement("button", uiComponent);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("name", (Object)(clientId + "_button"), null);
        writer.startElement("span", uiComponent);
        Object oVal = pushButton.getValue();
        if (null != oVal) {
            writer.writeText((Object)String.valueOf(oVal), null);
        } else {
            String label = pushButton.getLabel();
            if (label != null) {
                writer.writeText((Object)label, null);
            }
        }
        writer.endElement("span");
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String oLab;
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        PushButton pushButton = (PushButton)uiComponent;
        writer.endElement("button");
        writer.endElement("span");
        writer.endElement("span");
        String ariaLabel = "";
        String yuiLabel = "";
        String builder = "";
        Object oVal = pushButton.getValue();
        if (null != oVal) {
            yuiLabel = String.valueOf(oVal);
        }
        if (null != (oLab = pushButton.getLabel())) {
            ariaLabel = String.valueOf(oLab);
        }
        if (yuiLabel.equals("")) {
            yuiLabel = ariaLabel;
        }
        if (ariaLabel.equals("")) {
            ariaLabel = yuiLabel;
        }
        boolean ariaEnabled = EnvUtils.isAriaEnabled((FacesContext)facesContext);
        Integer tabindex = pushButton.getTabindex();
        if (ariaEnabled && tabindex == null) {
            tabindex = 0;
        }
        JSONBuilder jBuild = JSONBuilder.create().beginMap();
        jBuild.entry("type", "button").entry("disabled", pushButton.isDisabled());
        if (tabindex != null) {
            jBuild.entry("tabindex", tabindex);
        }
        builder = jBuild.entry("label", yuiLabel).endMap().toString();
        StringBuilder sb = new StringBuilder();
        sb.append(pushButton.getValue()).append(pushButton.getStyleClass()).append(pushButton.getStyle());
        jBuild = JSONBuilder.create().beginMap().entry("singleSubmit", pushButton.isSingleSubmit()).entry("ariaLabel", ariaLabel).entry("hashCode", sb.toString().hashCode()).entry("ariaEnabled", ariaEnabled);
        if (this.uiParamChildren != null) {
            jBuild.entry("postParameters", Utils.asStringArray(this.uiParamChildren));
        }
        String params = "'" + clientId + "'," + builder + "," + jBuild.endMap().toString();
        String finalScript = "ice.component.pushbutton.updateProperties(" + params + ");";
        ScriptWriter.insertScript(facesContext, uiComponent, finalScript);
        writer.endElement("div");
    }
}

