/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.datetimeentry;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.icefaces.ace.component.datetimeentry.DateTimeEntry;

public class DateTimeEntryUtils {
    public static String getValueAsString(FacesContext facesContext, DateTimeEntry dateTimeEntry) {
        Object submittedValue = dateTimeEntry.getSubmittedValue();
        if (submittedValue != null) {
            return submittedValue.toString();
        }
        Object value = dateTimeEntry.getValue();
        if (value == null) {
            return null;
        }
        if (dateTimeEntry.getConverter() != null) {
            return dateTimeEntry.getConverter().getAsString(facesContext, (UIComponent)dateTimeEntry, value);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateTimeEntry.getPattern(), dateTimeEntry.calculateLocale(facesContext));
        dateFormat.setTimeZone(dateTimeEntry.calculateTimeZone());
        return dateFormat.format(value);
    }

    public static String getDateAsString(DateTimeEntry dateTimeEntry, Object date) {
        if (date == null) {
            return null;
        }
        if (date instanceof String) {
            return (String)date;
        }
        if (date instanceof Date) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(dateTimeEntry.getPattern(), dateTimeEntry.calculateLocale(FacesContext.getCurrentInstance()));
            dateFormat.setTimeZone(dateTimeEntry.calculateTimeZone());
            return dateFormat.format((Date)date);
        }
        throw new FacesException("Date could be either String or java.util.Date");
    }

    public static String convertPattern(String pattern) {
        if (pattern == null) {
            return null;
        }
        pattern = (pattern = pattern.replaceAll("yy", "y")).indexOf("MMM") != -1 ? pattern.replaceAll("MMM", "M") : pattern.replaceAll("M", "m");
        if ((pattern = pattern.replaceAll("EEE", "D")).indexOf("H") != -1 || pattern.indexOf("h") != -1) {
            pattern = pattern.replaceAll("H", "h").replaceAll("a", "TT");
        }
        return pattern;
    }
}

