/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.dnd;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.ace.component.dnd.Draggable;
import org.icefaces.ace.renderkit.CoreRenderer;
import org.icefaces.render.MandatoryResourceComponent;

@MandatoryResourceComponent(tagName="draggable", value="org.icefaces.ace.component.dnd.Draggable")
public class DraggableRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Draggable draggable = (Draggable)component;
        String clientId = draggable.getClientId(facesContext);
        String target = this.findTarget(facesContext, draggable);
        writer.startElement("script", (UIComponent)draggable);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("ice.ace.jq(function() {");
        writer.write(this.resolveWidgetVar((UIComponent)draggable) + " = new ice.ace.Draggable('" + clientId + "',");
        writer.write("{");
        writer.write("target:'" + target + "'");
        writer.write(",cursor:'" + draggable.getCursor() + "'");
        if (draggable.isDisabled()) {
            writer.write(",disabled:true");
        }
        if (draggable.getAxis() != null) {
            writer.write(",axis:'" + draggable.getAxis() + "'");
        }
        if (draggable.getContainment() != null) {
            writer.write(",containment:'" + draggable.getContainment() + "'");
        }
        if (draggable.getHelper() != null) {
            writer.write(",helper:'" + draggable.getHelper() + "'");
        }
        if (draggable.isRevert()) {
            writer.write(",revert:'invalid'");
        }
        if (draggable.getZindex() != -1) {
            writer.write(",zIndex:" + draggable.getZindex());
        }
        if (draggable.getHandle() != null) {
            writer.write(",handle:'" + draggable.getHandle() + "'");
        }
        if (draggable.getOpacity() != 1.0) {
            writer.write(",opacity:" + draggable.getOpacity());
        }
        if (draggable.getStack() != null) {
            writer.write(",stack:'" + draggable.getStack() + "'");
        }
        if (draggable.getGrid() != null) {
            writer.write(",grid:[" + draggable.getGrid() + "]");
        }
        if (draggable.getScope() != null) {
            writer.write(",scope:'" + draggable.getScope() + "'");
        }
        if (draggable.isSnap()) {
            writer.write(",snap:true");
            writer.write(",snapTolerance:" + draggable.getSnapTolerance());
            if (draggable.getSnapMode() != null) {
                writer.write(",snapMode:'" + draggable.getSnapMode() + "'");
            }
        }
        writer.write("});");
        writer.write("});");
        writer.endElement("script");
    }

    protected String findTarget(FacesContext facesContext, Draggable draggable) {
        String _for = draggable.getFor();
        if (_for != null) {
            UIComponent component = draggable.findComponent(_for);
            if (component == null) {
                throw new FacesException("Cannot find component \"" + _for + "\" in view.");
            }
            return component.getClientId(facesContext);
        }
        return draggable.getParent().getClientId(facesContext);
    }
}

