/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.el.ValueExpression;
import javax.faces.component.NamingContainer;
import javax.faces.component.StateHelper;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIParameter;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.ace.component.animation.AnimationBehavior;
import org.icefaces.impl.util.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static void renderChildren(FacesContext facesContext, UIComponent component) throws IOException {
        if (component.getChildCount() > 0) {
            for (UIComponent child : component.getChildren()) {
                Utils.renderChild(facesContext, child);
            }
        }
    }

    public static void renderChild(FacesContext facesContext, UIComponent child) throws IOException {
        if (!child.isRendered()) {
            return;
        }
        child.encodeBegin(facesContext);
        if (child.getRendersChildren()) {
            child.encodeChildren(facesContext);
        } else {
            Utils.renderChildren(facesContext, child);
        }
        child.encodeEnd(facesContext);
    }

    public static UIComponent findNamingContainer(UIComponent uiComponent) {
        UIComponent parent;
        for (parent = uiComponent.getParent(); parent != null && !(parent instanceof NamingContainer); parent = parent.getParent()) {
        }
        return parent;
    }

    public static UIComponent findForm(UIComponent uiComponent) {
        UIComponent parent = uiComponent.getParent();
        while (parent != null && !(parent instanceof UIForm)) {
            parent = Utils.findNamingContainer(parent);
        }
        return parent;
    }

    public static UIForm findParentForm(UIComponent comp) {
        if (comp == null) {
            return null;
        }
        if (comp instanceof UIForm) {
            return (UIForm)comp;
        }
        return Utils.findParentForm(comp.getParent());
    }

    public static void decodeBehavior(FacesContext facesContext, UIComponent uiComponent) {
    }

    public static boolean iterateEffects(AnimationBehavior.Iterator iterator) {
        if (!(iterator.getUIComponent() instanceof ClientBehaviorHolder)) {
            return false;
        }
        for (String effect : ((ClientBehaviorHolder)iterator.getUIComponent()).getClientBehaviors().keySet()) {
            for (ClientBehavior behavior : (List)((ClientBehaviorHolder)iterator.getUIComponent()).getClientBehaviors().get(effect)) {
                if (!(behavior instanceof AnimationBehavior)) continue;
                iterator.next(effect, (AnimationBehavior)behavior);
            }
        }
        return true;
    }

    public static void writeConcatenatedStyleClasses(ResponseWriter writer, String componentClass, String applicationClass) throws IOException {
        int applicationLen;
        int n;
        int componentLen;
        int n2;
        if (componentClass == null) {
            n2 = 0;
        } else {
            componentClass = componentClass.trim();
            n2 = componentLen = componentClass.length();
        }
        if (applicationClass == null) {
            n = 0;
        } else {
            applicationClass = applicationClass.trim();
            n = applicationLen = applicationClass.length();
        }
        if (componentLen > 0 && applicationLen == 0) {
            writer.writeAttribute("class", (Object)componentClass, "styleClass");
        } else if (componentLen == 0 && applicationLen > 0) {
            writer.writeAttribute("class", (Object)applicationClass, "styleClass");
        } else if (componentLen > 0 || applicationLen > 0) {
            int totalLen = componentLen + applicationLen;
            if (componentLen > 0 && applicationLen > 0) {
                ++totalLen;
            }
            StringBuilder sb = new StringBuilder(totalLen);
            if (componentLen > 0) {
                sb.append(componentClass);
            }
            if (applicationLen > 0) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(applicationClass);
            }
            writer.writeAttribute("class", (Object)sb.toString(), "styleClass");
        }
    }

    public static void writeConcatenatedStyleClasses(ResponseWriter writer, String componentClass, String applicationClass, boolean disabled) throws IOException {
        int applicationLen;
        int n;
        int componentLen;
        int n2;
        String disabledStr = "-disabled";
        if (componentClass == null) {
            n2 = 0;
        } else {
            componentClass = componentClass.trim();
            n2 = componentLen = componentClass.length();
        }
        if (applicationClass == null) {
            n = 0;
        } else {
            applicationClass = applicationClass.trim();
            n = applicationLen = applicationClass.length();
        }
        if (componentLen > 0 && applicationLen == 0) {
            if (disabled) {
                String styleClass = (componentClass + "-disabled").intern();
                writer.writeAttribute("class", (Object)styleClass, "styleClass");
            } else {
                writer.writeAttribute("class", (Object)componentClass, "styleClass");
            }
        } else if (componentLen == 0 && applicationLen > 0 && !disabled) {
            writer.writeAttribute("class", (Object)applicationClass, "styleClass");
        } else if (componentLen > 0 || applicationLen > 0) {
            int totalLen = componentLen + applicationLen;
            if (disabled && componentLen > 0) {
                totalLen += "-disabled".length();
            }
            if (disabled && applicationLen > 0) {
                totalLen += "-disabled".length();
            }
            if (componentLen > 0 && applicationLen > 0) {
                ++totalLen;
            }
            StringBuilder sb = new StringBuilder(totalLen);
            if (componentLen > 0) {
                sb.append(componentClass);
                if (disabled) {
                    sb.append("-disabled");
                }
            }
            if (applicationLen > 0) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(applicationClass);
                if (disabled) {
                    sb.append("-disabled");
                }
            }
            writer.writeAttribute("class", (Object)sb.toString(), "styleClass");
        }
    }

    public static void writeConcatenatedStyleClasses(ResponseWriter writer, String[] componentClasses, String applicationClass, boolean disabled) throws IOException {
        String disabledStr = "-disabled";
        int componentCount = componentClasses == null ? 0 : componentClasses.length;
        StringTokenizer st = new StringTokenizer(applicationClass, " ");
        int applicationCount = st.countTokens();
        if (componentCount == 1 && applicationCount == 0) {
            if (disabled) {
                String styleClass = (componentClasses[0].trim() + "-disabled").intern();
                writer.writeAttribute("class", (Object)styleClass, "styleClass");
            } else {
                writer.writeAttribute("class", (Object)componentClasses[0], "styleClass");
            }
        } else if (componentCount == 0 && applicationCount == 1 && !disabled) {
            writer.writeAttribute("class", (Object)applicationClass, "styleClass");
        } else if (componentCount > 0 || applicationCount > 0) {
            StringBuilder sb = new StringBuilder((componentCount + applicationCount) * 16);
            for (int i = 0; i < componentCount; ++i) {
                Utils.concatenateStyleClass(sb, componentClasses[i], disabled, "-disabled");
            }
            while (st.hasMoreTokens()) {
                Utils.concatenateStyleClass(sb, st.nextToken(), disabled, "-disabled");
            }
            sb.trimToSize();
            writer.writeAttribute("class", (Object)sb.toString(), "styleClass");
        }
    }

    private static void concatenateStyleClass(StringBuilder sb, String styleClass, boolean disabled, String disabledStr) {
        if (sb.length() > 0) {
            sb.append(' ');
        }
        sb.append(styleClass);
        if (disabled) {
            sb.append(' ');
            sb.append(styleClass);
            sb.append(disabledStr);
        }
    }

    public static List<UIParameter> captureParameters(UIComponent component) {
        List children = component.getChildren();
        ArrayList<UIParameter> returnVal = null;
        for (UIComponent child : children) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)child;
            if (returnVal == null) {
                returnVal = new ArrayList<UIParameter>();
            }
            returnVal.add(param);
        }
        return returnVal;
    }

    public static String asParameterString(List<UIParameter> children) {
        StringBuffer builder = new StringBuffer();
        for (UIParameter param : children) {
            builder.append(DOMUtils.escapeAnsi((String)param.getName())).append("=").append(DOMUtils.escapeAnsi((String)((String)param.getValue())).replace(' ', '+')).append("&");
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    public static String[] asStringArray(List<UIParameter> children) {
        ArrayList<String> builder = new ArrayList<String>();
        for (UIParameter param : children) {
            builder.add(param.getName());
            builder.add(param.getValue().toString());
        }
        String[] returnVal = new String[builder.size()];
        builder.toArray(returnVal);
        return returnVal;
    }

    public static boolean superValueIfSet(UIComponent component, StateHelper sh, String attName, boolean superValue, boolean defaultValue) {
        String clientId;
        ValueExpression ve = component.getValueExpression(attName);
        if (ve != null) {
            return superValue;
        }
        String valuesKey = attName + "_rowValues";
        Map clientValues = (Map)sh.get((Serializable)((Object)valuesKey));
        if (clientValues != null && clientValues.containsKey(clientId = component.getClientId())) {
            return superValue;
        }
        String defaultKey = attName + "_defaultValues";
        Map defaultValues = (Map)sh.get((Serializable)((Object)defaultKey));
        if (defaultValues != null && defaultValues.containsKey("defValue")) {
            return superValue;
        }
        return defaultValue;
    }
}

