/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.column;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.icefaces.ace.component.celleditor.CellEditor;
import org.icefaces.ace.component.column.ColumnBase;
import org.icefaces.ace.component.datatable.DataTable;
import org.icefaces.ace.model.filter.ContainsFilterConstraint;
import org.icefaces.ace.model.filter.EndsWithFilterConstraint;
import org.icefaces.ace.model.filter.ExactFilterConstraint;
import org.icefaces.ace.model.filter.FilterConstraint;
import org.icefaces.ace.model.filter.StartsWithFilterConstraint;

public class Column
extends ColumnBase {
    private static final String OPTIMIZED_PACKAGE = "org.icefaces.ace.component.";
    private int currGroupLength;
    private boolean oddGroup = false;
    private CellEditor cellEditor = null;
    private FilterConstraint filterConstraint = null;
    private static final String STARTS_WITH_MATCH_MODE = "startsWith";
    private static final String ENDS_WITH_MATCH_MODE = "endsWith";
    private static final String CONTAINS_MATCH_MODE = "contains";
    private static final String EXACT_MATCH_MODE = "exact";

    public Column() {
        this.setRendererType(null);
    }

    public FilterConstraint getFilterConstraint() {
        String filterMatchMode = this.getFilterMatchMode();
        if (this.filterConstraint == null) {
            if (filterMatchMode.equals(STARTS_WITH_MATCH_MODE)) {
                this.filterConstraint = new StartsWithFilterConstraint();
            } else if (filterMatchMode.equals(ENDS_WITH_MATCH_MODE)) {
                this.filterConstraint = new EndsWithFilterConstraint();
            } else if (filterMatchMode.equals(CONTAINS_MATCH_MODE)) {
                this.filterConstraint = new ContainsFilterConstraint();
            } else if (filterMatchMode.equals(EXACT_MATCH_MODE)) {
                this.filterConstraint = new ExactFilterConstraint();
            }
        }
        return this.filterConstraint;
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    public CellEditor getCellEditor() {
        if (this.cellEditor != null) {
            return this.cellEditor;
        }
        for (UIComponent child : this.getChildren()) {
            if (!(child instanceof CellEditor)) continue;
            this.cellEditor = (CellEditor)child;
            return this.cellEditor;
        }
        return null;
    }

    public void setSortPriority(Integer i) {
        DataTable table = this.findParentTable(this.getFacesContext(), this);
        if (table != null) {
            table.applySorting();
        }
        super.setSortPriority(i);
    }

    protected DataTable findParentTable(FacesContext context, Column editor) {
        for (UIComponent parent = editor.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof DataTable)) continue;
            return (DataTable)parent;
        }
        return null;
    }

    public int getCurrGroupLength() {
        return this.currGroupLength;
    }

    public void setCurrGroupLength(int currGroupLength) {
        this.currGroupLength = currGroupLength;
    }

    public boolean isOddGroup() {
        return this.oddGroup;
    }

    public void setOddGroup(boolean oddGroup) {
        this.oddGroup = oddGroup;
    }

    public boolean isNextColumnGrouped() {
        DataTable dataTable = this.findParentTable(this.getFacesContext(), this);
        int currentRow = dataTable.getRowIndex();
        Object currentValue = this.getGroupBy();
        if (currentValue != null) {
            dataTable.setRowIndex(currentRow + 1);
            Object nextValue = this.getGroupBy();
            dataTable.setRowIndex(currentRow);
            return currentValue.equals(nextValue);
        }
        return false;
    }

    public int findCurrGroupLength() {
        DataTable dataTable = this.findParentTable(this.getFacesContext(), this);
        int result = 0;
        int currentRow = dataTable.getRowIndex();
        boolean keepCounting = true;
        Object currentValue = this.getGroupBy();
        boolean notExpanded = !dataTable.getStateMap().get(dataTable.getRowData()).isExpanded();
        boolean noTailingRows = dataTable.getConditionalRows(currentRow, false).size() == 0;
        boolean lastExpanded = false;
        if (notExpanded && noTailingRows) {
            while (keepCounting) {
                boolean hasConditionalRows;
                dataTable.setRowIndex(currentRow + result + 1);
                if (!dataTable.isRowAvailable()) break;
                boolean expanded = dataTable.getStateMap().get(dataTable.getRowData()).isExpanded();
                boolean bl = hasConditionalRows = dataTable.getConditionalRows(currentRow + result + 1, true).size() > 0 || dataTable.getConditionalRows(currentRow + result, false).size() > 0;
                if (currentValue.equals(this.getGroupBy()) && !lastExpanded && !hasConditionalRows) {
                    lastExpanded = expanded;
                    ++result;
                    continue;
                }
                keepCounting = false;
            }
        }
        dataTable.setRowIndex(currentRow);
        this.setCurrGroupLength(result);
        return result;
    }

    public boolean isLastGroupDifferent() {
        DataTable dataTable = this.findParentTable(this.getFacesContext(), this);
        int currentRow = dataTable.getRowIndex();
        Object currentValue = this.getGroupBy();
        if (currentValue != null) {
            dataTable.setRowIndex(currentRow - 1);
            Object lastValue = this.getGroupBy();
            dataTable.setRowIndex(currentRow);
            return !currentValue.equals(lastValue);
        }
        return true;
    }
}

