/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.row;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.application.ResourceDependencies;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.icefaces.ace.component.datatable.DataTable;
import org.icefaces.ace.component.row.RowBase;
import org.icefaces.ace.util.collections.Predicate;

@ResourceDependencies(value={})
public class Row
extends RowBase {
    private Predicate predicate;
    private DataTable table;

    public boolean evaluateCondition(int index) {
        String condition = this.getCondition();
        if (condition == null) {
            return false;
        }
        if (this.predicate == null) {
            if (condition.equals("interval")) {
                this.predicate = new IntervalPredicate(this.getInterval());
            } else if (condition.equals("group")) {
                this.predicate = new GroupPredicate(this.getValueExpression("groupBy"), this.getPos().equals("before"));
            } else if (condition.equals("predicate")) {
                this.predicate = this.getPredicate();
            }
        }
        return this.predicate.evaluate(index);
    }

    private DataTable findParentTable(FacesContext context) {
        if (this.table == null) {
            for (UIComponent parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof DataTable)) continue;
                this.table = (DataTable)parent;
                break;
            }
        }
        return this.table;
    }

    public void resetRenderVariables() {
        this.predicate = null;
    }

    private class GroupPredicate
    implements Predicate {
        ValueExpression groupBy;
        boolean before;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ELContext elContext = this.facesContext.getELContext();

        public GroupPredicate(ValueExpression gb, boolean before) {
            this.groupBy = gb;
            this.before = before;
            Row.this.findParentTable(this.facesContext);
        }

        public boolean evaluate(Object object) {
            int currentIndex = Row.this.table.getRowIndex();
            Integer index = (Integer)object;
            Row.this.table.setRowIndex(index);
            Object currentValue = this.groupBy.getValue(this.elContext);
            if (index == 0 && this.before) {
                return true;
            }
            if (this.before) {
                Row.this.table.setRowIndex(index - 1);
                Object lastValue = Row.this.table.isRowAvailable() ? this.groupBy.getValue(this.elContext) : null;
                Row.this.table.setRowIndex(currentIndex);
                return !currentValue.equals(lastValue);
            }
            Row.this.table.setRowIndex(index + 1);
            Object nextValue = Row.this.table.isRowAvailable() ? this.groupBy.getValue(this.elContext) : null;
            Row.this.table.setRowIndex(currentIndex);
            return !currentValue.equals(nextValue);
        }
    }

    private class IntervalPredicate
    implements Predicate {
        int interval;

        public IntervalPredicate(int interval) {
            if (interval < 1) {
                throw new IllegalArgumentException();
            }
            this.interval = interval;
        }

        public boolean evaluate(Object index) {
            return index instanceof Integer && (Integer)index % this.interval == 0;
        }
    }
}

