/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.accordion;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import org.icefaces.ace.component.accordion.Accordion;
import org.icefaces.ace.component.accordion.AccordionPane;
import org.icefaces.ace.component.ajax.AjaxBehavior;
import org.icefaces.ace.event.AccordionPaneChangeEvent;
import org.icefaces.ace.renderkit.CoreRenderer;
import org.icefaces.ace.util.JSONBuilder;
import org.icefaces.render.MandatoryResourceComponent;

@MandatoryResourceComponent(tagName="accordion", value="org.icefaces.ace.component.accordion.Accordion")
public class AccordionRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Accordion acco = (Accordion)component;
        Map params = context.getExternalContext().getRequestParameterMap();
        String activeIndex = (String)params.get(acco.getClientId(context) + "_active");
        if (activeIndex != null) {
            if (activeIndex.equals("false")) {
                acco.setActiveIndex(-1);
            } else {
                acco.setActiveIndex(Integer.valueOf(activeIndex));
            }
        }
        if (acco.isTabChangeRequest(context) && acco.getActiveIndex() >= 0) {
            AccordionPaneChangeEvent changeEvent = new AccordionPaneChangeEvent((UIComponent)acco, acco.findTabToLoad(context));
            changeEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
            acco.queueEvent(changeEvent);
        }
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        Accordion acco = (Accordion)component;
        if (acco.isContentLoadRequest(context)) {
            AccordionPane tabToLoad = acco.findTabToLoad(context);
            if (tabToLoad != null) {
                tabToLoad.encodeAll(context);
            }
        } else {
            this.encodeMarkup(context, acco);
        }
    }

    protected void encodeMarkup(FacesContext context, Accordion accordionPanel) throws IOException {
        String styleClass;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = accordionPanel.getClientId(context);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        String style = accordionPanel.getStyle();
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if ((styleClass = accordionPanel.getStyleClass()) != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_acco"), null);
        this.encodeTabs(context, accordionPanel);
        writer.endElement("div");
        this.encodeStateHolder(context, accordionPanel);
        this.encodeScript(context, accordionPanel);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, Accordion acco) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = acco.getClientId(context);
        int activeIndex = acco.getActiveIndex();
        boolean isDynamic = acco.isDynamic();
        boolean hasTabChangeListener = acco.getPaneChangeListener() != null;
        for (String eventId : acco.getClientBehaviors().keySet()) {
            if (!eventId.equals("panechange") || ((AjaxBehavior)((Object)((List)acco.getClientBehaviors().get(eventId)).get(0))).isDisabled()) continue;
            hasTabChangeListener = true;
        }
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(AccordionRenderer.resolveWidgetVar((UIComponent)acco) + " = new ");
        JSONBuilder jb = JSONBuilder.create();
        jb.beginFunction("ice.ace.AccordionPanel").item(clientId).beginMap().entry("active", activeIndex == -1 ? "false" : String.valueOf(activeIndex), true).entry("dynamic", isDynamic).entry("animated", acco.getEffect());
        String event = acco.getEvent();
        if (event != null) {
            jb.entry("event", event);
        }
        if (!acco.isAutoHeight()) {
            jb.entry("autoHeight", false);
        }
        if (acco.isCollapsible()) {
            jb.entry("collapsible", true);
        }
        if (acco.isFillSpace()) {
            jb.entry("fillSpace", true);
        }
        if (acco.isDisabled()) {
            jb.entry("disabled", true);
        }
        if (isDynamic || hasTabChangeListener) {
            jb.entry("cache", acco.isCache());
        }
        if (hasTabChangeListener) {
            jb.entry("ajaxTabChange", true);
        }
        this.encodeClientBehaviors(context, acco, jb);
        jb.endMap().endFunction();
        writer.write(jb.toString());
        writer.endElement("script");
    }

    protected void encodeStateHolder(FacesContext context, Accordion accordionPanel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = accordionPanel.getClientId(context);
        String stateHolderId = clientId + "_active";
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)stateHolderId, null);
        writer.writeAttribute("name", (Object)stateHolderId, null);
        writer.writeAttribute("value", (Object)accordionPanel.getActiveIndex(), null);
        writer.endElement("input");
    }

    protected void encodeTabs(FacesContext context, Accordion acco) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        int activeIndex = acco.getActiveIndex();
        for (int i = 0; i < acco.getChildCount(); ++i) {
            UIComponent kid = (UIComponent)acco.getChildren().get(i);
            if (!kid.isRendered() || !(kid instanceof AccordionPane)) continue;
            AccordionPane tab = (AccordionPane)kid;
            writer.startElement("h3", null);
            writer.startElement("a", null);
            writer.writeAttribute("href", (Object)"#", null);
            if (tab.getTitle() != null) {
                writer.write(tab.getTitle());
            }
            writer.endElement("a");
            writer.endElement("h3");
            String clientId = kid.getClientId(context);
            writer.startElement("div", null);
            writer.writeAttribute("id", (Object)clientId, null);
            writer.startElement("div", null);
            writer.writeAttribute("id", (Object)(clientId + "_content"), null);
            if (acco.isDynamic()) {
                if (i == activeIndex) {
                    tab.encodeAll(context);
                }
            } else {
                tab.encodeAll(context);
            }
            writer.endElement("div");
            writer.endElement("div");
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

