/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.autocompleteentry;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.model.SelectItem;
import org.icefaces.ace.component.autocompleteentry.AutoCompleteEntryBase;
import org.icefaces.ace.component.autocompleteentry.KeyEvent;

public class AutoCompleteEntry
extends AutoCompleteEntryBase
implements NamingContainer {
    private transient List<Object> itemList;
    private transient int index = -1;
    private Object selectedItem;
    private transient List changedComponentIds;

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
    }

    public void decode(FacesContext facesContext) {
        this.setSelectedItem(facesContext);
        super.decode(facesContext);
        boolean isEventSource = false;
        Object componenetId = facesContext.getExternalContext().getRequestParameterMap().get("ice.event.captured");
        if (componenetId != null && componenetId.toString().equals(this.getClientId(facesContext) + "_input")) {
            isEventSource = true;
        }
        if (isEventSource) {
            this.queueEventIfEnterKeyPressed(facesContext);
        } else {
            this.setChangedComponentId(null);
        }
    }

    private void setSelectedItem(FacesContext facesContext) {
        String selIdxStr;
        Map requestMap = facesContext.getExternalContext().getRequestParameterMap();
        String clientId = this.getClientId(facesContext);
        String value = (String)requestMap.get(clientId + "_input");
        String oldValue = (String)this.getValue();
        if (value != null) {
            if (!value.equalsIgnoreCase(oldValue)) {
                this.setChangedComponentId(clientId + "_input");
            }
            if ("".equals(value) && oldValue == null) {
                this.setChangedComponentId(null);
            }
            this.setSubmittedValue(value);
        }
        if ((selIdxStr = (String)requestMap.get(clientId + "_idx")) != null && selIdxStr.trim().length() > 0) {
            int selIdx = Integer.parseInt(selIdxStr);
            this.setSelectedIndex(selIdx);
            this.setChangedComponentId(clientId + "_input");
        } else {
            this.setSelectedItem(value);
        }
    }

    private static boolean isPartialSubmitKeypress(Map requestMap, String clientId) {
        String target = (String)requestMap.get("ice.event.target");
        String captured = (String)requestMap.get("ice.event.captured");
        if (target == null) {
            target = "";
        }
        if (captured == null) {
            captured = "";
        }
        if (!target.equals(clientId + "_input") && !captured.equals(clientId + "_input")) {
            return false;
        }
        String type = (String)requestMap.get("ice.event.type");
        String partialSubmit = (String)requestMap.get("ice.submit.partial");
        if (type == null || type.length() == 0 || partialSubmit == null || partialSubmit.length() == 0) {
            return false;
        }
        return partialSubmit.equalsIgnoreCase("true") && (type.equalsIgnoreCase("onundefined") || type.equalsIgnoreCase("onunknown") || type.equalsIgnoreCase("onkeypress") || type.equalsIgnoreCase("onkeydown"));
    }

    public Iterator getItemList() {
        if (this.itemList == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.itemList.iterator();
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getClientId(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        String baseClientId = super.getClientId(context);
        if (this.index >= 0) {
            return baseClientId + UINamingContainer.getSeparatorChar((FacesContext)context) + this.index++;
        }
        return baseClientId;
    }

    public void resetId(UIComponent component) {
        String id = component.getId();
        component.setId(id);
        if (component.getChildCount() == 0) {
            return;
        }
        for (UIComponent kid : component.getChildren()) {
            this.resetId(kid);
        }
    }

    void populateItemList() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.itemList = this.getSelectFacet() != null ? this.getListValue() : AutoCompleteEntry.getSelectItems(facesContext, (UIComponent)this);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
    }

    public UIComponent getSelectFacet() {
        return this.getFacet("row");
    }

    protected void setSelectedIndex(int index) {
        Object selItm = null;
        if (index >= 0) {
            if (this.itemList == null) {
                this.populateItemList();
            }
            if (this.itemList != null && index < this.itemList.size()) {
                selItm = this.itemList.get(index);
            }
        }
        this.selectedItem = selItm;
    }

    public void setSelectedItem(String key) {
        Object selItm = null;
        if (key != null) {
            if (this.itemList == null) {
                this.populateItemList();
            }
            if (this.itemList != null) {
                Object sticky = null;
                boolean multipleMatches = false;
                FacesContext facesContext = FacesContext.getCurrentInstance();
                for (int i = 0; i < this.itemList.size(); ++i) {
                    String itemLabel;
                    Object item = this.itemList.get(i);
                    if (item instanceof SelectItem) {
                        itemLabel = ((SelectItem)item).getLabel();
                        if (itemLabel == null) {
                            itemLabel = ((SelectItem)item).getValue().toString();
                        }
                    } else {
                        itemLabel = this.getMainValue(item);
                    }
                    if (!key.equals(itemLabel)) continue;
                    if (this.selectedItem != null && this.selectedItem.equals(item)) {
                        sticky = item;
                    }
                    multipleMatches |= selItm != null;
                    selItm = item;
                }
                if (sticky != null) {
                    selItm = sticky;
                } else if (multipleMatches) {
                    selItm = null;
                }
            }
        }
        this.selectedItem = selItm;
    }

    private String getMainValue(Object o) {
        FacesContext context = FacesContext.getCurrentInstance();
        ELContext elContext = context.getELContext();
        String listVar = this.getListVar();
        context.getExternalContext().getRequestMap().put(listVar, o);
        Object value = this.getValueExpression("filterBy").getValue(elContext);
        context.getExternalContext().getRequestMap().remove(listVar);
        if (value == null) {
            return "null";
        }
        return (String)value;
    }

    public Object getSelectedItem() {
        return this.selectedItem;
    }

    void setChangedComponentId(Object id) {
        if (id == null) {
            if (this.changedComponentIds != null) {
                this.changedComponentIds.clear();
            }
        } else {
            if (this.changedComponentIds == null) {
                this.changedComponentIds = new ArrayList(6);
            }
            this.changedComponentIds.add(id);
        }
    }

    boolean hasChanged() {
        if (this.changedComponentIds == null) {
            return false;
        }
        return this.changedComponentIds.contains(this.getClientId(FacesContext.getCurrentInstance()) + "_input");
    }

    private void queueEventIfEnterKeyPressed(FacesContext facesContext) {
        try {
            Map requestParemeterMap = facesContext.getExternalContext().getRequestParameterMap();
            KeyEvent keyEvent = new KeyEvent((UIComponent)this, requestParemeterMap);
            if (keyEvent.getKeyCode() == 13) {
                this.setChangedComponentId(null);
                this.queueEvent((FacesEvent)new ActionEvent((UIComponent)this));
            }
            if ("true".equals(requestParemeterMap.get("ice.event.left"))) {
                this.setChangedComponentId(null);
                this.queueEvent((FacesEvent)new ActionEvent((UIComponent)this));
            } else if ("onclick".equals(requestParemeterMap.get("ice.event.type"))) {
                this.setChangedComponentId(null);
                this.queueEvent((FacesEvent)new ActionEvent((UIComponent)this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getOnkeypress() {
        if (this.isDisabled() || this.isReadonly()) {
            return "";
        }
        return super.getOnkeypress();
    }

    public static List getSelectItems(FacesContext context, UIComponent uiComponent) {
        ArrayList<Object> selectItems = new ArrayList<Object>();
        if (uiComponent.getChildCount() == 0) {
            return selectItems;
        }
        for (UIComponent nextSelectItemChild : uiComponent.getChildren()) {
            Object selectItemsValue;
            if (nextSelectItemChild instanceof UISelectItem) {
                Object selectItemValue = ((UISelectItem)nextSelectItemChild).getValue();
                if (selectItemValue != null && selectItemValue instanceof SelectItem) {
                    selectItems.add(selectItemValue);
                    continue;
                }
                selectItems.add(new SelectItem(((UISelectItem)nextSelectItemChild).getItemValue(), ((UISelectItem)nextSelectItemChild).getItemLabel(), ((UISelectItem)nextSelectItemChild).getItemDescription(), ((UISelectItem)nextSelectItemChild).isItemDisabled()));
                continue;
            }
            if (!(nextSelectItemChild instanceof UISelectItems) || (selectItemsValue = ((UISelectItems)nextSelectItemChild).getValue()) == null) continue;
            if (selectItemsValue instanceof SelectItem) {
                selectItems.add(selectItemsValue);
                continue;
            }
            if (selectItemsValue instanceof Collection) {
                Iterator selectItemsIterator = ((Collection)selectItemsValue).iterator();
                while (selectItemsIterator.hasNext()) {
                    selectItems.add(selectItemsIterator.next());
                }
                continue;
            }
            if (selectItemsValue instanceof SelectItem[]) {
                SelectItem[] selectItemArray = (SelectItem[])selectItemsValue;
                for (int i = 0; i < selectItemArray.length; ++i) {
                    selectItems.add(selectItemArray[i]);
                }
                continue;
            }
            if (!(selectItemsValue instanceof Map)) continue;
            for (Object nextKey : ((Map)selectItemsValue).keySet()) {
                Object nextValue;
                if (nextKey == null || (nextValue = ((Map)selectItemsValue).get(nextKey)) == null) continue;
                selectItems.add(new SelectItem((Object)nextValue.toString(), nextKey.toString()));
            }
        }
        return selectItems;
    }
}

