/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.dataexporter;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.MethodExpression;
import javax.faces.application.Resource;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.icefaces.ace.component.column.Column;
import org.icefaces.ace.component.columngroup.ColumnGroup;
import org.icefaces.ace.component.dataexporter.Exporter;
import org.icefaces.ace.component.dataexporter.ExporterResource;
import org.icefaces.ace.component.datatable.DataTable;
import org.icefaces.ace.component.row.Row;
import org.icefaces.application.ResourceRegistry;

public class CSVExporter
extends Exporter {
    @Override
    public String export(FacesContext facesContext, DataTable table, String filename, boolean pageOnly, int[] excludeColumns, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor, boolean includeHeaders, boolean includeFooters, boolean selectedRowsOnly) throws IOException {
        String rowIndexVar;
        StringBuilder builder = new StringBuilder();
        List<UIColumn> columns = this.getColumnsToExport(table, excludeColumns);
        if (includeHeaders) {
            ColumnGroup columnGroup = this.getColumnGroupHeader(table);
            if (columnGroup != null) {
                List<Row> rows = this.getRows(columnGroup);
                for (Row row : rows) {
                    List<UIColumn> rowColumns = this.getRowColumnsToExport(row, table, excludeColumns);
                    this.addFacetColumns(builder, rowColumns, Exporter.ColumnType.HEADER);
                }
            } else {
                this.addFacetColumns(builder, columns, Exporter.ColumnType.HEADER);
            }
        }
        int rowCount = table.getRowCount();
        int first = pageOnly ? table.getFirst() : 0;
        int size = pageOnly ? first + table.getRows() : rowCount;
        size = size > rowCount ? rowCount : size;
        Object originalData = null;
        if (selectedRowsOnly) {
            originalData = table.getModel().getWrappedData();
            table.getModel().setWrappedData((Object)table.getStateMap().getSelected());
            first = 0;
            size = table.getRowCount();
        }
        rowIndexVar = (rowIndexVar = table.getRowIndexVar()) == null ? "" : rowIndexVar;
        for (int i = first; i < size; ++i) {
            table.setRowIndex(i);
            if (!"".equals(rowIndexVar)) {
                facesContext.getExternalContext().getRequestMap().put(rowIndexVar, i);
            }
            this.addColumnValues(builder, columns);
            builder.append("\n");
        }
        if (selectedRowsOnly) {
            table.getModel().setWrappedData(originalData);
        }
        if (this.hasColumnFooter(columns) && includeFooters) {
            this.addFacetColumns(builder, columns, Exporter.ColumnType.FOOTER);
        }
        table.setRowIndex(-1);
        byte[] bytes = builder.toString().getBytes();
        ExporterResource resource = new ExporterResource(bytes);
        resource.setContentType("text/csv");
        Map<String, String> headers = resource.getResponseHeaders();
        headers.put("Expires", "0");
        headers.put("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        headers.put("Pragma", "public");
        headers.put("Content-disposition", "attachment; filename=\"" + filename + ".csv\"");
        String path = ResourceRegistry.addSessionResource((Resource)resource);
        return path;
    }

    private void addColumnValues(StringBuilder builder, List<UIColumn> columns) throws IOException {
        Iterator<UIColumn> iterator = columns.iterator();
        while (iterator.hasNext()) {
            this.addColumnValue(builder, iterator.next().getChildren());
            if (!iterator.hasNext()) continue;
            builder.append(",");
        }
    }

    private void addFacetColumns(StringBuilder builder, List<UIColumn> columns, Exporter.ColumnType columnType) throws IOException {
        Iterator<UIColumn> iterator = columns.iterator();
        while (iterator.hasNext()) {
            UIColumn uiColumn = iterator.next();
            UIComponent facet = uiColumn.getFacet(columnType.facet());
            if (facet != null) {
                this.addColumnValue(builder, facet);
            } else {
                String value = "";
                if (uiColumn instanceof Column) {
                    Column column = (Column)uiColumn;
                    if (columnType == Exporter.ColumnType.HEADER) {
                        String headerText = column.getHeaderText();
                        value = headerText != null ? headerText : "";
                    } else if (columnType == Exporter.ColumnType.FOOTER) {
                        String footerText = column.getFooterText();
                        value = footerText != null ? footerText : "";
                    }
                }
                builder.append("\"" + value + "\"");
            }
            if (!iterator.hasNext()) continue;
            builder.append(",");
        }
        builder.append("\n");
    }

    private void addColumnValue(StringBuilder builder, UIComponent component) throws IOException {
        String value = component == null ? "" : this.exportValue(FacesContext.getCurrentInstance(), component);
        builder.append("\"" + value + "\"");
    }

    private void addColumnValue(StringBuilder builder, List<UIComponent> components) throws IOException {
        StringBuilder builder1 = new StringBuilder();
        for (UIComponent component : components) {
            if (!component.isRendered()) continue;
            String value = this.exportValue(FacesContext.getCurrentInstance(), component);
            builder1.append(value);
        }
        builder.append("\"" + builder1.toString() + "\"");
    }
}

