/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.datatable;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.model.DataModel;
import org.icefaces.ace.component.column.Column;
import org.icefaces.ace.component.columngroup.ColumnGroup;
import org.icefaces.ace.component.datatable.DataTable;
import org.icefaces.ace.component.row.Row;
import org.icefaces.ace.component.tableconfigpanel.TableConfigPanel;
import org.icefaces.ace.context.RequestContext;
import org.icefaces.ace.event.SelectEvent;
import org.icefaces.ace.event.UnselectEvent;
import org.icefaces.ace.model.table.RowState;
import org.icefaces.ace.model.table.RowStateMap;
import org.icefaces.ace.model.table.TreeDataModel;

public class DataTableDecoder {
    static void decodeSelection(FacesContext context, DataTable table) {
        String clientId = table.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String selection = (String)params.get(clientId + "_selection");
        if (table.isSingleSelectionMode()) {
            DataTableDecoder.decodeSingleSelection(table, selection, (String)params.get(clientId + "_deselection"));
        } else {
            DataTableDecoder.decodeMultipleSelection(table, selection, (String)params.get(clientId + "_deselection"));
        }
        DataTableDecoder.queueInstantSelectionEvent(context, table, clientId, params);
    }

    static void queueInstantSelectionEvent(FacesContext context, DataTable table, String clientId, Map<String, String> params) {
        if (table.isInstantSelectionRequest(context)) {
            DataModel model = table.getDataModel();
            TreeDataModel treeModel = null;
            String selection = params.get(clientId + "_instantSelectedRowIndexes");
            String[] indexes = selection.split(",");
            Object[] objs = new Object[indexes.length];
            for (int i = 0; i < indexes.length; ++i) {
                String index = indexes[i];
                if (table.hasTreeDataModel().booleanValue() && selection.indexOf(46) > 0) {
                    treeModel = (TreeDataModel)model;
                    int lastSepIndex = index.lastIndexOf(46);
                    treeModel.setRootIndex(index.substring(0, lastSepIndex));
                    index = index.substring(lastSepIndex + 1);
                }
                table.setRowIndex(Integer.parseInt(index));
                objs[i] = table.getRowData();
            }
            SelectEvent selectEvent = new SelectEvent((UIComponent)table, objs);
            selectEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
            table.queueEvent(selectEvent);
            if (treeModel != null) {
                treeModel.setRootIndex(null);
            }
        } else if (table.isInstantUnselectionRequest(context)) {
            DataModel model = table.getDataModel();
            TreeDataModel treeModel = null;
            String selection = params.get(clientId + "_instantUnselectedRowIndexes");
            if (table.hasTreeDataModel().booleanValue() && selection.indexOf(46) > 0) {
                treeModel = (TreeDataModel)model;
                int lastSepIndex = selection.lastIndexOf(46);
                treeModel.setRootIndex(selection.substring(0, lastSepIndex));
                selection = selection.substring(lastSepIndex + 1);
            }
            int unselectedRowIndex = Integer.parseInt(selection);
            table.setRowIndex(unselectedRowIndex);
            UnselectEvent unselectEvent = new UnselectEvent((UIComponent)table, table.getRowData());
            unselectEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
            table.queueEvent(unselectEvent);
            if (treeModel != null) {
                treeModel.setRootIndex(null);
            }
        }
        table.setRowIndex(-1);
    }

    static void decodeSingleSelection(DataTable table, String selection, String deselection) {
        RowStateMap stateMap = table.getStateMap();
        if (DataTableDecoder.isValueBlank(selection)) {
            if (!deselection.equals("")) {
                stateMap.setAllSelected(false);
            }
        } else if (table.isCellSelection()) {
            table.clearCellSelection();
            table.addSelectedCell(selection);
            if (deselection != null && deselection.length() > 0) {
                table.removeSelectedCell(deselection);
            }
        } else {
            TreeDataModel treeModel = null;
            DataModel model = table.getDataModel();
            if (table.hasTreeDataModel().booleanValue()) {
                treeModel = (TreeDataModel)model;
            }
            if (treeModel != null & selection.indexOf(46) > 0) {
                int lastSepIndex = selection.lastIndexOf(46);
                treeModel.setRootIndex(selection.substring(0, lastSepIndex));
                selection = selection.substring(lastSepIndex + 1);
            }
            stateMap.setAllSelected(false);
            int selectedRowIndex = Integer.parseInt(selection);
            table.setRowIndex(selectedRowIndex);
            Object rowData = table.getRowData();
            RowState state = stateMap.get(rowData);
            if (state.isSelectable()) {
                state.setSelected(true);
            }
            if (treeModel != null) {
                treeModel.setRootIndex(null);
            }
            table.setRowIndex(-1);
        }
    }

    static void decodeMultipleSelection(DataTable table, String selection, String deselection) {
        DataModel value = table.getDataModel();
        TreeDataModel model = null;
        if (table.hasTreeDataModel().booleanValue()) {
            model = (TreeDataModel)value;
        }
        RowStateMap stateMap = table.getStateMap();
        if (!DataTableDecoder.isValueBlank(selection)) {
            if (table.isCellSelection()) {
                table.addSelectedCells(selection.split(","));
            } else {
                String[] rowSelectValues;
                for (String s : rowSelectValues = selection.split(",")) {
                    if (s.indexOf(".") != -1 && model != null) {
                        int lastSepIndex = s.lastIndexOf(46);
                        model.setRootIndex(s.substring(0, lastSepIndex));
                        s = s.substring(lastSepIndex + 1);
                    }
                    table.setRowIndex(Integer.parseInt(s));
                    RowState state = stateMap.get(table.getRowData());
                    if (!state.isSelected() && state.isSelectable()) {
                        state.setSelected(true);
                    }
                    if (model == null) continue;
                    model.setRootIndex(null);
                }
                table.setRowIndex(-1);
            }
        }
        if (table.isCellSelection()) {
            if (deselection != null && deselection.length() > 0) {
                table.removeSelectedCells(deselection.split(","));
            }
        } else {
            String[] rowDeselectValues = new String[]{};
            if (deselection != null && !deselection.equals("")) {
                rowDeselectValues = deselection.split(",");
            }
            boolean x = false;
            for (String s : rowDeselectValues) {
                if (s.indexOf(".") != -1 && model != null) {
                    int lastSepIndex = s.lastIndexOf(46);
                    model.setRootIndex(s.substring(0, lastSepIndex));
                    s = s.substring(lastSepIndex + 1);
                }
                table.setRowIndex(Integer.parseInt(s));
                RowState state = stateMap.get(table.getRowData());
                if (state.isSelected()) {
                    state.setSelected(false);
                }
                if (model == null) continue;
                model.setRootIndex(null);
            }
            table.setRowIndex(-1);
        }
    }

    static boolean isValueBlank(String value) {
        if (value == null) {
            return true;
        }
        return value.trim().equals("");
    }

    static void decodeFilters(FacesContext context, DataTable table) {
        String clientId = table.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String filteredId = (String)params.get(clientId + "_filteredColumn");
        Column filteredColumn = null;
        table.setFirst(0);
        table.setPage(1);
        if (table.isLazy()) {
            Map<String, Column> filterMap = table.getFilterMap();
            filteredColumn = filterMap.get(filteredId);
            if (filteredColumn != null) {
                filteredColumn.setFilterValue(((String)params.get(filteredId)).toLowerCase());
            }
            if (table.isPaginator() && RequestContext.getCurrentInstance() != null) {
                RequestContext.getCurrentInstance().addCallbackParam("totalRecords", table.getRowCount());
            }
        } else {
            Map<String, Column> filterMap = table.getFilterMap();
            filteredColumn = filterMap.get(filteredId);
            if (filteredColumn != null) {
                filteredColumn.setFilterValue(((String)params.get(filteredId)).toLowerCase());
            }
            String globalFilter = (String)params.get(clientId + UINamingContainer.getSeparatorChar((FacesContext)context) + "globalFilter");
            table.setFilterValue(globalFilter);
            table.applyFilters();
        }
    }

    static void decodeSortRequest(FacesContext context, DataTable table, String clientId, String sortKeysInput) {
        List<Object> columns = new ArrayList();
        Map params = context.getExternalContext().getRequestParameterMap();
        ColumnGroup group = table.getColumnGroup("header");
        Column sortColumn = null;
        if (clientId == null) {
            clientId = table.getClientId(context);
        }
        String[] sortKeys = sortKeysInput != null ? sortKeysInput.split(",") : ((String)params.get(clientId + "_sortKeys")).split(",");
        String[] sortDirs = ((String)params.get(clientId + "_sortDirs")).split(",");
        if (group != null) {
            for (Object c : group.getChildren()) {
                if (!(c instanceof Row)) continue;
                for (UIComponent rc : c.getChildren()) {
                    if (!(rc instanceof Column)) continue;
                    columns.add((Object)((Column)rc));
                }
            }
        } else {
            columns = table.getColumns();
        }
        for (Object c : columns) {
            ((Column)((Object)c)).setSortPriority(null);
        }
        if (sortKeys[0].equals("")) {
            return;
        }
        int i = 0;
        for (String sortKey : sortKeys) {
            block13: {
                if (group != null) {
                    for (UIComponent child : group.getChildren()) {
                        for (UIComponent headerRowChild : ((Row)child).getChildren()) {
                            if (!(headerRowChild instanceof Column) || !headerRowChild.getClientId(context).equals(sortKey)) continue;
                            sortColumn = (Column)headerRowChild;
                            break block13;
                        }
                    }
                } else {
                    for (Column column : table.getColumns()) {
                        if (!column.getClientId(context).equals(sortKey)) continue;
                        sortColumn = column;
                        break;
                    }
                }
            }
            sortColumn.setSortPriority(i + 1);
            sortColumn.setSortAscending(Boolean.parseBoolean(sortDirs[i]));
            ++i;
        }
    }

    static void decodePageRequest(FacesContext context, DataTable table) {
        String clientId = table.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String rowsParam = (String)params.get(clientId + "_rows");
        String pageParam = (String)params.get(clientId + "_page");
        table.setRows(Integer.valueOf(rowsParam));
        table.setPage(Integer.valueOf(pageParam));
        table.setFirst((table.getPage() - 1) * table.getRows());
    }

    static void decodeColumnReorderRequest(FacesContext context, DataTable table) {
        String clientId = table.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        List ordering = table.getColumnOrdering();
        String[] columnTargets = ((String)params.get(clientId + "_columnReorder")).split("-");
        Integer columnIndex = (Integer)ordering.remove(Integer.parseInt(columnTargets[0]));
        ordering.add(Integer.parseInt(columnTargets[1]), columnIndex);
        table.setColumnOrdering(ordering);
    }

    static void decodeTableConfigurationRequest(FacesContext context, DataTable table) {
        TableConfigPanel tableConfigPanel = table.findTableConfigPanel(context);
        DataTableDecoder.decodeColumnConfigurations(context, table, tableConfigPanel);
    }

    private static void decodeColumnConfigurations(FacesContext context, DataTable table, TableConfigPanel panel) {
        String clientId = table.getClientId(context);
        List<Column> columns = table.getColumns();
        Map params = context.getExternalContext().getRequestParameterMap();
        boolean visibility = panel.isColumnVisibilityConfigurable();
        boolean ordering = panel.isColumnOrderingConfigurable();
        boolean sizing = false;
        boolean name = panel.isColumnNameConfigurable();
        boolean firstCol = panel.getType().equals("first-col");
        boolean lastCol = panel.getType().equals("last-col");
        boolean sorting = panel.isColumnSortingConfigurable();
        for (int i = 0; i < columns.size(); ++i) {
            Column column = columns.get(i);
            if (!column.isConfigurable()) continue;
            boolean disableVisibilityControl = firstCol && i == 0 || lastCol && i == columns.size() - 1;
            String panelId = panel.getClientId();
            if (visibility && !disableVisibilityControl) {
                DataTableDecoder.decodeColumnVisibility(params, column, i, panelId);
            }
            if (sizing) {
                DataTableDecoder.decodeColumnSizing(params, column, i, panelId);
            }
            if (!name) continue;
            DataTableDecoder.decodeColumnName(params, column, i, panelId);
        }
        if (ordering) {
            DataTableDecoder.decodeColumnOrdering(params, table, clientId);
        }
        if (sorting) {
            DataTableDecoder.decodeSortRequest(context, table, clientId, DataTableDecoder.processConfigPanelSortKeys(clientId, params, table));
        }
    }

    private static void decodeColumnName(Map<String, String> params, Column column, int i, String clientId) {
        String text = params.get(clientId + "_head_" + i);
        column.setHeaderText(text);
    }

    private static void decodeColumnOrdering(Map<String, String> params, DataTable table, String clientId) {
        String[] indexes = params.get(clientId + "_colorder").split(",");
        table.setColumnOrdering(indexes);
    }

    private static void decodeColumnSizing(Map<String, String> params, Column column, int i, String clientId) {
    }

    private static void decodeColumnVisibility(Map<String, String> params, Column column, int i, String clientId) {
        String code = params.get(clientId + "_colvis_" + i);
        if (code == null) {
            column.setRendered(false);
        } else {
            column.setRendered(true);
        }
    }

    private static String processConfigPanelSortKeys(String clientId, Map<String, String> params, DataTable table) {
        String[] sortKeys = params.get(clientId + "_sortKeys").split(",");
        List<Column> columns = table.getColumns();
        String newSortKeys = "";
        for (String key : sortKeys) {
            if (key.length() <= 0) continue;
            newSortKeys = newSortKeys.length() == 0 ? columns.get(Integer.parseInt(key)).getClientId() : newSortKeys + "," + columns.get(Integer.parseInt(key)).getClientId();
        }
        return newSortKeys;
    }
}

