/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.datatable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import org.icefaces.ace.component.column.Column;
import org.icefaces.ace.component.columngroup.ColumnGroup;
import org.icefaces.ace.component.datatable.DataTable;
import org.icefaces.ace.component.datatable.DataTableRendererUtil;
import org.icefaces.ace.component.row.Row;
import org.icefaces.ace.component.tableconfigpanel.TableConfigPanel;
import org.icefaces.ace.renderkit.CoreRenderer;

public class DataTableHeadRenderer {
    protected static void encodeTableHead(FacesContext context, DataTable table, List<Column> columns, boolean staticHeaders) throws IOException {
        if (!table.hasHeaders()) {
            return;
        }
        List headContainer = columns;
        ResponseWriter writer = context.getResponseWriter();
        ColumnGroup group = table.getColumnGroup("header");
        if (group != null) {
            headContainer = group.getChildren();
        }
        if (staticHeaders) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-datatable-scrollable-header", null);
            writer.startElement("table", null);
        }
        writer.startElement("thead", null);
        if (table.isInDuplicateSegment().booleanValue()) {
            writer.writeAttribute("style", (Object)"display:none;", null);
        }
        boolean firstHeadElement = true;
        boolean subRows = false;
        Iterator headElementIterator = headContainer.iterator();
        do {
            UIComponent headerElem = (UIComponent)headElementIterator.next();
            List headerRowChildren = new ArrayList<UIComponent>();
            boolean i = false;
            if (!headerElem.isRendered()) continue;
            if (headerElem instanceof Row) {
                Row headerRow = (Row)headerElem;
                headerRowChildren = headerRow.getChildren();
                subRows = true;
            } else {
                headerRowChildren.add(headerElem);
            }
            if (subRows || firstHeadElement) {
                writer.startElement("tr", null);
            }
            Iterator componentIterator = headerRowChildren.iterator();
            boolean firstComponent = true;
            while (componentIterator.hasNext()) {
                UIComponent headerRowChild = (UIComponent)componentIterator.next();
                if (headerRowChild.isRendered() && headerRowChild instanceof Column) {
                    DataTableHeadRenderer.encodeColumn(context, table, subRows ? headerRowChildren : headContainer, (Column)headerRowChild, firstComponent && firstHeadElement, !headElementIterator.hasNext() && !componentIterator.hasNext(), subRows);
                }
                firstComponent = false;
            }
            firstHeadElement = false;
            if (!subRows) continue;
            writer.endElement("tr");
        } while (headElementIterator.hasNext());
        if (!subRows) {
            writer.endElement("tr");
        }
        writer.endElement("thead");
        if (staticHeaders) {
            writer.endElement("table");
            writer.endElement("div");
        }
    }

    private static void encodeColumn(FacesContext context, DataTable table, List columnSiblings, Column column, boolean first, boolean last, boolean subRows) throws IOException {
        TableConfigPanel panel;
        boolean isNextStacked;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = column.getClientId(context);
        boolean isSortable = column.getValueExpression("sortBy") != null;
        boolean hasFilter = column.getValueExpression("filterBy") != null;
        int rightHeaderPadding = 0;
        int leftHeaderPadding = 0;
        Column nextColumn = DataTableRendererUtil.getNextColumn(column, columnSiblings);
        boolean isCurrStacked = DataTableRendererUtil.isCurrColumnStacked(columnSiblings, column);
        boolean bl = nextColumn == null ? false : (isNextStacked = nextColumn.isRendered() && nextColumn.isStacked());
        if (!isCurrStacked) {
            String style = column.getStyle();
            String styleClass = column.getStyleClass();
            String columnClass = "ui-widget-header";
            columnClass = table.isReorderableColumns() && column.isReorderable() ? columnClass + " " + "ui-reorderable-col" : columnClass;
            columnClass = styleClass != null ? columnClass + " " + styleClass : columnClass;
            columnClass = column.getSortPriority() != null && !isNextStacked ? columnClass + " ui-state-active" : columnClass;
            writer.startElement("th", null);
            writer.writeAttribute("class", (Object)columnClass, null);
            if (style != null) {
                writer.writeAttribute("style", (Object)style, null);
            }
            if (column.getRowspan() != 1) {
                writer.writeAttribute("rowspan", (Object)column.getRowspan(), null);
            }
            if (column.getColspan() != 1) {
                writer.writeAttribute("colspan", (Object)column.getColspan(), null);
            }
        } else {
            writer.startElement("hr", null);
            writer.endElement("hr");
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        String columnClass = "ui-header-column";
        columnClass = isSortable ? columnClass + " " + "ui-sortable-column" : columnClass;
        columnClass = table.isClickableHeaderSorting() ? columnClass + " clickable" : columnClass;
        columnClass = column.getSortPriority() != null && (isCurrStacked || isNextStacked) ? columnClass + " ui-state-active" : columnClass;
        writer.writeAttribute("class", (Object)columnClass, null);
        writer.startElement("span", null);
        boolean writeConfigPanelLaunchOnLeft = false;
        if (first && (panel = table.findTableConfigPanel(context)) != null && panel.getType().equals("first-col")) {
            leftHeaderPadding += 35;
            writeConfigPanelLaunchOnLeft = true;
        }
        if (last && (panel = table.findTableConfigPanel(context)) != null && panel.getType().equals("last-col")) {
            rightHeaderPadding += 35;
        }
        String paddingStyle = "";
        if (leftHeaderPadding > 0) {
            paddingStyle = paddingStyle + "padding-left:" + leftHeaderPadding + "px;";
        }
        if (!paddingStyle.equals("")) {
            writer.writeAttribute("style", (Object)paddingStyle, null);
        }
        if (writeConfigPanelLaunchOnLeft) {
            DataTableHeadRenderer.encodeConfigPanelLaunchButton(writer, table, first);
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-header-text", null);
        UIComponent header = column.getFacet("header");
        String headerText = column.getHeaderText();
        if (header != null) {
            header.encodeAll(context);
        } else if (headerText != null) {
            writer.write(headerText);
        } else if (subRows) {
            for (UIComponent c : column.getChildren()) {
                c.encodeAll(context);
            }
        }
        writer.endElement("span");
        writer.endElement("span");
        if (isSortable || DataTableHeadRenderer.isLastColConfPanel(context, table)) {
            DataTableHeadRenderer.encodeRightSideControls(writer, context, table, column, isSortable, last);
        }
        if (hasFilter) {
            DataTableHeadRenderer.encodeFilter(context, table, column);
        }
        writer.endElement("div");
        if (!isNextStacked) {
            writer.endElement("th");
        } else if (subRows) {
            if (!DataTableRendererUtil.areBothSingleColumnSpan(column, nextColumn)) {
                throw new FacesException("DataTable : \"" + table.getClientId(context) + "\" must not have stacked header columns, with colspan values greater than 1.");
            }
            if (!DataTableRendererUtil.isNextColumnRowSpanEqual(column, nextColumn)) {
                throw new FacesException("DataTable : \"" + table.getClientId(context) + "\" must not have stacked header columns, with unequal rowspan values.");
            }
        }
    }

    private static void encodeRightSideControls(ResponseWriter writer, FacesContext context, DataTable table, Column column, boolean sortable, boolean last) throws IOException {
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-header-right", null);
        if (sortable) {
            DataTableHeadRenderer.encodeSortControl(writer, context, table, column);
        }
        if (last && DataTableHeadRenderer.isLastColConfPanel(context, table)) {
            DataTableHeadRenderer.encodeConfigPanelLaunchButton(writer, table, false);
        }
        writer.endElement("span");
    }

    private static void encodeSortControl(ResponseWriter writer, FacesContext context, DataTable table, Column column) throws IOException {
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-sortable-control", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-sortable-column-icon", null);
        writer.startElement("a", null);
        writer.writeAttribute("tabindex", (Object)0, null);
        if (column.getSortPriority() != null && column.isSortAscending().booleanValue()) {
            writer.writeAttribute("class", (Object)"ui-icon ui-icon-triangle-1-n ui-toggled", null);
        } else {
            writer.writeAttribute("class", (Object)"ui-icon ui-icon-triangle-1-n", null);
        }
        writer.endElement("a");
        writer.startElement("a", null);
        writer.writeAttribute("tabindex", (Object)0, null);
        if (column.getSortPriority() != null && !column.isSortAscending().booleanValue()) {
            writer.writeAttribute("class", (Object)"ui-icon ui-icon-triangle-1-s ui-toggled", null);
        } else {
            writer.writeAttribute("class", (Object)"ui-icon ui-icon-triangle-1-s", null);
        }
        writer.endElement("a");
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-sortable-column-order", null);
        if (table.isSingleSort()) {
            writer.writeAttribute("style", (Object)"display:none;", null);
        } else if (column.getSortPriority() != null) {
            writer.writeText((Object)column.getSortPriority(), null);
        }
        writer.endElement("span");
        writer.endElement("span");
    }

    private static void encodeFilter(FacesContext context, DataTable table, Column column) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        ResponseWriter writer = context.getResponseWriter();
        String widgetVar = CoreRenderer.resolveWidgetVar((UIComponent)table);
        String filterId = column.getClientId(context) + "_filter";
        String filterFunction = widgetVar + ".filter(event)";
        String filterStyleClass = column.getFilterStyleClass();
        String filterEvent = table.getFilterEvent();
        String string = filterStyleClass = filterStyleClass == null ? "ui-column-filter" : "ui-column-filter " + filterStyleClass;
        if (column.getValueExpression("filterOptions") == null) {
            String filterValue = column.getFilterValue() != null ? column.getFilterValue() : "";
            writer.startElement("input", null);
            writer.writeAttribute("id", (Object)filterId, null);
            writer.writeAttribute("name", (Object)filterId, null);
            writer.writeAttribute("class", (Object)filterStyleClass, null);
            writer.writeAttribute("size", (Object)"1", null);
            writer.writeAttribute("value", (Object)filterValue, null);
            if (filterEvent.equals("keyup") || filterEvent.equals("blur")) {
                writer.writeAttribute("on" + filterEvent, (Object)filterFunction, null);
            }
            if (column.getFilterStyle() != null) {
                writer.writeAttribute("style", (Object)column.getFilterStyle(), null);
            }
            writer.endElement("input");
        } else {
            SelectItem[] itemsArray;
            writer.startElement("select", null);
            writer.writeAttribute("id", (Object)filterId, null);
            writer.writeAttribute("name", (Object)filterId, null);
            writer.writeAttribute("class", (Object)filterStyleClass, null);
            writer.writeAttribute("onchange", (Object)filterFunction, null);
            for (SelectItem item : itemsArray = DataTableHeadRenderer.getFilterOptions(column)) {
                writer.startElement("option", null);
                writer.writeAttribute("value", item.getValue(), null);
                writer.write(item.getLabel());
                writer.endElement("option");
            }
            writer.endElement("select");
        }
    }

    protected static void encodeConfigPanelLaunchButton(ResponseWriter writer, DataTable component, boolean first) throws IOException {
        String jsId = CoreRenderer.resolveWidgetVar((UIComponent)component);
        String panelJsId = CoreRenderer.resolveWidgetVar((UIComponent)component.findTableConfigPanel(FacesContext.getCurrentInstance()));
        String clientId = component.findTableConfigPanel(FacesContext.getCurrentInstance()).getClientId();
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-tableconf-button", null);
        writer.writeAttribute("style", (Object)(first ? "left:0;" : "right:0;"), null);
        writer.startElement("a", null);
        writer.writeAttribute("class", (Object)"ui-state-default ui-corner-all", null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("onclick", (Object)("ice.ace.jq(ice.ace.escapeClientId('" + clientId + "')).toggle()"), null);
        writer.writeAttribute("id", (Object)(clientId + "_tableconf_launch"), null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-gear", null);
        writer.endElement("span");
        writer.endElement("a");
        writer.endElement("span");
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeText((Object)("ice.ace.jq(function() {\n\tice.ace.jq(ice.ace.escapeClientId('" + clientId + "_tableconf_launch')).hover(function(event){ice.ace.jq(event.currentTarget).toggleClass('ui-state-hover'); event.stopPropagation(); }).click(function(event){ice.ace.jq(event.currentTarget).toggleClass('ui-state-active'); var panel = ice.ace.jq(ice.ace.escapeClientId('" + clientId + "')); if (panel.is(':not(:visible)')) " + panelJsId + ".submitTableConfig(event.currentTarget); else if (" + panelJsId + ".behaviors) if (" + panelJsId + ".behaviors.open) " + panelJsId + ".behaviors.open(); event.stopPropagation(); });\n" + "});"), null);
        writer.endElement("script");
    }

    private static boolean isLastColConfPanel(FacesContext context, DataTable table) {
        TableConfigPanel panel = table.findTableConfigPanel(context);
        return panel != null && panel.getType().equals("last-col");
    }

    private static SelectItem[] getFilterOptions(Column column) {
        Object options = column.getFilterOptions();
        if (options instanceof SelectItem[]) {
            return (SelectItem[])options;
        }
        if (options instanceof Collection) {
            return ((Collection)column.getFilterOptions()).toArray(new SelectItem[0]);
        }
        throw new FacesException("Filter options for column " + column.getClientId() + " should be a SelectItem array or collection");
    }
}

