/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.fileentry;

import java.io.IOException;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import org.icefaces.ace.component.fileentry.PushUtils;
import org.icefaces.ace.util.ScriptWriter;
import org.icefaces.ace.util.Utils;

public class FormScriptWriter
extends UIOutput {
    private String disablingAttribute;
    private String id;
    private static final Logger Log = Logger.getLogger(FormScriptWriter.class.getName());

    public FormScriptWriter(String disablingAttribute, String id) {
        this.disablingAttribute = disablingAttribute;
        this.id = id;
        if (id != null) {
            this.setId(id);
        } else {
            this.setId(FacesContext.getCurrentInstance().getViewRoot().createUniqueId());
        }
        this.setTransient(true);
        this.setRendererType(null);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        UIForm form = Utils.findParentForm((UIComponent)this);
        if (form == null) {
            return;
        }
        String formClientId = form.getClientId(context);
        if (this.disablingAttribute != null && this.disablingAttribute.length() > 0 && form.getAttributes().get(this.disablingAttribute) != null) {
            return;
        }
        String progressResourcePath = "";
        String progressPushId = "";
        if (PushUtils.isPushPresent()) {
            progressResourcePath = PushUtils.getProgressResourcePath(context, (UIComponent)form);
            progressPushId = PushUtils.getPushId(context, (UIComponent)form);
        }
        String iframeClientIdSuffix = UINamingContainer.getSeparatorChar((FacesContext)context) + "hiddenIframe";
        String script = "ice.ace.fileentry.captureFormOnsubmit('" + formClientId + "', '" + formClientId + iframeClientIdSuffix + "', '" + progressPushId + "', '" + progressResourcePath + "');";
        ScriptWriter.insertScript(context, (UIComponent)this, script, this.getClientId(context));
    }

    public void encodeEnd(FacesContext context) throws IOException {
    }
}

