/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.fileentry;

import java.lang.reflect.Method;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.icefaces.ace.component.fileentry.FileEntry;
import org.icefaces.ace.component.fileentry.ProgressResource;
import org.icefaces.application.ResourceRegistry;
import org.icefaces.util.EnvUtils;

class PushUtils {
    static String PROGRESS_PREFIX = "org.icefaces.ace.component.fileentry.progress.";
    private static final String COMPONENT_ATTRIBUTE_PROGRESS_RESOURCE_PATH = PROGRESS_PREFIX + "path_";
    private static final String COMPONENT_ATTRIBUTE_PROGRESS_PUSH_ID = PROGRESS_PREFIX + "push_id_";
    private static final String COMPONENT_ATTRIBUTE_PROGRESS_GROUP_NAME = PROGRESS_PREFIX + "group_name_";
    private static final String PROGRESS_GROUP_NAME_PREFIX = PROGRESS_PREFIX + "group_name.";
    private static Class org_icepush_PushContext_class;
    private static Method org_icepush_PushContext_getInstance_method;
    private static Method org_icepush_PushContext_createPushId_method;
    private static Method org_icepush_PushContext_addGroupMember_method;
    private static Method org_icepush_PushContext_removeGroupMember_method;
    private static Method org_icepush_PushContext_push_method;

    PushUtils() {
    }

    static boolean isPushPresent() {
        return org_icepush_PushContext_class != null;
    }

    static String getProgressResourcePath(FacesContext context, UIComponent comp) {
        String attribKey = COMPONENT_ATTRIBUTE_PROGRESS_RESOURCE_PATH + comp.getClientId(context);
        String resPath = (String)comp.getAttributes().get(attribKey);
        if (resPath == null) {
            String identifier = FileEntry.getGloballyUniqueComponentIdentifier(context, comp.getClientId(context));
            ProgressResource res = new ProgressResource(identifier);
            resPath = ResourceRegistry.addSessionResource((Resource)res);
            comp.getAttributes().put(attribKey, resPath);
        }
        return resPath;
    }

    static String getPushId(FacesContext context, UIComponent comp) {
        String attribKey = COMPONENT_ATTRIBUTE_PROGRESS_PUSH_ID + comp.getClientId(context);
        String pushId = (String)comp.getAttributes().get(attribKey);
        if (pushId == null && (pushId = PushUtils.createPushId()) != null) {
            comp.getAttributes().put(attribKey, pushId);
            String groupName = PushUtils.getPushGroupName(context, comp);
            PushUtils.addPushGroupMember(groupName, pushId);
        }
        return pushId;
    }

    static String getPushGroupName(FacesContext context, UIComponent comp) {
        String attribKey = COMPONENT_ATTRIBUTE_PROGRESS_GROUP_NAME + comp.getClientId(context);
        String groupName = (String)comp.getAttributes().get(attribKey);
        if (groupName == null) {
            String identifier = FileEntry.getGloballyUniqueComponentIdentifier(context, comp.getClientId(context));
            groupName = PROGRESS_GROUP_NAME_PREFIX + identifier;
            comp.getAttributes().put(attribKey, groupName);
        }
        return groupName;
    }

    static String createPushId() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        HttpServletRequest request = EnvUtils.getSafeRequest((FacesContext)facesContext);
        HttpServletResponse response = EnvUtils.getSafeResponse((FacesContext)facesContext);
        String id = null;
        try {
            Object pushContext = PushUtils.reflectPushContextInstance();
            if (pushContext != null) {
                id = (String)org_icepush_PushContext_createPushId_method.invoke(pushContext, request, response);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return id;
    }

    static void addPushGroupMember(String groupName, String pushId) {
        try {
            Object pushContext = PushUtils.reflectPushContextInstance();
            if (pushContext != null) {
                org_icepush_PushContext_addGroupMember_method.invoke(pushContext, groupName, pushId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void removePushGroupMember(String groupName, String pushId) {
        try {
            Object pushContext = PushUtils.reflectPushContextInstance();
            if (pushContext != null) {
                org_icepush_PushContext_removeGroupMember_method.invoke(pushContext, groupName, pushId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void push(String groupName) {
        try {
            Object pushContext = PushUtils.reflectPushContextInstance();
            if (pushContext != null) {
                org_icepush_PushContext_push_method.invoke(pushContext, groupName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Object reflectPushContextInstance() {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        ServletContext servletContext = (ServletContext)externalContext.getContext();
        Object inst = null;
        try {
            if (org_icepush_PushContext_getInstance_method != null) {
                inst = org_icepush_PushContext_getInstance_method.invoke(null, servletContext);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return inst;
    }

    static {
        try {
            org_icepush_PushContext_class = Class.forName("org.icepush.PushContext");
            org_icepush_PushContext_getInstance_method = org_icepush_PushContext_class.getMethod("getInstance", ServletContext.class);
            org_icepush_PushContext_createPushId_method = org_icepush_PushContext_class.getMethod("createPushId", HttpServletRequest.class, HttpServletResponse.class);
            org_icepush_PushContext_addGroupMember_method = org_icepush_PushContext_class.getMethod("addGroupMember", String.class, String.class);
            org_icepush_PushContext_removeGroupMember_method = org_icepush_PushContext_class.getMethod("removeGroupMember", String.class, String.class);
            org_icepush_PushContext_push_method = org_icepush_PushContext_class.getMethod("push", String.class);
        }
        catch (ClassNotFoundException e) {
            org_icepush_PushContext_class = null;
        }
        catch (NoSuchMethodException e) {
            org_icepush_PushContext_class = null;
        }
    }
}

