/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.listcontrol;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.ace.component.list.ACEList;
import org.icefaces.ace.component.listcontrol.DualListPosition;
import org.icefaces.ace.component.listcontrol.ListControl;
import org.icefaces.ace.renderkit.CoreRenderer;
import org.icefaces.ace.util.JSONBuilder;
import org.icefaces.render.MandatoryResourceComponent;

@MandatoryResourceComponent(tagName="listControl", value="org.icefaces.ace.component.listcontrol.ListControl")
public class ListControlRenderer
extends CoreRenderer {
    public static final String containerStyleClass = "if-list-nctrls ui-widget";
    public static final String dualListContainerStyleClass = "if-list-dl-cnt ui-widget";
    public static final String controlStyleClass = "if-list-nctrl";
    public static final String controlsSpacerStyleClass = "if-list-ctrl-spcr";
    public static final String dualListStyleClass = "if-list-dl";
    public static final String listControlHeaderClass = "if-list-nctrl-head";
    public static final String listControlFooterClass = "if-list-nctrl-foot";
    public static final String firstStyleClass = "if-list-dl-1";
    public static final String secondStyleClass = "if-list-dl-2";
    private boolean dualListMode = false;
    private ACEList one;
    private ACEList two;

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ListControl control = (ListControl)component;
        String style = control.getStyle();
        DualListPosition position = control.getPosition();
        String styleClass = control.getStyleClass();
        UIComponent facet = control.getFacet("header");
        this.dualListMode = this.hasTwoListChildren(control);
        styleClass = styleClass == null ? "" : styleClass + " ";
        styleClass = this.dualListMode ? styleClass + dualListContainerStyleClass : styleClass + containerStyleClass;
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)control.getClientId(context), "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeHeader(context, writer, control, facet);
        if (!this.dualListMode || position.equals((Object)DualListPosition.TOP) || position.equals((Object)DualListPosition.BOTH) || position.equals((Object)DualListPosition.ALL)) {
            if (this.dualListMode) {
                writer.startElement("div", null);
                writer.writeAttribute("class", (Object)containerStyleClass.substring(0, containerStyleClass.indexOf(" ")), null);
            }
            this.encodeControls(context, writer, control);
            if (this.dualListMode) {
                writer.endElement("div");
            }
        }
    }

    private boolean hasTwoListChildren(ListControl control) {
        List children = control.getChildren();
        ArrayList<ACEList> lists = new ArrayList<ACEList>();
        for (UIComponent c : children) {
            if (!(c instanceof ACEList)) continue;
            lists.add((ACEList)c);
        }
        if (lists.size() == 2) {
            this.one = (ACEList)lists.get(0);
            this.two = (ACEList)lists.get(1);
            return true;
        }
        if (lists.size() > 2 || lists.size() == 1) {
            throw new FacesException("ListControl " + (Object)((Object)control) + " : " + "Cannot have fewer or greater than 2 ace:list children. The nested list mode only supports dual lists.");
        }
        return false;
    }

    private void encodeHeader(FacesContext context, ResponseWriter writer, ListControl control, UIComponent facet) throws IOException {
        if (facet == null) {
            return;
        }
        String styleClass = control.getHeaderClass();
        styleClass = styleClass == null ? "" : styleClass + " ";
        styleClass = styleClass + listControlHeaderClass;
        String style = control.getHeaderStyle();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)styleClass, "headerClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "headerStyle");
        }
        facet.encodeAll(context);
        writer.endElement("div");
    }

    private void encodeControls(FacesContext context, ResponseWriter writer, ListControl control) throws IOException {
        String styleClass = control.getControlClass();
        styleClass = styleClass == null ? controlStyleClass : styleClass + " " + controlStyleClass;
        for (String code : control.getFormat().split(" ")) {
            this.encodeControl(context, writer, control, code, styleClass);
        }
    }

    private void encodeControl(FacesContext context, ResponseWriter writer, ListControl control, String code, String containerClass) throws IOException {
        String property;
        String styleClass;
        UIComponent facet = null;
        if (code.equals("alll")) {
            styleClass = control.getAllLeftClass();
            facet = control.getFacet("allLeft");
            property = "allLeftClass";
        } else if (code.equals("lft")) {
            styleClass = control.getLeftClass();
            facet = control.getFacet("left");
            property = "leftClass";
        } else if (code.equals("rgt")) {
            styleClass = control.getRightClass();
            facet = control.getFacet("right");
            property = "rightClass";
        } else if (code.equals("allr")) {
            styleClass = control.getAllRightClass();
            facet = control.getFacet("allRight");
            property = "allRightClass";
        } else {
            return;
        }
        if (facet != null) {
            facet.encodeAll(context);
        } else {
            String spacerClass = control.getSpacerClass();
            spacerClass = spacerClass == null ? controlsSpacerStyleClass : spacerClass + " " + controlsSpacerStyleClass;
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)spacerClass, null);
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)("if-list-nctrl-" + code + " " + containerClass), "controlClass");
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)styleClass, property);
            writer.endElement("span");
            writer.endElement("span");
            writer.endElement("span");
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ListControl control = (ListControl)component;
        if (this.dualListMode) {
            this.renderDualListLayout(context, writer, control, this.one, this.two);
        }
    }

    private void renderDualListLayout(FacesContext context, ResponseWriter writer, ListControl control, ACEList one, ACEList two) throws IOException {
        DualListPosition position = control.getPosition();
        Boolean middleMode = position.equals((Object)DualListPosition.MIDDLE) || position.equals((Object)DualListPosition.ALL);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)dualListStyleClass, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)firstStyleClass, null);
        writer.startElement("div", null);
        if (middleMode.booleanValue()) {
            writer.writeAttribute("style", (Object)"margin-right:1.1em;", null);
        }
        one.encodeAll(context);
        writer.endElement("div");
        writer.endElement("span");
        if (middleMode.booleanValue()) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)(containerStyleClass.substring(0, containerStyleClass.indexOf(" ")) + " ui-corner-all"), null);
            this.encodeControls(context, writer, control);
            writer.endElement("span");
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)secondStyleClass, null);
        writer.startElement("div", null);
        if (middleMode.booleanValue()) {
            writer.writeAttribute("style", (Object)"margin-right:1.4em;", null);
        }
        two.encodeAll(context);
        writer.endElement("div");
        writer.endElement("span");
        writer.endElement("div");
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent facet = component.getFacet("footer");
        ListControl control = (ListControl)component;
        DualListPosition position = control.getPosition();
        if (this.dualListMode && position.equals((Object)DualListPosition.BOTTOM) || position.equals((Object)DualListPosition.BOTH) || position.equals((Object)DualListPosition.ALL)) {
            if (this.dualListMode) {
                writer.startElement("div", null);
                writer.writeAttribute("class", (Object)containerStyleClass.substring(0, containerStyleClass.indexOf(" ")), null);
            }
            this.encodeControls(context, writer, control);
            if (this.dualListMode) {
                writer.endElement("div");
            }
        }
        this.encodeFooter(context, writer, control, facet);
        this.encodeScript(context, writer, control);
        writer.endElement("div");
    }

    private void encodeScript(FacesContext context, ResponseWriter writer, ListControl control) throws IOException {
        String widgetVar = ListControlRenderer.resolveWidgetVar((UIComponent)control);
        String clientId = control.getClientId(context);
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)(clientId + "_script"), null);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        JSONBuilder cfgBuilder = new JSONBuilder();
        cfgBuilder.beginMap();
        cfgBuilder.entry("separator", UINamingContainer.getSeparatorChar((FacesContext)context));
        cfgBuilder.entry("selector", control.getSelector(clientId.replace(":", "\\:"), this.dualListMode));
        cfgBuilder.endMap();
        writer.write("var " + widgetVar + " = new ice.ace.ListControl('" + clientId + "', " + cfgBuilder + ");");
        writer.endElement("script");
        writer.endElement("span");
    }

    private void encodeFooter(FacesContext context, ResponseWriter writer, ListControl control, UIComponent facet) throws IOException {
        if (facet == null) {
            return;
        }
        String styleClass = control.getFooterClass();
        styleClass = styleClass == null ? "" : styleClass + " ";
        styleClass = styleClass + listControlFooterClass;
        String style = control.getFooterStyle();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)styleClass, "footerClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "footerStyle");
        }
        facet.encodeAll(context);
        writer.endElement("div");
    }
}

