/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.menu;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.ace.component.ajax.AjaxBehavior;
import org.icefaces.ace.component.menu.AbstractMenu;
import org.icefaces.ace.component.menucolumn.MenuColumn;
import org.icefaces.ace.component.menuitem.MenuItem;
import org.icefaces.ace.component.menuseparator.MenuSeparator;
import org.icefaces.ace.component.multicolumnsubmenu.MultiColumnSubmenu;
import org.icefaces.ace.component.submenu.Submenu;
import org.icefaces.ace.renderkit.CoreRenderer;
import org.icefaces.ace.util.ComponentUtils;
import org.icefaces.ace.util.Utils;

public abstract class BaseMenuRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        AbstractMenu menu = (AbstractMenu)component;
        if (menu.shouldBuildFromModel()) {
            menu.buildMenuFromModel();
        }
        this.encodeMarkup(context, menu);
        this.encodeScript(context, menu);
    }

    protected abstract void encodeMarkup(FacesContext var1, AbstractMenu var2) throws IOException;

    protected abstract void encodeScript(FacesContext var1, AbstractMenu var2) throws IOException;

    protected void encodeMenuItem(FacesContext context, MenuItem menuItem) throws IOException {
        this.encodeMenuItem(context, menuItem, false);
    }

    protected void encodeMenuItem(FacesContext context, MenuItem menuItem, boolean disabledParent) throws IOException {
        String clientId = menuItem.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        String icon = menuItem.getIcon();
        if (menuItem.shouldRenderChildren()) {
            this.renderChildren(context, (UIComponent)menuItem);
        } else {
            writer.startElement("a", null);
            if (menuItem.isDisabled() || disabledParent) {
                writer.writeAttribute("class", (Object)"ui-state-disabled", null);
            } else if (menuItem.getUrl() != null) {
                writer.writeAttribute("href", (Object)this.getResourceURL(context, menuItem.getUrl()), null);
                if (menuItem.getOnclick() != null) {
                    writer.writeAttribute("onclick", (Object)menuItem.getOnclick(), null);
                }
                if (menuItem.getTarget() != null) {
                    writer.writeAttribute("target", (Object)menuItem.getTarget(), null);
                }
            } else {
                writer.writeAttribute("href", (Object)"javascript:void 0;", null);
                UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)menuItem);
                if (form == null) {
                    throw new FacesException("Menubar must be inside a form element");
                }
                String formClientId = form.getClientId(context);
                boolean hasAjaxBehavior = false;
                StringBuilder command = new StringBuilder();
                command.append("var self = this; setTimeout(function() { var f = function(opt){");
                Map behaviorEvents = menuItem.getClientBehaviors();
                if (!behaviorEvents.isEmpty()) {
                    List params = Collections.emptyList();
                    for (ClientBehavior behavior : (List)behaviorEvents.get("activate")) {
                        ClientBehaviorContext cbc;
                        String script;
                        if (behavior instanceof AjaxBehavior) {
                            hasAjaxBehavior = true;
                        }
                        if ((script = behavior.getScript(cbc = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)menuItem, (String)"activate", (String)clientId, params))) == null) continue;
                        command.append("ice.ace.ab(ice.ace.extendAjaxArguments(");
                        command.append(script);
                        command.append(", opt));");
                    }
                }
                command.append("}; ");
                if (!(hasAjaxBehavior || menuItem.getActionExpression() == null && menuItem.getActionListeners().length <= 0)) {
                    command.append("self.id = '" + clientId + "'; ice.s(event, self");
                    StringBuilder parameters = new StringBuilder();
                    parameters.append(",function(p){");
                    for (UIComponent child : menuItem.getChildren()) {
                        if (!(child instanceof UIParameter)) continue;
                        UIParameter param = (UIParameter)child;
                        parameters.append("p('");
                        parameters.append(param.getName());
                        parameters.append("','");
                        parameters.append(String.valueOf(param.getValue()));
                        parameters.append("');");
                    }
                    parameters.append("});");
                    command.append(parameters.toString());
                } else {
                    command.append("f({node:self});");
                }
                command.append("}, 10);");
                String customOnclick = menuItem.getOnclick();
                String onclick = customOnclick == null ? command.toString() : customOnclick + ";" + command.toString();
                writer.writeAttribute("onclick", (Object)onclick, null);
            }
            if (icon != null) {
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)(icon + " wijmo-wijmenu-icon-left"), null);
                writer.endElement("span");
            }
            if (menuItem.getValue() != null) {
                writer.startElement("span", null);
                String style = menuItem.getStyle();
                if (style != null && style.trim().length() > 0) {
                    writer.writeAttribute("style", (Object)style, "style");
                }
                Utils.writeConcatenatedStyleClasses(writer, "wijmo-wijmenu-text", menuItem.getStyleClass());
                writer.write((String)menuItem.getValue());
                writer.endElement("span");
            }
            writer.endElement("a");
        }
    }

    protected void encodeMenuSeparator(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("li", null);
        writer.endElement("li");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeMultiColumnSubmenu(FacesContext context, MultiColumnSubmenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String label = submenu.getLabel();
        String icon = submenu.getIcon();
        boolean disabled = submenu.isDisabled();
        ArrayList<MenuColumn> menuColumns = new ArrayList<MenuColumn>();
        for (UIComponent child : submenu.getChildren()) {
            if (!(child instanceof MenuColumn)) continue;
            menuColumns.add((MenuColumn)child);
        }
        writer.startElement("a", null);
        if (disabled) {
            writer.writeAttribute("class", (Object)"ui-state-disabled", null);
        } else {
            writer.writeAttribute("href", (Object)"javascript:void 0;", null);
        }
        if (icon != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)(icon + " wijmo-wijmenu-icon-left"), null);
            writer.endElement("span");
        }
        if (label != null) {
            writer.startElement("span", null);
            String style = submenu.getStyle();
            if (style != null && style.trim().length() > 0) {
                writer.writeAttribute("style", (Object)style, "style");
            }
            Utils.writeConcatenatedStyleClasses(writer, "wijmo-wijmenu-text", submenu.getStyleClass());
            writer.write(submenu.getLabel());
            writer.endElement("span");
        }
        writer.endElement("a");
        if (disabled) {
            return;
        }
        int totalChildren = 0;
        HashMap<MenuColumn, ArrayList<ArrayList<UIComponent>>> columnMap = new HashMap<MenuColumn, ArrayList<ArrayList<UIComponent>>>();
        for (MenuColumn menuColumn : menuColumns) {
            columnMap.put(menuColumn, this.divideColumn(menuColumn));
            for (ArrayList sublist : (ArrayList)columnMap.get(menuColumn)) {
                totalChildren += sublist.size();
            }
        }
        int totalWidth = 0;
        for (MenuColumn menuColumn : menuColumns) {
            if (!menuColumn.isRendered()) continue;
            int columnWidth = menuColumn.getWidth();
            int autoflow = menuColumn.getAutoflow();
            int multiplier = 1;
            if (autoflow > 0) {
                multiplier = totalChildren / autoflow;
                if (totalChildren % autoflow > 0) {
                    ++multiplier;
                }
            }
            totalWidth += columnWidth * multiplier;
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"wijmo-wijmenu ui-menu-multicolumn", "class");
        writer.writeAttribute("style", (Object)("width: " + totalWidth + "px;"), "style");
        for (MenuColumn menuColumn : menuColumns) {
            if (!menuColumn.isRendered()) continue;
            for (ArrayList sublist : (ArrayList)columnMap.get(menuColumn)) {
                writer.startElement("div", null);
                writer.writeAttribute("style", (Object)("width: " + menuColumn.getWidth() + "px;"), "style");
                if (sublist.size() > 0) {
                    writer.startElement("ul", null);
                    boolean disabledSubmenu = false;
                    for (UIComponent item : sublist) {
                        if (!item.isRendered()) continue;
                        if (item instanceof MenuItem) {
                            writer.startElement("li", null);
                            this.encodeMenuItem(context, (MenuItem)item, disabledSubmenu);
                            writer.endElement("li");
                            continue;
                        }
                        if (item instanceof MenuSeparator) {
                            this.encodeMenuSeparator(context);
                            continue;
                        }
                        if (!(item instanceof Submenu)) continue;
                        Submenu sm = (Submenu)item;
                        disabledSubmenu = sm.isDisabled();
                        this.encodeFlatSubmenu(context, sm, disabledSubmenu);
                    }
                    writer.endElement("ul");
                }
                writer.endElement("div");
            }
        }
        writer.endElement("div");
    }

    protected void encodeFlatSubmenu(FacesContext context, Submenu submenu, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String label = submenu.getLabel();
        writer.startElement("li", null);
        writer.startElement("h3", null);
        if (label != null) {
            if (disabled) {
                writer.writeAttribute("class", (Object)"ui-state-disabled", null);
            } else {
                String style = submenu.getStyle();
                if (style != null && style.trim().length() > 0) {
                    writer.writeAttribute("style", (Object)style, "style");
                }
                Utils.writeConcatenatedStyleClasses(writer, "", submenu.getStyleClass());
            }
            writer.write(label);
        }
        writer.endElement("h3");
        writer.endElement("li");
    }

    protected ArrayList<ArrayList<UIComponent>> divideColumn(MenuColumn menuColumn) {
        ArrayList<ArrayList<UIComponent>> columnList = new ArrayList<ArrayList<UIComponent>>();
        if (!menuColumn.isRendered()) {
            return columnList;
        }
        int maxRows = menuColumn.getAutoflow();
        if (maxRows == 0) {
            ArrayList<UIComponent> column = this.flattenContents((UIComponent)menuColumn, new ArrayList<UIComponent>());
            columnList.add(column);
        } else {
            ArrayList<UIComponent> children = this.flattenContents((UIComponent)menuColumn, new ArrayList<UIComponent>());
            if (children.size() <= maxRows) {
                columnList.add(children);
            } else {
                int rowCount = 0;
                ArrayList<UIComponent> currentColumn = new ArrayList<UIComponent>();
                for (UIComponent child : children) {
                    currentColumn.add(child);
                    if (++rowCount != maxRows) continue;
                    rowCount = 0;
                    columnList.add(currentColumn);
                    currentColumn = new ArrayList();
                }
                if (rowCount > 0) {
                    columnList.add(currentColumn);
                }
            }
        }
        return columnList;
    }

    protected ArrayList<UIComponent> flattenContents(UIComponent component, ArrayList<UIComponent> result) {
        for (UIComponent child : component.getChildren()) {
            if (!child.isRendered() || !(child instanceof MenuItem) && !(child instanceof MenuSeparator) && !(child instanceof Submenu)) continue;
            result.add(child);
            if (!(child instanceof Submenu)) continue;
            this.flattenContents(child, result);
        }
        return result;
    }
}

