/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.tabset;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;

public class TabPaneUtil {
    public static boolean isAutoDynamic(FacesContext facesContext, UIComponent tab) {
        HashSet<String> affectedRegions = new HashSet<String>(6);
        if (facesContext.getPartialViewContext().isRenderAll()) {
            String srcCompClientId;
            Map rpm = facesContext.getExternalContext().getRequestParameterMap();
            if (rpm.containsKey("javax.faces.source") && !affectedRegions.contains(srcCompClientId = (String)rpm.get("javax.faces.source"))) {
                affectedRegions.add(srcCompClientId);
            }
            if (rpm.containsKey("ice.event.captured") && !affectedRegions.contains(srcCompClientId = (String)rpm.get("ice.event.captured"))) {
                affectedRegions.add(srcCompClientId);
            }
        }
        if (affectedRegions.size() > 0) {
            EnumSet<VisitHint> hints = EnumSet.of(VisitHint.SKIP_UNRENDERED);
            VisitContext visitContext = VisitContext.createVisitContext((FacesContext)facesContext, affectedRegions, hints);
            RegionInTabPane vcall = new RegionInTabPane(tab);
            facesContext.getViewRoot().visitTree(visitContext, (VisitCallback)vcall);
            boolean ret = vcall.isEqualOrInside();
            return ret;
        }
        return false;
    }

    private static class RegionInTabPane
    implements VisitCallback {
        private UIComponent tabPane;
        private boolean equalOrInside;

        RegionInTabPane(UIComponent tabPane) {
            this.tabPane = tabPane;
        }

        boolean isEqualOrInside() {
            return this.equalOrInside;
        }

        public VisitResult visit(VisitContext visitContext, UIComponent uiComponent) {
            FacesContext facesContext = visitContext.getFacesContext();
            String clientId = uiComponent.getClientId(facesContext);
            for (UIComponent seek = uiComponent; seek != null; seek = seek.getParent()) {
                if (seek != this.tabPane) continue;
                this.equalOrInside = true;
                return VisitResult.COMPLETE;
            }
            return VisitResult.ACCEPT;
        }
    }
}

