/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.ext.renderkit;

import com.icesoft.faces.component.ExtendedAttributeConstants;
import com.icesoft.faces.component.dragdrop.DndEvent;
import com.icesoft.faces.component.dragdrop.DragEvent;
import com.icesoft.faces.component.dragdrop.DropEvent;
import com.icesoft.faces.component.ext.HtmlPanelGroup;
import com.icesoft.faces.component.ext.renderkit.FormRenderer;
import com.icesoft.faces.component.menupopup.MenuPopupHelper;
import com.icesoft.faces.component.util.DelimitedProperties;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.context.effects.CurrentStyle;
import com.icesoft.faces.context.effects.DragDrop;
import com.icesoft.faces.context.effects.JavascriptContext;
import com.icesoft.faces.context.effects.LocalEffectEncoder;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import com.icesoft.faces.util.CoreUtils;
import com.icesoft.faces.utils.DnDCache;
import com.icesoft.util.pooling.ClientIdPool;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class GroupRenderer
extends com.icesoft.faces.renderkit.dom_html_basic.GroupRenderer {
    protected static final String STATUS = "status";
    protected static final String DROP = "dropID";
    protected static final String HIDDEN_FILED = UINamingContainer.getSeparatorChar((FacesContext)FacesContext.getCurrentInstance()) + "iceDND";
    private static Log log = LogFactory.getLog(GroupRenderer.class);
    private static final String[] PASSTHRU_EXCLUDE = new String[]{"style"};
    private static final String[] PASSTHRU_JS_EVENTS = LocalEffectEncoder.maskEvents(ExtendedAttributeConstants.getAttributes(32));
    private static final String[] passThruAttributes = ExtendedAttributeConstants.getAttributes(32, new String[][]{PASSTHRU_EXCLUDE, PASSTHRU_JS_EVENTS});

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        try {
            Element rootSpan;
            String viewID = facesContext.getViewRoot().getViewId();
            String style = ((HtmlPanelGroup)uiComponent).getStyle();
            String styleClass = ((HtmlPanelGroup)uiComponent).getStyleClass();
            String blockingFlag = (String)facesContext.getExternalContext().getRequestMap().get("BlockingServlet");
            String dndType = this.getDndType(uiComponent);
            DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
            if (!domContext.isInitialized()) {
                rootSpan = domContext.createElement("div");
                domContext.setRootNode(rootSpan);
                GroupRenderer.setRootElementId(facesContext, rootSpan, uiComponent);
                if (dndType != null) {
                    UIComponent form = GroupRenderer.findForm(uiComponent);
                    String formId = form.getClientId(facesContext);
                    FormRenderer.addHiddenField(facesContext, ClientIdPool.get(formId + HIDDEN_FILED));
                }
            }
            rootSpan = (Element)domContext.getRootNode();
            if (dndType != null) {
                DnDCache.getInstance(facesContext, true).put(uiComponent.getClientId(facesContext), (HtmlPanelGroup)uiComponent, facesContext);
                StringBuffer dropCall = new StringBuffer();
                String call = this.addJavascriptCalls(uiComponent, dndType, null, facesContext, dropCall);
                String clientId = uiComponent.getClientId(facesContext);
                Element script = domContext.createElement("script");
                script.setAttribute("id", ClientIdPool.get(clientId + "script"));
                script.appendChild(domContext.createTextNodeUnescaped(dropCall.toString()));
                rootSpan.appendChild(script);
                HashMap<String, String> rendererJavascriptDraggable = new HashMap<String, String>();
                rendererJavascriptDraggable.put("onmouseout", "Ice.Scriptaculous.Draggable.removeMe(this.id);");
                rendererJavascriptDraggable.put("onmousemove", call);
                rendererJavascriptDraggable.put("onmouseover", dropCall.toString());
                LocalEffectEncoder.encode(facesContext, uiComponent, PASSTHRU_JS_EVENTS, rendererJavascriptDraggable, rootSpan, null);
            } else {
                LocalEffectEncoder.encode(facesContext, uiComponent, PASSTHRU_JS_EVENTS, null, rootSpan, null);
            }
            if (styleClass != null) {
                rootSpan.setAttribute("class", styleClass);
            }
            JavascriptContext.fireEffect(uiComponent, facesContext);
            String extraStyle = null;
            String scrollWidth = (String)uiComponent.getAttributes().get("scrollWidth");
            String scrollHeight = (String)uiComponent.getAttributes().get("scrollHeight");
            if (scrollHeight != null || scrollWidth != null) {
                if (extraStyle == null) {
                    extraStyle = "";
                }
                extraStyle = scrollHeight == null ? extraStyle + "width:" + scrollWidth + ";overflow:auto;" : (scrollWidth == null ? extraStyle + "height:" + scrollHeight + ";overflow:auto;" : extraStyle + "width:" + scrollWidth + ";height:" + scrollHeight + ";overflow:auto;");
            }
            CurrentStyle.apply(facesContext, uiComponent, null, extraStyle);
            MenuPopupHelper.renderMenuPopupHandler(facesContext, uiComponent, rootSpan);
            PassThruAttributeRenderer.renderNonBooleanHtmlAttributes(uiComponent, rootSpan, passThruAttributes);
            domContext.stepInto(uiComponent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String addJavascriptCalls(UIComponent uiComponent, String dndType, String handleId, FacesContext facesContext, StringBuffer dropCall) {
        String calls = "";
        boolean dragListener = uiComponent.getAttributes().get("dragListener") != null;
        boolean dropListener = uiComponent.getAttributes().get("dropListener") != null;
        String dragMask = DndEvent.parseMask((String)uiComponent.getAttributes().get("dragMask"));
        String dropMask = DndEvent.parseMask((String)uiComponent.getAttributes().get("dropMask"));
        String dragOptions = (String)uiComponent.getAttributes().get("dragOptions");
        String hoverClass = (String)uiComponent.getAttributes().get("hoverclass");
        if (!dragListener && dragMask == null) {
            dragMask = "1,4,5";
        }
        if (!dropListener) {
            dropMask = "1,2,3,4,5";
        }
        if ("DRAG".equalsIgnoreCase(dndType)) {
            calls = calls + DragDrop.addDragable(uiComponent.getClientId(facesContext), handleId, dragOptions, dragMask, facesContext);
        } else if ("drop".equalsIgnoreCase(dndType)) {
            dropCall.append(DragDrop.addDroptarget(uiComponent, null, facesContext, dropMask, hoverClass));
        } else if ("dragdrop".equalsIgnoreCase(dndType)) {
            calls = calls + DragDrop.addDragable(uiComponent.getClientId(facesContext), handleId, dragOptions, dragMask, facesContext);
            dropCall.append(DragDrop.addDroptarget(uiComponent, null, facesContext, dropMask, hoverClass));
        } else {
            throw new IllegalArgumentException("Value [" + dndType + "] is not valid for dndType. Please use drag or drop");
        }
        return calls;
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        GroupRenderer.validateParameters(facesContext, uiComponent, null);
        DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
        CoreUtils.addPanelTooltip(facesContext, uiComponent);
        domContext.stepOver();
    }

    protected String appendStyle(String currentStyle, String additionalStyle) {
        String result = "";
        if (!GroupRenderer.isBlank(currentStyle)) {
            result = currentStyle;
        }
        if (!GroupRenderer.isBlank(additionalStyle)) {
            result = result + additionalStyle;
        }
        if (GroupRenderer.isBlank(result)) {
            return null;
        }
        return result;
    }

    private static boolean isBlank(String s) {
        return s == null || s.trim().length() <= 0;
    }

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        String clientId = component.getClientId(context);
        if (log.isTraceEnabled()) {
            log.trace((Object)"GroupRenderer:decode");
        }
        MenuPopupHelper.decodeMenuContext(context, component);
        if (component instanceof HtmlPanelGroup) {
            HtmlPanelGroup panel = (HtmlPanelGroup)component;
            String dndType = this.getDndType(component);
            if (panel.getDraggable() != null || panel.getDropTarget() != null) {
                DndEvent event;
                int type;
                Object targetDropValue;
                Object targetDragValue;
                String targetID;
                block16: {
                    String fieldName;
                    UIComponent form;
                    String formId;
                    String hdnFld;
                    Map requestMap = context.getExternalContext().getRequestParameterMap();
                    if (!requestMap.containsKey(hdnFld = ClientIdPool.get((formId = (form = GroupRenderer.findForm(component)).getClientId(context)) + HIDDEN_FILED))) {
                        return;
                    }
                    String value = String.valueOf(requestMap.get(hdnFld));
                    DelimitedProperties delimitedProperties = new DelimitedProperties(value);
                    String status = delimitedProperties.get(fieldName = clientId + STATUS);
                    if (status == null) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Drag Drop Status for ID [" + panel.getClientId(context) + "] Field Name [" + fieldName + "] is null. Returning"));
                        }
                        return;
                    }
                    targetID = delimitedProperties.get(clientId + DROP);
                    targetDragValue = null;
                    targetDropValue = null;
                    if (targetID != null && targetID.length() > 0) {
                        DnDCache dndCache = DnDCache.getInstance(context, false);
                        if ("drop".equals(dndType)) {
                            targetDragValue = dndCache.getDragValue(targetID);
                            targetDropValue = dndCache.getDropValue(panel.getClientId(context));
                        } else {
                            targetDragValue = dndCache.getDragValue(panel.getClientId(context));
                            targetDropValue = dndCache.getDropValue(targetID);
                        }
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Dnd Event Client ID [" + component.getClientId(context) + "] Target ID [" + targetID + "] Status [" + status + "]"));
                    }
                    type = 0;
                    try {
                        type = Integer.parseInt(status);
                    }
                    catch (NumberFormatException e) {
                        if (status == null && status.length() == 0) break block16;
                        return;
                    }
                }
                if (type > 0 && type < 4) {
                    panel.getAttributes().put("dragged", Boolean.TRUE);
                }
                if (panel.getDragListener() == null && panel.getDropListener() == null) {
                    return;
                }
                MethodBinding listener = panel.getDragListener();
                if (listener != null) {
                    event = new DragEvent(component, type, targetID, targetDragValue, targetDropValue);
                    panel.queueEvent(event);
                }
                if ((listener = panel.getDropListener()) != null) {
                    event = new DropEvent(component, type, targetID, targetDragValue, targetDropValue);
                    panel.queueEvent(event);
                }
            }
        }
    }

    protected Element createHiddenField(DOMContext domContext, FacesContext facesContext, UIComponent uiComponent, String name) {
        Element ele = domContext.createElement("input");
        ele.setAttribute("type", "hidden");
        String n = ClientIdPool.get(this.getHiddenFieldName(facesContext, uiComponent, name));
        ele.setAttribute("name", n);
        ele.setAttribute("id", n);
        ele.setAttribute("value", "");
        return ele;
    }

    protected String getHiddenFieldName(FacesContext facesContext, UIComponent uiComponent, String name) {
        UIComponent form = GroupRenderer.findForm(uiComponent);
        String formId = form.getClientId(facesContext);
        String clientId = uiComponent.getClientId(facesContext);
        return formId + ':' + "j_id" + clientId + name;
    }

    protected String getDndType(UIComponent uiComponent) {
        String dndType = null;
        String draggable = (String)uiComponent.getAttributes().get("draggable");
        String droppable = (String)uiComponent.getAttributes().get("dropTarget");
        if ("true".equalsIgnoreCase(draggable) && "true".equalsIgnoreCase(droppable)) {
            dndType = "dragdrop";
        } else if ("true".equalsIgnoreCase(draggable)) {
            dndType = "DRAG";
        } else if ("true".equalsIgnoreCase(droppable)) {
            dndType = "drop";
        }
        return dndType;
    }

    private String getParamamterValue(String[] sa) {
        if (sa == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Null parameter value");
            }
            return null;
        }
        String result = null;
        for (int i = 0; i < sa.length; ++i) {
            String s = sa[i];
            if (log.isTraceEnabled()) {
                log.trace((Object)("getParameterValue Checking [" + s + "]"));
            }
            if (s == null || s.trim().length() <= 0) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("getParameterValue result:" + s));
            }
            result = s;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Length [" + sa.length + "] Result [" + result + "]"));
        }
        return result;
    }
}

