/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.gmap;

import com.icesoft.faces.component.ext.taglib.Util;
import com.icesoft.faces.context.effects.JavascriptContext;
import java.io.IOException;
import java.util.Map;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

@ResourceDependency(name="gmap/gmap.js")
public class GMap
extends UIPanel {
    public static final String COMPONENT_TYPE = "com.icesoft.faces.GMap";
    public static final String DEFAULT_RENDERER_TYPE = "com.icesoft.faces.GMapRenderer";
    private static final String DEFAULT_LONGITUDE = "-101.162109375";
    private static final String DEFAULT_LATITUDE = "56.46249048388979";
    private String longitude;
    private String latitude;
    private Integer zoomLevel;
    private Boolean locateAddress;
    private boolean initilized = false;
    private String address;
    private String type;
    private String style = null;
    private String styleClass = null;
    private String renderedOnUserRole = null;
    private transient Object[] values;

    public String getRendererType() {
        return DEFAULT_RENDERER_TYPE;
    }

    public String getComponentType() {
        return COMPONENT_TYPE;
    }

    public String getLongitude() {
        if (this.longitude != null) {
            return this.longitude;
        }
        ValueBinding vb = this.getValueBinding("longitude");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : DEFAULT_LONGITUDE;
    }

    public String getLatitude() {
        if (this.latitude != null) {
            return this.latitude;
        }
        ValueBinding vb = this.getValueBinding("latitude");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : DEFAULT_LATITUDE;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
        ValueBinding vb = this.getValueBinding("longitude");
        if (vb != null) {
            vb.setValue(this.getFacesContext(), (Object)longitude);
            this.longitude = null;
        }
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
        ValueBinding vb = this.getValueBinding("latitude");
        if (vb != null) {
            vb.setValue(this.getFacesContext(), (Object)latitude);
            this.latitude = null;
        }
    }

    public void decode(FacesContext facesContext) {
        String clientId;
        Map map = facesContext.getExternalContext().getRequestParameterMap();
        if (map.get((clientId = this.getClientId(facesContext)) + "event") != null && map.get(clientId + "event").toString().length() > 0) {
            if (map.containsKey(clientId + "lat")) {
                this.setLatitude(String.valueOf(map.get(clientId + "lat")));
            }
            if (map.containsKey(clientId + "lng")) {
                this.setLongitude(String.valueOf(map.get(clientId + "lng")));
            }
            if (map.containsKey(clientId + "zoom")) {
                this.setZoomLevel(Integer.valueOf(String.valueOf(map.get(clientId + "zoom"))));
            }
            if (map.containsKey(clientId + "type")) {
                this.setType(String.valueOf(map.get(clientId + "type")));
            }
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        if (context.getExternalContext().getRequestParameterMap() != null && context.getExternalContext().getRequestParameterMap().size() <= 1) {
            this.initilized = false;
        }
        if ((this.isLocateAddress() || !this.initilized) && this.getAddress() != null && this.getAddress().length() > 2) {
            JavascriptContext.addJavascriptCall(context, "Ice.GoogleMap.locateAddress('" + this.getClientId(context) + "', '" + this.getAddress() + "');");
            this.initilized = true;
        } else if (this.isLocatedByGeocoder(context)) {
            JavascriptContext.addJavascriptCall(context, "Ice.GoogleMap.getGMapWrapper('" + this.getClientId(context) + "').getRealGMap().setZoom(" + this.getZoomLevel() + ");");
        } else {
            String latitude = this.getLatitude();
            String longitude = this.getLongitude();
            try {
                Float.parseFloat(latitude);
                Float.parseFloat(longitude);
            }
            catch (NumberFormatException e) {
                latitude = DEFAULT_LATITUDE;
                longitude = DEFAULT_LONGITUDE;
            }
            JavascriptContext.addJavascriptCall(context, "Ice.GoogleMap.getGMapWrapper('" + this.getClientId(context) + "').getRealGMap().setCenter(new GLatLng(" + latitude + ", " + longitude + "), " + this.getZoomLevel() + ");");
        }
        JavascriptContext.addJavascriptCall(context, "Ice.GoogleMap.setMapType('" + this.getClientId(context) + "', '" + this.getType() + "');");
    }

    public int getZoomLevel() {
        if (this.zoomLevel != null) {
            return this.zoomLevel;
        }
        ValueBinding vb = this.getValueBinding("zoomLevel");
        return vb != null ? (Integer)vb.getValue(this.getFacesContext()) : 3;
    }

    public void setZoomLevel(int zoomLevel) {
        this.zoomLevel = new Integer(zoomLevel);
    }

    private boolean isLocatedByGeocoder(FacesContext context) {
        Object event = context.getExternalContext().getRequestParameterMap().get(this.getClientId(context) + "event");
        return event != null && "geocoder".equals(event);
    }

    public boolean isLocateAddress() {
        if (this.locateAddress != null) {
            return this.locateAddress;
        }
        ValueBinding vb = this.getValueBinding("locateAddress");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : false;
    }

    public void setLocateAddress(boolean locateAddress) {
        this.locateAddress = new Boolean(locateAddress);
    }

    public String getAddress() {
        if (this.address != null) {
            return this.address;
        }
        ValueBinding vb = this.getValueBinding("address");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getType() {
        if (this.type != null) {
            return this.type;
        }
        ValueBinding vb = this.getValueBinding("type");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "Map";
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setRenderedOnUserRole(String renderedOnUserRole) {
        this.renderedOnUserRole = renderedOnUserRole;
    }

    public String getRenderedOnUserRole() {
        if (this.renderedOnUserRole != null) {
            return this.renderedOnUserRole;
        }
        ValueBinding vb = this.getValueBinding("renderedOnUserRole");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public boolean isRendered() {
        if (!Util.isRenderedOnUserRole((UIComponent)this)) {
            return false;
        }
        return super.isRendered();
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueBinding vb = this.getValueBinding("style");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getStyleClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, this.styleClass, "iceGmp", "styleClass");
    }

    public String getMapTdStyleClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, "MapTd");
    }

    public String getTxtTdStyleClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, "TxtTd");
    }

    public void restoreState(FacesContext context, Object state) {
        this.values = (Object[])state;
        super.restoreState(context, this.values[0]);
        this.renderedOnUserRole = (String)this.values[1];
        this.longitude = (String)this.values[2];
        this.styleClass = (String)this.values[3];
        this.zoomLevel = (Integer)this.values[4];
        this.type = (String)this.values[5];
        this.style = (String)this.values[6];
        this.latitude = (String)this.values[7];
        this.address = (String)this.values[8];
        this.locateAddress = (Boolean)this.values[9];
        this.initilized = (Boolean)this.values[10];
    }

    public Object saveState(FacesContext context) {
        if (this.values == null) {
            this.values = new Object[11];
        }
        this.values[0] = super.saveState(context);
        this.values[1] = this.renderedOnUserRole;
        this.values[2] = this.longitude;
        this.values[3] = this.styleClass;
        this.values[4] = this.zoomLevel;
        this.values[5] = this.type;
        this.values[6] = this.style;
        this.values[7] = this.latitude;
        this.values[8] = this.address;
        this.values[9] = this.locateAddress;
        this.values[10] = this.initilized ? Boolean.TRUE : Boolean.FALSE;
        return this.values;
    }
}

