/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.component.AttributeConstants;
import com.icesoft.faces.renderkit.dom_html_basic.BaseRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicInputRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeWriter;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class InputTextRenderer
extends BaseRenderer {
    private static final String[] passThruAttributes = AttributeConstants.getAttributes(7);

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        super.decode(facesContext, uiComponent);
        if (DomBasicRenderer.isStatic(uiComponent)) {
            return;
        }
        String clientId = uiComponent.getClientId(facesContext);
        Map requestMap = facesContext.getExternalContext().getRequestParameterMap();
        if (requestMap.containsKey(clientId)) {
            String decodedValue = (String)requestMap.get(clientId);
            ((UIInput)uiComponent).setSubmittedValue((Object)decodedValue);
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("id", (Object)clientId, "id");
        this.renderHtmlAttributes(facesContext, writer, uiComponent);
        PassThruAttributeWriter.renderBooleanAttributes(writer, uiComponent, new String[0]);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("type", (Object)"text", null);
        Object styleClass = uiComponent.getAttributes().get("styleClass");
        if (styleClass != null) {
            writer.writeAttribute("class", styleClass, null);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        super.encodeEnd(facesContext, uiComponent);
        ResponseWriter writer = facesContext.getResponseWriter();
        String value = this.getValue(facesContext, uiComponent);
        if (value != null) {
            writer.writeAttribute("value", (Object)value, null);
        }
        writer.endElement("input");
    }

    public String getValue(FacesContext facesContext, UIComponent uiComponent) {
        Object submittedValue;
        if (uiComponent instanceof UIInput && (submittedValue = ((UIInput)uiComponent).getSubmittedValue()) != null && submittedValue instanceof String) {
            return (String)submittedValue;
        }
        return DomBasicInputRenderer.converterGetAsString(facesContext, uiComponent, ((UIInput)uiComponent).getValue());
    }

    protected void renderHtmlAttributes(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent) throws IOException {
        PassThruAttributeWriter.renderHtmlAttributes(writer, uiComponent, passThruAttributes);
    }
}

