/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.facelets;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.MethodNotFoundException;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;

public class MethodRule
extends MetaRule {
    private final String methodName;
    private final Class returnTypeClass;
    private final Class[] params;
    private final String noArgMethodName;
    private final String superArgMethodName;
    private final Class[] superParams;

    public MethodRule(String methodName, Class returnTypeClass, Class[] params, String noArgMethodName, String superArgMethodName, Class[] superParams) {
        this.methodName = methodName;
        this.returnTypeClass = returnTypeClass;
        this.params = params;
        this.noArgMethodName = noArgMethodName;
        this.superArgMethodName = superArgMethodName;
        this.superParams = superParams;
    }

    public MethodRule(String methodName, Class returnTypeClass, Class[] params) {
        this(methodName, returnTypeClass, params, null, null, null);
    }

    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
        Method method;
        if (!name.equals(this.methodName)) {
            return null;
        }
        if (MethodBinding.class.equals((Object)meta.getPropertyType(name))) {
            Method method2 = meta.getWriteMethod(name);
            if (method2 != null) {
                Method noArgMethod = this.noArgMethodName == null ? null : meta.getWriteMethod(this.noArgMethodName);
                Method superArgMethod = this.superArgMethodName == null || this.superParams == null ? null : meta.getWriteMethod(this.superArgMethodName);
                return new MethodBindingMetadata(method2, attribute, this.returnTypeClass, this.params, noArgMethod, superArgMethod, this.superParams);
            }
        } else if (MethodExpression.class.equals((Object)meta.getPropertyType(name)) && (method = meta.getWriteMethod(name)) != null) {
            Method noArgMethod = this.noArgMethodName == null ? null : meta.getWriteMethod(this.noArgMethodName);
            Method superArgMethod = this.superArgMethodName == null || this.superParams == null ? null : meta.getWriteMethod(this.superArgMethodName);
            return new MethodExpressionMetadata(method, attribute, this.returnTypeClass, this.params, noArgMethod, superArgMethod, this.superParams);
        }
        return null;
    }

    private static class LegacyMethodBinding
    extends MethodBinding
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final MethodExpression m;

        public LegacyMethodBinding(MethodExpression m) {
            this.m = m;
        }

        public Class getType(FacesContext context) throws javax.faces.el.MethodNotFoundException {
            try {
                return this.m.getMethodInfo(context.getELContext()).getReturnType();
            }
            catch (MethodNotFoundException e) {
                throw new javax.faces.el.MethodNotFoundException(e.getMessage(), e.getCause());
            }
            catch (ELException e) {
                throw new EvaluationException(e.getMessage(), e.getCause());
            }
        }

        public Object invoke(FacesContext context, Object[] params) throws EvaluationException, javax.faces.el.MethodNotFoundException {
            try {
                return this.m.invoke(context.getELContext(), params);
            }
            catch (MethodNotFoundException e) {
                throw new javax.faces.el.MethodNotFoundException(e.getMessage(), e.getCause());
            }
            catch (ELException e) {
                throw new EvaluationException(e.getMessage(), e.getCause());
            }
        }

        public String getExpressionString() {
            return this.m.getExpressionString();
        }
    }

    private static class MethodExpressionMetadata
    extends Metadata {
        private final Method _method;
        private final TagAttribute _attribute;
        private Class[] _paramList;
        private Class _returnType;
        private final Method _noArgMethod;
        private final Method _superArgMethod;
        private Class[] _superParamList;

        public MethodExpressionMetadata(Method method, TagAttribute attribute, Class returnType, Class[] paramList, Method noArgMethod, Method superArgMethod, Class[] superParamList) {
            this._method = method;
            this._attribute = attribute;
            this._paramList = paramList;
            this._returnType = returnType;
            this._noArgMethod = noArgMethod;
            this._superArgMethod = superArgMethod;
            this._superParamList = superParamList;
        }

        protected void setMethodExpressionIntoMethod(FaceletContext ctx, Object instance, Method method, Class[] paramList) {
            MethodExpression expr = this._attribute.getMethodExpression(ctx, this._returnType, paramList);
            try {
                method.invoke(instance, expr);
            }
            catch (InvocationTargetException e) {
                throw new TagAttributeException(this._attribute, e.getCause());
            }
            catch (Exception e) {
                throw new TagAttributeException(this._attribute, (Throwable)e);
            }
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            this.setMethodExpressionIntoMethod(ctx, instance, this._method, this._paramList);
            if (this._noArgMethod != null) {
                this.setMethodExpressionIntoMethod(ctx, instance, this._noArgMethod, new Class[0]);
            }
            if (this._superArgMethod != null && this._superParamList != null) {
                this.setMethodExpressionIntoMethod(ctx, instance, this._superArgMethod, this._superParamList);
            }
        }
    }

    private static class MethodBindingMetadata
    extends Metadata {
        private final Method _method;
        private final TagAttribute _attribute;
        private Class[] _paramList;
        private Class _returnType;
        private final Method _noArgMethod;
        private final Method _superArgMethod;
        private Class[] _superParamList;

        public MethodBindingMetadata(Method method, TagAttribute attribute, Class returnType, Class[] paramList, Method noArgMethod, Method superArgMethod, Class[] superParamList) {
            this._method = method;
            this._attribute = attribute;
            this._paramList = paramList;
            this._returnType = returnType;
            this._noArgMethod = noArgMethod;
            this._superArgMethod = superArgMethod;
            this._superParamList = superParamList;
        }

        protected void setMethodBindingIntoMethod(FaceletContext ctx, Object instance, Method method, Class[] paramList) {
            MethodExpression expr = this._attribute.getMethodExpression(ctx, this._returnType, paramList);
            try {
                method.invoke(instance, new LegacyMethodBinding(expr));
            }
            catch (InvocationTargetException e) {
                throw new TagAttributeException(this._attribute, e.getCause());
            }
            catch (Exception e) {
                throw new TagAttributeException(this._attribute, (Throwable)e);
            }
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            this.setMethodBindingIntoMethod(ctx, instance, this._method, this._paramList);
            if (this._noArgMethod != null) {
                this.setMethodBindingIntoMethod(ctx, instance, this._noArgMethod, new Class[0]);
            }
            if (this._superArgMethod != null && this._superParamList != null) {
                this.setMethodBindingIntoMethod(ctx, instance, this._superArgMethod, this._superParamList);
            }
        }
    }
}

