/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.camera;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.el.MethodExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.ValueChangeEvent;
import org.icefaces.mobi.api.ThumbnailProvider;
import org.icefaces.mobi.component.camera.CameraBase;
import org.icefaces.mobi.utils.MobiJSFUtils;
import org.icemobile.component.IDevice;
import org.icemobile.util.ClientDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Camera
extends CameraBase
implements IDevice,
ThumbnailProvider {
    private static Logger logger = Logger.getLogger(Camera.class.getName());

    public Object getPropertyFromMap(Map<String, Object> cameraMap, String key) {
        if (cameraMap.containsKey(key)) {
            return cameraMap.get(key);
        }
        return null;
    }

    private boolean containsKey(Map<String, Object> cameraMap, String key) {
        return cameraMap.containsKey(key);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof ValueChangeEvent && event != null) {
            ValueChangeEvent e = (ValueChangeEvent)event;
            MethodExpression method = this.getValueChangeListener();
            if (method != null) {
                method.invoke(this.getFacesContext().getELContext(), new Object[]{event});
            }
        }
    }

    public void queueEvent(FacesEvent event) {
        if (event.getComponent() instanceof Camera) {
            if (this.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(event);
    }

    @Override
    public String getScript(String clientId, boolean auxUpload) {
        String script;
        int width = this.getMaxwidth();
        int height = this.getMaxheight();
        if (auxUpload) {
            HashMap<String, String> params = new HashMap<String, String>();
            if (width != Integer.MIN_VALUE || height != Integer.MIN_VALUE) {
                if (width > 0) {
                    params.put("maxwidth", String.valueOf(width));
                }
                if (height > 0) {
                    params.put("maxheight", String.valueOf(height));
                }
            }
            script = MobiJSFUtils.getICEmobileSXScript("camera", params, (UIComponent)this);
        } else {
            boolean needParams;
            script = "ice.camera( '" + clientId + "'";
            boolean bl = needParams = width > 0 || height > 0;
            if (needParams) {
                script = script + ", '";
            }
            if (width > 0) {
                script = script + "maxwidth=" + String.valueOf(width);
                if (height > 0) {
                    script = script + "&";
                }
            }
            if (height > 0) {
                script = script + "maxheight=" + String.valueOf(height);
            }
            if (needParams) {
                script = script + "'";
            }
            script = script + ");";
        }
        return script;
    }

    @Override
    public ClientDescriptor getClient() {
        return MobiJSFUtils.getClientDescriptor();
    }

    public boolean isUseCookie() {
        return false;
    }

    @Override
    public String getComponentType() {
        return "camera";
    }

    @Override
    public String getSessionId() {
        return MobiJSFUtils.getSessionIdCookie(FacesContext.getCurrentInstance());
    }

    @Override
    public String getParams() {
        return null;
    }
}

