/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.contentmenuitem;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.icefaces.mobi.component.contentmenuitem.ContentMenuItem;
import org.icefaces.mobi.component.contentnavbar.ContentNavBar;
import org.icefaces.mobi.component.contentpane.ContentPane;
import org.icefaces.mobi.component.contentstack.ContentStack;
import org.icefaces.mobi.component.contentstackmenu.ContentStackMenu;
import org.icefaces.mobi.renderkit.BaseLayoutRenderer;
import org.icefaces.mobi.utils.JSFUtils;

public class ContentMenuItemRenderer
extends BaseLayoutRenderer {
    private static Logger logger = Logger.getLogger(ContentMenuItemRenderer.class.getName());

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        ContentMenuItem item = (ContentMenuItem)uiComponent;
        String source = String.valueOf(requestParameterMap.get("ice.event.captured"));
        String clientId = item.getClientId();
        if (clientId.equals(source)) {
            try {
                if (!item.isDisabled()) {
                    uiComponent.queueEvent((FacesEvent)new ActionEvent(uiComponent));
                    UIComponent parent = item.getParent();
                    ContentStack stack = null;
                    if (parent instanceof ContentStackMenu) {
                        ContentStackMenu menu = (ContentStackMenu)parent;
                        String stackClientId = menu.getStackClientId();
                        UIComponent compStack = facesContext.getViewRoot().findComponent(stackClientId);
                        stack = (ContentStack)compStack;
                    } else if (parent instanceof ContentNavBar) {
                        ContentNavBar navBar = (ContentNavBar)parent;
                        UIComponent compStack = ContentMenuItemRenderer.findParentContentStack(uiComponent);
                        stack = (ContentStack)compStack;
                    }
                    if (null != stack) {
                        String newVal = String.valueOf(item.getValue());
                        stack.setCurrentId(newVal);
                    }
                }
            }
            catch (Exception e) {
                logger.warning("Error queuing CommandButton event");
            }
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        UIComponent parent = uiComponent.getParent();
        if (!(parent instanceof ContentStackMenu) && !(parent instanceof ContentNavBar)) {
            logger.warning("ContentMenuItem must have parent of ContentStackMenu or ContentNavBa");
            return;
        }
        if (parent instanceof ContentStackMenu) {
            this.renderItemAsList(parent, facesContext, uiComponent);
        }
        if (parent instanceof ContentNavBar) {
            this.renderItemAsButton(parent, facesContext, uiComponent);
        }
    }

    private void renderItemAsButton(UIComponent parent, FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ContentMenuItem item = (ContentMenuItem)uiComponent;
        ContentNavBar navBar = (ContentNavBar)uiComponent.getParent();
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = item.getClientId(facesContext);
        String stackClientId = null;
        StringBuilder menubuttonClass = new StringBuilder("mobi-contentnavbar-button menu");
        StringBuilder buttonClass = new StringBuilder("mobi-contentnavbar-button");
        UIComponent stack = ContentMenuItemRenderer.findParentContentStack(uiComponent);
        String userDefinedClass = item.getStyleClass();
        if (userDefinedClass != null && userDefinedClass.length() > 0) {
            buttonClass.append(" ").append(userDefinedClass);
            menubuttonClass.append(" ").append(userDefinedClass);
        }
        if (item.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (item.getUrl() != null && !item.isDisabled()) {
            writer.writeAttribute("href", (Object)this.getResourceURL(facesContext, item.getUrl()), null);
        } else if (stack != null && item.getValue() != null) {
            String label;
            stackClientId = stack.getClientId(facesContext);
            String valId = String.valueOf(item.getValue());
            UIComponent pane = stack.findComponent(valId);
            writer.startElement("div", uiComponent);
            writer.writeAttribute("id", (Object)clientId, "id");
            writer.startElement("a", uiComponent);
            writer.writeAttribute("class", (Object)menubuttonClass, "class");
            if (item.getStyle() != null) {
                writer.writeAttribute("style", (Object)item.getStyle(), "style");
            }
            StringBuilder sb = new StringBuilder("mobi.layoutMenu.showContent('").append(stackClientId);
            sb.append("', event");
            sb.append(",{ selectedId: '").append(item.getValue()).append("'");
            sb.append(",singleSubmit: ").append(item.isSingleSubmit());
            sb.append(", parent: '").append(navBar.getClientId(facesContext)).append("'");
            sb.append(", item: '").append(item.getClientId(facesContext)).append("'");
            if (pane != null) {
                String paneId = pane.getClientId(facesContext);
                sb.append(",selClientId: '").append(paneId).append("'");
                ContentPane cp = (ContentPane)pane;
                sb.append(",client: ").append(cp.isClient());
            }
            sb.append("});");
            if (!item.isDisabled()) {
                writer.writeAttribute("onclick", (Object)sb.toString(), null);
            }
            if (this.isLabelEmpty(label = item.getLabel())) {
                label = valId;
            }
            writer.write(label);
            writer.endElement("a");
            writer.endElement("div");
        }
    }

    private void renderItemAsList(UIComponent parent, FacesContext facesContext, UIComponent uiComponent) throws IOException {
        UIComponent stack;
        ContentStackMenu parentMenu = (ContentStackMenu)parent;
        ContentMenuItem lmi = (ContentMenuItem)uiComponent;
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = lmi.getClientId(facesContext);
        String contentStackId = parentMenu.getContentStackId();
        String stackClientId = null;
        StringBuilder baseClass = new StringBuilder(ContentMenuItem.OUTPUTLISTITEMDEFAULT_CLASS);
        StringBuilder disabledClass = new StringBuilder(ContentMenuItem.DISABLED_STYLE_CLASS);
        StringBuilder groupClass = new StringBuilder(ContentMenuItem.OUTPUTLISTITEMGROUP_CLASS);
        StringBuilder itemClass = new StringBuilder(ContentMenuItem.OUTPUTLISTITEM_CLASS);
        String userDefClass = lmi.getStyleClass();
        if (null != userDefClass) {
            baseClass.append(" ").append(userDefClass);
            groupClass.append(" ").append(userDefClass);
            disabledClass.append(" ").append(userDefClass);
            itemClass.append(" ").append(userDefClass);
        }
        if (lmi.isDisabled()) {
            // empty if block
        }
        boolean client = false;
        boolean accordion = parentMenu.isAccordion();
        String selId = null;
        if (null != lmi.getValue()) {
            selId = (String)lmi.getValue();
        }
        UIViewRoot root = facesContext.getViewRoot();
        String selClientId = null;
        if (null == ((ContentStackMenu)parent).getStackClientId()) {
            stack = root.findComponent(contentStackId);
            if (stack != null) {
                stackClientId = stack.getClientId(facesContext);
            } else {
                UIComponent form = JSFUtils.findParentForm(uiComponent);
                stackClientId = this.findCompIntree(facesContext, form, contentStackId);
            }
            if (null != stackClientId) {
                ((ContentStackMenu)parent).setStackClientId(stackClientId);
            } else {
                logger.warning("ERROR unable to find stack id=" + contentStackId);
            }
        }
        stackClientId = ((ContentStackMenu)parent).getStackClientId();
        stack = null;
        if (stackClientId != null) {
            stack = root.findComponent(stackClientId);
        } else {
            logger.warning(" Error:- Could not find contentStack for contentStackMenu id=" + contentStackId);
        }
        if (null != stack && selId != null) {
            selClientId = this.findCompIntree(facesContext, stack, selId);
            if (selClientId != null) {
                UIComponent pane = root.findComponent(selClientId);
                ContentPane cp = (ContentPane)pane;
                client = cp.isClient();
            } else {
                logger.warning("Unable to find contentPane with id=" + selId);
            }
        }
        String label = lmi.getLabel();
        String url = lmi.getUrl();
        if (this.isLabelEmpty(label)) {
            label = selId != null ? selId : (url != null ? lmi.getUrl() : "MenuItem");
        }
        if (null == selId & url == null) {
            if (accordion) {
                this.writeTitleAsAccordionHandle(facesContext, uiComponent, parentMenu, label);
            } else {
                this.writeItemListStart(uiComponent, writer, clientId);
                writer.writeAttribute("class", (Object)groupClass, "class");
                if (lmi.getStyle() != null) {
                    writer.writeAttribute("style", (Object)lmi.getStyle(), "style");
                }
                writer.startElement("div", uiComponent);
                writer.writeAttribute("class", (Object)baseClass, "class");
                writer.write(label);
                writer.endElement("div");
                writer.endElement("li");
            }
        } else {
            this.writeItemListStart(uiComponent, writer, clientId);
            writer.writeAttribute("class", (Object)itemClass, "class");
            if (lmi.getStyle() != null) {
                writer.writeAttribute("style", (Object)lmi.getStyle(), "style");
            }
            if (lmi.isDisabled()) {
                writer.writeAttribute("disabled", (Object)"true", null);
                baseClass.append(" ").append((CharSequence)disabledClass);
            }
            writer.startElement("div", uiComponent);
            writer.writeAttribute("class", (Object)baseClass, "class");
            writer.startElement("a", uiComponent);
            writer.writeAttribute("class", (Object)"ui-link-inherit", null);
            if (!lmi.isDisabled() && lmi.getUrl() != null) {
                writer.writeAttribute("href", (Object)this.getResourceURL(facesContext, lmi.getUrl()), null);
            } else {
                StringBuilder sb = new StringBuilder("mobi.layoutMenu.showContent('").append(stackClientId).append("', event");
                sb.append(",{ selectedId: '").append(lmi.getValue()).append("'");
                sb.append(",singleSubmit: ").append(lmi.isSingleSubmit());
                if (selClientId != null) {
                    sb.append(",selClientId: '").append(selClientId).append("'");
                }
                sb.append(",client: ").append(client);
                sb.append(", item: '").append(uiComponent.getClientId(facesContext)).append("'");
                sb.append("});");
                if (stack != null && stackClientId != null && !lmi.isDisabled()) {
                    writer.writeAttribute("onclick", (Object)sb.toString(), null);
                }
            }
            writer.write(label);
            writer.endElement("a");
            writer.endElement("div");
            writer.endElement("li");
        }
    }

    private void writeItemListStart(UIComponent uiComponent, ResponseWriter writer, String clientId) throws IOException {
        writer.startElement("li", uiComponent);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, "name");
    }

    private void writeTitleAsAccordionHandle(FacesContext context, UIComponent childComp, ContentStackMenu menu, String title) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (menu.isOpenAccordionHandle()) {
            writer.endElement("ul");
            writer.endElement("div");
            writer.endElement("section");
            menu.setOpenAccordionHandle(false);
        }
        StringBuilder handleClass = new StringBuilder("handle");
        StringBuilder listClass = new StringBuilder("mobi-list ");
        StringBuilder baseClass = new StringBuilder("mobi-layoutmenu ");
        StringBuilder pointerClass = new StringBuilder("pointer");
        String closeClass = "closed";
        StringBuilder cfg = new StringBuilder("{autoheight:true");
        String menuId = menu.getClientId();
        String userDefinedClass = menu.getStyleClass();
        if (userDefinedClass != null && userDefinedClass.length() > 0) {
            handleClass.append(" ").append(userDefinedClass);
            pointerClass.append(" ").append(userDefinedClass);
            listClass.append(" ").append(userDefinedClass);
            baseClass.append(" ").append(userDefinedClass);
        }
        writer.startElement("section", childComp);
        String chId = childComp.getClientId();
        writer.writeAttribute("id", (Object)(chId + "_sect"), "id");
        writer.writeAttribute("class", (Object)closeClass, "class");
        writer.startElement("div", childComp);
        writer.writeAttribute("id", (Object)(chId + "_hndl"), "id");
        writer.writeAttribute("class", (Object)handleClass, "class");
        writer.writeAttribute("onclick", (Object)("ice.mobi.accordionController.toggleMenu('" + menuId + "',this);"), "onclick");
        writer.startElement("span", childComp);
        writer.writeAttribute("class", (Object)pointerClass, "class");
        writer.endElement("span");
        writer.write(title);
        writer.endElement("div");
        writer.startElement("div", childComp);
        writer.writeAttribute("class", (Object)baseClass, "class");
        writer.startElement("ul", childComp);
        writer.writeAttribute("class", (Object)listClass, "class");
        if (menu.getStyle() != null) {
            writer.writeAttribute("style", (Object)menu.getStyle(), "style");
        }
        menu.setOpenAccordionHandle(true);
    }

    public String findCompIntree(FacesContext context, UIComponent compRoot, String id) {
        UIComponent searchComp = compRoot.findComponent(id);
        if (null != searchComp) {
            return searchComp.getClientId();
        }
        String searchId = null;
        compRoot.visitTree(VisitContext.createVisitContext((FacesContext)context, Arrays.asList(id), null), (VisitCallback)new GetClientId(searchId));
        return searchId;
    }

    private boolean isLabelEmpty(String label) {
        return label == null || label.trim().equals("null") || label.length() < 1;
    }

    private static class GetClientId
    implements VisitCallback {
        private String _clientId = null;
        String searchId;

        private GetClientId(String searchId) {
            this.searchId = searchId;
        }

        public String getClientId() {
            return this._clientId;
        }

        public VisitResult visit(VisitContext visitContext, UIComponent uiComponent) {
            if (uiComponent instanceof ContentStack || uiComponent instanceof ContentPane) {
                this._clientId = uiComponent.getId();
                return VisitResult.COMPLETE;
            }
            return VisitResult.ACCEPT;
        }
    }
}

