/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.contentstackmenu;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.mobi.component.contentstack.ContentStack;
import org.icefaces.mobi.component.contentstackmenu.ContentStackMenu;
import org.icefaces.mobi.renderkit.BaseLayoutRenderer;
import org.icefaces.mobi.utils.JSFUtils;

public class ContentStackMenuRenderer
extends BaseLayoutRenderer {
    private static Logger logger = Logger.getLogger(ContentStackMenuRenderer.class.getName());
    private static final String JS_NAME = "layoutmenu.js";
    private static final String JS_MIN_NAME = "layoutmenu-min.js";
    private static final String JS_LIBRARY = "org.icefaces.component.layoutmenu";
    private static final String JS_ACC_NAME = "accordion.js";
    private static final String JS_ACC_MIN_NAME = "accordion-min.js";
    private static final String JS_ACC_LIB = "org.icefaces.component.accordion";

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        ContentStackMenu menu = (ContentStackMenu)uiComponent;
        String clientId = menu.getClientId(facesContext);
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        String cStackId = menu.getContentStackId();
        UIViewRoot root = facesContext.getViewRoot();
        UIComponent stackComp = JSFUtils.findChildComponent((UIComponent)root, cStackId);
        if (stackComp != null && stackComp instanceof ContentStack) {
            String stackId = stackComp.getClientId(facesContext);
            ContentStack stack = (ContentStack)stackComp;
            String indexStr = (String)params.get(clientId + "_hidden");
            String newStr = (String)params.get(stackId);
            String oldIndex = stack.getCurrentId();
            if (null != indexStr && !oldIndex.equals(indexStr)) {
                stack.setCurrentId(indexStr);
            }
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        ContentStackMenu menu = (ContentStackMenu)uiComponent;
        UIComponent form = JSFUtils.findParentForm(uiComponent);
        boolean accordion = menu.isAccordion();
        if (form == null) {
            throw new FacesException("ContentStackMenu : \"" + clientId + "\" must be inside a form element");
        }
        String userDefinedClass = menu.getStyleClass();
        if (accordion) {
            this.writeJavascriptFile(facesContext, uiComponent, JS_NAME, JS_MIN_NAME, JS_LIBRARY, JS_ACC_NAME, JS_ACC_MIN_NAME, JS_ACC_LIB);
        } else {
            this.writeJavascriptFile(facesContext, uiComponent, JS_NAME, JS_MIN_NAME, JS_LIBRARY);
        }
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, "name");
        StringBuilder baseClass = new StringBuilder("mobi-layoutmenu ");
        StringBuilder listClass = new StringBuilder("mobi-list ");
        StringBuilder baseAccordionClass = new StringBuilder("mobi-layoutmenu mobi-accordion");
        if (null != userDefinedClass) {
            baseClass.append(userDefinedClass);
            listClass.append(userDefinedClass);
            baseAccordionClass.append(" ").append(userDefinedClass);
        }
        if (menu.getStyle() != null) {
            writer.writeAttribute("style", (Object)menu.getStyle(), "style");
        }
        if (accordion) {
            writer.startElement("div", uiComponent);
            writer.writeAttribute("id", (Object)(clientId + "_acc"), "id");
            writer.writeAttribute("class", (Object)baseAccordionClass.toString(), null);
        } else {
            writer.writeAttribute("class", (Object)baseClass.toString(), null);
            writer.startElement("ul", uiComponent);
            writer.writeAttribute("class", (Object)listClass.toString(), "class");
        }
        if (menu.getVar() != null) {
            menu.setRowIndex(-1);
            for (int i = 0; i < menu.getRowCount(); ++i) {
                menu.setRowIndex(i);
                this.renderChildren(facesContext, (UIComponent)menu);
            }
            menu.setRowIndex(-1);
        } else {
            this.renderChildren(facesContext, (UIComponent)menu);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        ContentStackMenu menu = (ContentStackMenu)component;
        writer.endElement("ul");
        if (menu.isAccordion()) {
            writer.endElement("div");
            writer.endElement("section");
            writer.endElement("div");
        }
        this.encodeHidden(facesContext, component);
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

