/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.datespinner;

import java.io.IOException;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.DateTimeConverter;
import org.icefaces.mobi.component.datespinner.DateSpinner;
import org.icefaces.mobi.renderkit.BaseInputRenderer;
import org.icefaces.mobi.utils.MobiJSFUtils;
import org.icefaces.mobi.utils.PassThruAttributeWriter;
import org.icefaces.mobi.utils.Utils;

public class DateSpinnerRenderer
extends BaseInputRenderer {
    private static Logger logger = Logger.getLogger(DateSpinnerRenderer.class.getName());
    private static final String JS_NAME = "datespinner.js";
    private static final String JS_MIN_NAME = "datespinner-min.js";
    private static final String JS_LIBRARY = "org.icefaces.component.datespinner";
    public static final String TOUCH_START_EVENT = "ontouchstart";
    public static final String CLICK_EVENT = "onclick";

    public void decode(FacesContext context, UIComponent component) {
        DateSpinner dateSpinner = (DateSpinner)component;
        String clientId = dateSpinner.getClientId(context);
        if (dateSpinner.isDisabled()) {
            return;
        }
        String inputField = clientId + "_input";
        if (this.shouldUseNative(dateSpinner)) {
            inputField = clientId;
        }
        String inputValue = (String)context.getExternalContext().getRequestParameterMap().get(inputField);
        String hiddenValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId + "_hidden");
        if (!this.isValueBlank(inputValue)) {
            dateSpinner.setSubmittedValue(inputValue);
        } else if (!this.isValueBlank(hiddenValue)) {
            dateSpinner.setSubmittedValue(hiddenValue);
        }
        this.decodeBehaviors(context, (UIComponent)dateSpinner);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        DateSpinner spinner = (DateSpinner)component;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = spinner.getClientId(context);
        ClientBehaviorHolder cbh = (ClientBehaviorHolder)component;
        boolean hasBehaviors = !cbh.getClientBehaviors().isEmpty();
        boolean singleSubmit = spinner.isSingleSubmit();
        spinner.setTouchEnabled(Utils.isTouchEventEnabled(context));
        String initialValue = DateSpinnerRenderer.getStringValueToRender(context, component);
        if (this.shouldUseNative(spinner)) {
            writer.startElement("input", component);
            writer.writeAttribute("type", (Object)"date", "type");
            writer.writeAttribute("id", (Object)clientId, null);
            writer.writeAttribute("name", (Object)clientId, null);
            if (spinner.getStyle() != null) {
                writer.writeAttribute("style", (Object)spinner.getStyle(), "style");
            }
            boolean disabled = spinner.isDisabled();
            boolean readonly = spinner.isReadonly();
            if (this.isValueBlank(initialValue)) {
                SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd");
                Date aDate = new Date();
                writer.writeAttribute("value", (Object)df2.format(aDate), "value");
            } else {
                writer.writeAttribute("value", (Object)initialValue, "value");
            }
            if (disabled) {
                writer.writeAttribute("disabled", (Object)component, "disabled");
            }
            if (readonly) {
                writer.writeAttribute("readonly", (Object)component, "readonly");
            }
            boolean noJs = false;
            if (readonly || disabled) {
                noJs = true;
            }
            if (!noJs && hasBehaviors) {
                String event = spinner.getDefaultEventName(context);
                String cbhCall = this.buildAjaxRequest(context, cbh, event);
                writer.writeAttribute("onblur", (Object)cbhCall, null);
            } else if (!noJs && singleSubmit) {
                writer.writeAttribute("onblur", (Object)"ice.se(event, this);", null);
            }
            writer.endElement("input");
        } else {
            this.writeJavascriptFile(context, component, JS_NAME, JS_MIN_NAME, JS_LIBRARY);
            String value = this.encodeValue(spinner, initialValue);
            this.encodeMarkup(context, component, value, hasBehaviors);
            this.encodeScript(context, component);
        }
    }

    protected void encodeMarkup(FacesContext context, UIComponent uiComponent, String value, boolean hasBehaviors) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        DateSpinner dateSpinner = (DateSpinner)uiComponent;
        String clientId = dateSpinner.getClientId(context);
        ClientBehaviorHolder cbh = (ClientBehaviorHolder)uiComponent;
        String eventStr = dateSpinner.isTouchEnabled() ? TOUCH_START_EVENT : CLICK_EVENT;
        boolean singleSubmit = dateSpinner.isSingleSubmit();
        StringBuilder builder = new StringBuilder(255);
        StringBuilder builder2 = new StringBuilder(255);
        String inputCallStart = "mobi.datespinner.inputSubmit('";
        String jsCallStart = "mobi.datespinner.select('";
        builder2.append(clientId).append("',{ event: event,");
        builder2.append("singleSubmit: ").append(singleSubmit);
        if (hasBehaviors) {
            String behaviors = this.encodeClientBehaviors(context, cbh, "change").toString();
            behaviors = behaviors.replace("\"", "'");
            builder2.append(behaviors);
        }
        builder2.append("});");
        boolean disabledOrReadonly = false;
        boolean disabled = dateSpinner.isDisabled();
        boolean readonly = dateSpinner.isReadonly();
        if (readonly || disabled) {
            disabledOrReadonly = true;
        }
        builder.append(jsCallStart).append((CharSequence)builder2);
        StringBuilder inputCall = new StringBuilder(inputCallStart).append((CharSequence)builder2);
        String jsCall = builder.toString();
        writer.startElement("span", uiComponent);
        if (dateSpinner.getStyle() != null) {
            writer.writeAttribute("style", (Object)dateSpinner.getStyle(), "style");
        }
        writer.startElement("span", uiComponent);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, "name");
        writer.writeAttribute("class", (Object)"mobi-date-wrapper", "class");
        writer.startElement("input", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_input"), "id");
        writer.writeAttribute("name", (Object)(clientId + "_input"), "name");
        if (!disabledOrReadonly) {
            writer.writeAttribute("onblur", (Object)inputCall.toString(), null);
        }
        PassThruAttributeWriter.renderNonBooleanAttributes(writer, uiComponent, dateSpinner.getCommonAttributeNames());
        StringBuilder classNames = new StringBuilder("mobi-input-text");
        String checker = dateSpinner.getStyleClass();
        if (null != checker) {
            classNames.append(" ").append(dateSpinner.getStyleClass());
        }
        writer.writeAttribute("class", (Object)classNames.toString(), "class");
        if (value != null) {
            writer.writeAttribute("value", (Object)value, null);
        }
        writer.writeAttribute("type", (Object)"text", "type");
        if (readonly) {
            writer.writeAttribute("readonly", (Object)"readonly", null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        writer.endElement("input");
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)(clientId + "_hidden"), "id");
        writer.writeAttribute("name", (Object)(clientId + "_hidden"), "name");
        writer.endElement("input");
        writer.endElement("span");
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"button", "type");
        writer.writeAttribute("value", (Object)"", null);
        writer.writeAttribute("class", (Object)"mobi-date-popup-btn", null);
        if (dateSpinner.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (!disabledOrReadonly) {
            writer.writeAttribute(CLICK_EVENT, (Object)("mobi.datespinner.toggle('" + clientId + "');"), null);
        }
        writer.endElement("input");
        writer.endElement("span");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_bg"), "id");
        writer.writeAttribute("class", (Object)"mobi-date-bg-inv", "class");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_popup"), "id");
        writer.writeAttribute("class", (Object)"mobi-date-container-inv", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_title"), "id");
        writer.writeAttribute("class", (Object)"mobi-date-title-container", null);
        writer.write(value);
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-select-container", null);
        String pattern = this.findPattern(dateSpinner);
        if (pattern != null) {
            int yStart = pattern.toLowerCase().indexOf("y");
            int mStart = pattern.toLowerCase().indexOf("m");
            int dStart = pattern.toLowerCase().indexOf("d");
            if (yStart < mStart && mStart < dStart) {
                this.renderYearInput(writer, uiComponent, dateSpinner, clientId, eventStr);
                this.renderMonthInput(writer, uiComponent, dateSpinner, clientId, eventStr);
                this.renderDayInput(writer, uiComponent, dateSpinner, clientId, eventStr);
            } else if (yStart < dStart && dStart < mStart) {
                this.renderYearInput(writer, uiComponent, dateSpinner, clientId, eventStr);
                this.renderDayInput(writer, uiComponent, dateSpinner, clientId, eventStr);
                this.renderMonthInput(writer, uiComponent, dateSpinner, clientId, eventStr);
            } else if (dStart < mStart && mStart < yStart) {
                this.renderDayInput(writer, uiComponent, dateSpinner, clientId, eventStr);
                this.renderMonthInput(writer, uiComponent, dateSpinner, clientId, eventStr);
                this.renderYearInput(writer, uiComponent, dateSpinner, clientId, eventStr);
            } else if (mStart < dStart && dStart < yStart) {
                this.renderMonthInput(writer, uiComponent, dateSpinner, clientId, eventStr);
                this.renderDayInput(writer, uiComponent, dateSpinner, clientId, eventStr);
                this.renderYearInput(writer, uiComponent, dateSpinner, clientId, eventStr);
            } else {
                this.renderYearInput(writer, uiComponent, dateSpinner, clientId, eventStr);
                this.renderMonthInput(writer, uiComponent, dateSpinner, clientId, eventStr);
                this.renderDayInput(writer, uiComponent, dateSpinner, clientId, eventStr);
            }
        } else {
            this.renderYearInput(writer, uiComponent, dateSpinner, clientId, eventStr);
            this.renderMonthInput(writer, uiComponent, dateSpinner, clientId, eventStr);
            this.renderDayInput(writer, uiComponent, dateSpinner, clientId, eventStr);
        }
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-submit-container", null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-button ui-btn-up-c", null);
        writer.writeAttribute("type", (Object)"button", "type");
        writer.writeAttribute("value", (Object)"Set", null);
        if (!dateSpinner.isDisabled() && !dateSpinner.isReadonly()) {
            writer.writeAttribute(CLICK_EVENT, (Object)jsCall, null);
        }
        writer.endElement("input");
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-button ui-btn-up-c", null);
        writer.writeAttribute("type", (Object)"button", "type");
        writer.writeAttribute("value", (Object)"Cancel", null);
        writer.writeAttribute(CLICK_EVENT, (Object)("mobi.datespinner.close('" + clientId + "');"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.endElement("div");
    }

    public void encodeScript(FacesContext context, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        DateSpinner spinner = (DateSpinner)uiComponent;
        String clientId = spinner.getClientId(context);
        int yrInt = spinner.getYearInt();
        int mnthInt = spinner.getMonthInt();
        int dateInt = spinner.getDayInt();
        writer.startElement("span", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-hidden", null);
        writer.writeAttribute("id", (Object)(clientId + "_script"), "id");
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("mobi.datespinner.init('" + clientId + "'," + yrInt + "," + mnthInt + "," + dateInt + ",'" + this.findPattern(spinner) + "');");
        writer.endElement("script");
        writer.endElement("span");
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object value) throws ConverterException {
        DateSpinner spinner = (DateSpinner)component;
        String submittedValue = String.valueOf(value);
        Converter converter = spinner.getConverter();
        if (converter != null) {
            Object objVal = converter.getAsObject(context, (UIComponent)spinner, submittedValue);
            return objVal;
        }
        try {
            Locale locale = spinner.calculateLocale(context);
            String pattern = this.findPattern(spinner);
            SimpleDateFormat format = new SimpleDateFormat(pattern, locale);
            format.setTimeZone(spinner.calculateTimeZone());
            Date convertedValue = format.parse(submittedValue);
            return convertedValue;
        }
        catch (ParseException e) {
            throw new ConverterException((Throwable)e);
        }
    }

    private void renderDayInput(ResponseWriter writer, UIComponent uiComponent, DateSpinner dateEntry, String clientId, String eventStr) throws IOException {
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-select-value-cont", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn-cont-incr", null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn mobi-date-btn-incr", null);
        writer.writeAttribute("id", (Object)(clientId + "_dUpBtn"), null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(eventStr, (Object)("mobi.datespinner.dUp('" + clientId + "');"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-select-value", null);
        writer.writeAttribute("id", (Object)(clientId + "_dInt"), null);
        writer.write(String.valueOf(dateEntry.getDayInt()));
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn-cont-decr", null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn mobi-date-btn-decr", null);
        writer.writeAttribute("id", (Object)(clientId + "_dDnBtn"), null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(eventStr, (Object)("mobi.datespinner.dDn('" + clientId + "');"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.endElement("div");
    }

    private void renderMonthInput(ResponseWriter writer, UIComponent uiComponent, DateSpinner dateEntry, String clientId, String eventStr) throws IOException {
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-select-value-cont", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn-cont-incr", null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn mobi-date-btn-incr", null);
        writer.writeAttribute("id", (Object)(clientId + "_mUpBtn"), null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(eventStr, (Object)("mobi.datespinner.mUp('" + clientId + "');"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-select-value", null);
        writer.writeAttribute("id", (Object)(clientId + "_mInt"), null);
        writer.write(String.valueOf(dateEntry.getMonthInt()));
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn-cont-decr", null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn mobi-date-btn-decr", null);
        writer.writeAttribute("id", (Object)(clientId + "_mDnBtn"), null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(eventStr, (Object)("mobi.datespinner.mDn('" + clientId + "');"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.endElement("div");
    }

    private void renderYearInput(ResponseWriter writer, UIComponent uiComponent, DateSpinner dateEntry, String clientId, String eventStr) throws IOException {
        int yMin = dateEntry.getYearStart();
        int yMax = dateEntry.getYearEnd();
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-select-value-cont", null);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn-cont-incr", null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn mobi-date-btn-incr", null);
        writer.writeAttribute("id", (Object)(clientId + "_yUpBtn"), null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(eventStr, (Object)("mobi.datespinner.yUp('" + clientId + "'," + yMin + "," + yMax + ");"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-select-value", null);
        writer.writeAttribute("id", (Object)(clientId + "_yInt"), null);
        writer.write(String.valueOf(dateEntry.getYearInt()));
        writer.endElement("div");
        writer.startElement("div", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn-cont-decr", null);
        writer.startElement("input", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-date-btn mobi-date-btn-decr", null);
        writer.writeAttribute("id", (Object)(clientId + "_yDnBtn"), null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute(eventStr, (Object)("mobi.datespinner.yDn('" + clientId + "'," + yMin + "," + yMax + ");"), null);
        writer.endElement("input");
        writer.endElement("div");
        writer.endElement("div");
    }

    private void setIntValues(DateSpinner spinner, Date aDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(aDate);
        spinner.setYearInt(cal.get(1));
        spinner.setMonthInt(cal.get(2) + 1);
        spinner.setDayInt(cal.get(5));
    }

    private String convertStringInput(String patternIn, String patternOut, String inString) {
        SimpleDateFormat df1 = new SimpleDateFormat(patternIn);
        SimpleDateFormat df2 = new SimpleDateFormat(patternOut);
        String returnString = inString;
        try {
            Date aDate = df1.parse(inString);
            returnString = df2.format(aDate);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error converting string input.", e);
        }
        return returnString;
    }

    private String encodeValue(DateSpinner spinner, String initialValue) {
        String value = "";
        Date aDate = new Date();
        String pattern = this.findPattern(spinner);
        SimpleDateFormat df2 = new SimpleDateFormat(pattern);
        if (!this.isValueBlank(initialValue)) {
            try {
                if (this.isFormattedDate(initialValue, pattern)) {
                    value = initialValue;
                    aDate = df2.parse(value);
                } else if (this.isFormattedDate(initialValue, "EEE MMM dd hh:mm:ss zzz yyyy")) {
                    value = this.convertStringInput("EEE MMM dd hh:mm:ss zzz yyyy", pattern, initialValue);
                    aDate = df2.parse(value);
                }
            }
            catch (Exception e) {
                throw new ConverterException();
            }
        }
        this.setIntValues(spinner, aDate);
        return value;
    }

    private boolean isFormattedDate(String inStr, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.parse(inStr, new ParsePosition(0)) != null;
    }

    private boolean shouldUseNative(DateSpinner component) {
        return component.isUseNative() && MobiJSFUtils.getClientDescriptor().isHasNativeDatePicker();
    }

    private String findPattern(DateSpinner dateSpinner) {
        String pattern = dateSpinner.getPattern();
        Converter converter = dateSpinner.getConverter();
        if (converter != null && converter instanceof DateTimeConverter) {
            DateTimeConverter tmp = (DateTimeConverter)converter;
            pattern = tmp.getPattern();
        }
        return pattern;
    }
}

