/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.flipswitch;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.servlet.http.HttpServletRequest;
import org.icefaces.mobi.component.flipswitch.FlipSwitch;
import org.icefaces.mobi.renderkit.CoreRenderer;
import org.icefaces.mobi.utils.PassThruAttributeWriter;
import org.icemobile.util.ClientDescriptor;

public class FlipSwitchRenderer
extends CoreRenderer {
    private static final Logger logger = Logger.getLogger(FlipSwitchRenderer.class.getName());
    private static final String JS_NAME = "flipswitch.js";
    private static final String JS_MIN_NAME = "flipswitch-min.js";
    private static final String JS_LIBRARY = "org.icefaces.component.flipswitch";

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String clientId = uiComponent.getClientId(facesContext);
        FlipSwitch flipswitch = (FlipSwitch)uiComponent;
        if (flipswitch.isDisabled()) {
            return;
        }
        String submittedString = String.valueOf(requestParameterMap.get(clientId + "_hidden"));
        if (submittedString != null) {
            boolean submittedValue = this.isChecked(submittedString);
            flipswitch.setSubmittedValue(submittedValue);
            this.decodeBehaviors(facesContext, (UIComponent)flipswitch);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String clientId = uiComponent.getClientId(facesContext);
        ResponseWriter writer = facesContext.getResponseWriter();
        FlipSwitch flipswitch = (FlipSwitch)uiComponent;
        ClientBehaviorHolder cbh = (ClientBehaviorHolder)uiComponent;
        boolean hasBehaviors = !cbh.getClientBehaviors().isEmpty();
        this.writeJavascriptFile(facesContext, uiComponent, JS_NAME, JS_MIN_NAME, JS_LIBRARY);
        writer.startElement("a", uiComponent);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, "name");
        String styleClass = "mobi-flipswitch mobi-flipswitch-off ui-btn-down-c";
        String switchValue = String.valueOf(flipswitch.getValue());
        boolean isChecked = this.isChecked(switchValue);
        if (isChecked) {
            styleClass = "mobi-flipswitch mobi-flipswitch-on ui-btn-down-c";
        }
        writer.writeAttribute("class", (Object)styleClass, "class");
        PassThruAttributeWriter.renderNonBooleanAttributes(writer, uiComponent, flipswitch.getAttributesNames());
        PassThruAttributeWriter.renderBooleanAttributes(writer, uiComponent, flipswitch.getBooleanAttNames());
        String labelOn = flipswitch.getLabelOn();
        String labelOff = flipswitch.getLabelOff();
        boolean disabled = flipswitch.isDisabled();
        boolean readonly = flipswitch.isReadonly();
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        StringBuilder builder = new StringBuilder(255);
        builder.append("mobi.flipswitch.init('").append(clientId).append("',{ event: event,elVal: this,");
        builder.append("singleSubmit: ").append(flipswitch.isSingleSubmit());
        if (hasBehaviors) {
            String behaviors = this.encodeClientBehaviors(facesContext, cbh, "click").toString();
            behaviors = behaviors.replace("\"", "'");
            builder.append(behaviors);
        }
        if (this.isTransformerHack(facesContext)) {
            logger.finest("Transformer Prime hack active");
            builder.append(", transHack: 'true'");
        }
        builder.append("}); return false; ");
        String jsCall = builder.toString();
        if (!disabled | !readonly) {
            writer.writeAttribute("onclick", (Object)jsCall, null);
        }
        writer.writeAttribute("class", (Object)styleClass, "class");
        writer.startElement("span", uiComponent);
        boolean switchVal = (Boolean)flipswitch.getValue();
        writer.writeAttribute("class", (Object)("mobi-flipswitch-txt-on" + (switchVal ? "" : " ui-btn-up-c")), null);
        writer.write(labelOn);
        writer.endElement("span");
        this.writeHiddenField(uiComponent, clientId, writer, switchVal);
        writer.startElement("span", uiComponent);
        writer.writeAttribute("class", (Object)("mobi-flipswitch-txt-off" + (switchVal ? " ui-btn-up-c" : "")), null);
        writer.write(labelOff);
        writer.endElement("span");
        writer.endElement("a");
    }

    private void writeHiddenField(UIComponent uiComponent, String clientId, ResponseWriter writer, boolean switchValue) throws IOException {
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", (Object)(clientId + "_hidden"), null);
        writer.writeAttribute("id", (Object)(clientId + "_hidden"), null);
        writer.writeAttribute("value", (Object)switchValue, null);
        writer.endElement("input");
    }

    private boolean isChecked(String hiddenValue) {
        return hiddenValue.equalsIgnoreCase("on") || hiddenValue.equalsIgnoreCase("yes") || hiddenValue.equalsIgnoreCase("true");
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        if (submittedValue instanceof Boolean) {
            return submittedValue;
        }
        return Boolean.valueOf(submittedValue.toString());
    }

    public boolean getRendersChildren() {
        return true;
    }

    private boolean isTransformerHack(FacesContext pageContext) {
        HttpServletRequest hsr;
        ClientDescriptor client;
        String ua;
        Object request = pageContext.getExternalContext().getRequest();
        if (request instanceof HttpServletRequest && (ua = (client = ClientDescriptor.getInstance(hsr = (HttpServletRequest)request)).getUserAgent()) != null) {
            ua = ua.toLowerCase();
            return ua.contains("transformer prime");
        }
        return false;
    }
}

