/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.googleanalytics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.StateHelper;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.component.UIViewRoot;
import org.icefaces.mobi.component.googleanalytics.IGoogleAnalytics;

@ResourceDependencies(value={@ResourceDependency(name="component.js", library="org.icefaces.component.util", target="")})
public abstract class GoogleAnalyticsBase
extends UIPanel
implements IGoogleAnalytics {
    public static final String COMPONENT_TYPE = "org.icefaces.GoogleAnalytics";
    public static final String RENDERER_TYPE = "org.icefaces.GoogleAnalyticsRenderer";

    public GoogleAnalyticsBase() {
        this.setRendererType(RENDERER_TYPE);
    }

    public String getFamily() {
        return COMPONENT_TYPE;
    }

    public void setAccount(String account) {
        ValueExpression ve = this.getValueExpression(PropertyKeys.account.toString());
        if (ve != null) {
            ve.setValue(this.getFacesContext().getELContext(), (Object)account);
        } else {
            StateHelper sh = this.getStateHelper();
            if (GoogleAnalyticsBase.isDisconnected((UIComponent)this)) {
                String defaultKey = PropertyKeys.account.toString() + "_defaultValues";
                HashMap<String, String> clientDefaults = (HashMap<String, String>)sh.get((Serializable)((Object)defaultKey));
                if (clientDefaults == null && account != null) {
                    clientDefaults = new HashMap<String, String>();
                    clientDefaults.put("defValue", account);
                    sh.put((Serializable)((Object)defaultKey), clientDefaults);
                }
            } else {
                String clientId = this.getClientId();
                String valuesKey = PropertyKeys.account.toString() + "_rowValues";
                HashMap<String, String> clientValues = (HashMap<String, String>)sh.get((Serializable)((Object)valuesKey));
                if (clientValues == null) {
                    clientValues = new HashMap<String, String>();
                }
                if (account == null) {
                    clientValues.remove(clientId);
                } else {
                    clientValues.put(clientId, account);
                }
                sh.put((Serializable)((Object)valuesKey), clientValues);
            }
        }
    }

    public String getAccount() {
        String retVal = null;
        ValueExpression ve = this.getValueExpression(PropertyKeys.account.toString());
        if (ve != null) {
            retVal = (String)ve.getValue(this.getFacesContext().getELContext());
        } else {
            String defaultKey;
            Map defaultValues;
            StateHelper sh = this.getStateHelper();
            String valuesKey = PropertyKeys.account.toString() + "_rowValues";
            Map clientValues = (Map)sh.get((Serializable)((Object)valuesKey));
            boolean mapNoValue = false;
            if (clientValues != null) {
                String clientId = this.getClientId();
                if (clientValues.containsKey(clientId)) {
                    retVal = (String)clientValues.get(clientId);
                } else {
                    mapNoValue = true;
                }
            }
            if ((mapNoValue || clientValues == null) && (defaultValues = (Map)sh.get((Serializable)((Object)(defaultKey = PropertyKeys.account.toString() + "_defaultValues")))) != null && defaultValues.containsKey("defValue")) {
                retVal = (String)defaultValues.get("defValue");
            }
        }
        return retVal;
    }

    public void setDomain(String domain) {
        ValueExpression ve = this.getValueExpression(PropertyKeys.domain.toString());
        if (ve != null) {
            ve.setValue(this.getFacesContext().getELContext(), (Object)domain);
        } else {
            StateHelper sh = this.getStateHelper();
            if (GoogleAnalyticsBase.isDisconnected((UIComponent)this)) {
                String defaultKey = PropertyKeys.domain.toString() + "_defaultValues";
                HashMap<String, String> clientDefaults = (HashMap<String, String>)sh.get((Serializable)((Object)defaultKey));
                if (clientDefaults == null && domain != null) {
                    clientDefaults = new HashMap<String, String>();
                    clientDefaults.put("defValue", domain);
                    sh.put((Serializable)((Object)defaultKey), clientDefaults);
                }
            } else {
                String clientId = this.getClientId();
                String valuesKey = PropertyKeys.domain.toString() + "_rowValues";
                HashMap<String, String> clientValues = (HashMap<String, String>)sh.get((Serializable)((Object)valuesKey));
                if (clientValues == null) {
                    clientValues = new HashMap<String, String>();
                }
                if (domain == null) {
                    clientValues.remove(clientId);
                } else {
                    clientValues.put(clientId, domain);
                }
                sh.put((Serializable)((Object)valuesKey), clientValues);
            }
        }
    }

    public String getDomain() {
        String retVal = null;
        ValueExpression ve = this.getValueExpression(PropertyKeys.domain.toString());
        if (ve != null) {
            retVal = (String)ve.getValue(this.getFacesContext().getELContext());
        } else {
            String defaultKey;
            Map defaultValues;
            StateHelper sh = this.getStateHelper();
            String valuesKey = PropertyKeys.domain.toString() + "_rowValues";
            Map clientValues = (Map)sh.get((Serializable)((Object)valuesKey));
            boolean mapNoValue = false;
            if (clientValues != null) {
                String clientId = this.getClientId();
                if (clientValues.containsKey(clientId)) {
                    retVal = (String)clientValues.get(clientId);
                } else {
                    mapNoValue = true;
                }
            }
            if ((mapNoValue || clientValues == null) && (defaultValues = (Map)sh.get((Serializable)((Object)(defaultKey = PropertyKeys.domain.toString() + "_defaultValues")))) != null && defaultValues.containsKey("defValue")) {
                retVal = (String)defaultValues.get("defValue");
            }
        }
        return retVal;
    }

    private static boolean isDisconnected(UIComponent component) {
        UIComponent parent = component.getParent();
        if (parent != null && parent instanceof UIViewRoot) {
            return false;
        }
        if (parent != null) {
            return GoogleAnalyticsBase.isDisconnected(parent);
        }
        return true;
    }

    private void handleAttribute(String name, Object value) {
        String cname;
        ArrayList<String> setAttributes = (ArrayList<String>)this.getAttributes().get("javax.faces.component.UIComponentBase.attributesThatAreSet");
        if (setAttributes == null && (cname = this.getClass().getName()) != null) {
            setAttributes = new ArrayList<String>(6);
            this.getAttributes().put("javax.faces.component.UIComponentBase.attributesThatAreSet", setAttributes);
        }
        if (setAttributes != null) {
            if (value == null) {
                ValueExpression ve = this.getValueExpression(name);
                if (ve == null) {
                    setAttributes.remove(name);
                }
            } else if (!setAttributes.contains(name)) {
                setAttributes.add(name);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        account,
        domain;

        String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : this.name();
        }
    }
}

