/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.list;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.icefaces.mobi.component.list.OutputList;
import org.icefaces.mobi.component.list.OutputListItem;

public class OutputListRenderer
extends Renderer {
    private static Logger logger = Logger.getLogger(OutputListRenderer.class.getName());

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        OutputList list = (OutputList)uiComponent;
        writer.startElement("ul", uiComponent);
        writer.writeAttribute("id", (Object)clientId, "id");
        String userDefinedClass = list.getStyleClass();
        StringBuilder styleClasses = new StringBuilder("mobi-list ui-listview ");
        if (list.isInset()) {
            styleClasses.append(" ").append("mobi-list-inset ui-listview-inset ");
        }
        if (userDefinedClass != null) {
            styleClasses.append(" ").append(userDefinedClass);
        }
        writer.writeAttribute("class", (Object)styleClasses.toString(), "styleClass");
        if (list.getStyle() != null) {
            writer.writeAttribute("style", (Object)list.getStyle(), "style");
        }
        if (facesContext.isProjectStage(ProjectStage.Development) || logger.isLoggable(Level.FINER)) {
            List children = uiComponent.getChildren();
            for (UIComponent child : children) {
                if (child instanceof OutputListItem) continue;
                logger.finer("The OutputList component allows only children of type OutputListItem or OutputListItems");
            }
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.endElement("ul");
    }
}

