/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.microphone;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.render.Renderer;
import org.icefaces.mobi.component.microphone.Microphone;
import org.icefaces.mobi.renderkit.ResponseWriterWrapper;
import org.icefaces.mobi.utils.MobiJSFUtils;
import org.icemobile.renderkit.DeviceCoreRenderer;

public class MicrophoneRenderer
extends Renderer {
    private static Logger logger = Logger.getLogger(MicrophoneRenderer.class.getName());

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        Microphone microphone = (Microphone)uiComponent;
        String clientId = microphone.getClientId();
        if (microphone.isDisabled()) {
            return;
        }
        try {
            HashMap map = new HashMap();
            boolean valid = this.extractAudio(facesContext, map, clientId);
            if (valid && map != null) {
                microphone.setValue(map);
                uiComponent.queueEvent((FacesEvent)new ValueChangeEvent(uiComponent, null, map));
            }
        }
        catch (Exception e) {
            logger.warning("Exception decoding audio stream: " + e);
        }
    }

    public boolean extractAudio(FacesContext facesContext, Map map, String clientId) throws IOException {
        return MobiJSFUtils.decodeComponentFile(facesContext, clientId, map);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Microphone microphone = (Microphone)uiComponent;
        String oldLabel = microphone.getButtonLabel();
        if (MobiJSFUtils.uploadInProgress((UIComponent)microphone)) {
            microphone.setButtonLabel(microphone.getCaptureMessageLabel());
        }
        DeviceCoreRenderer renderer = new DeviceCoreRenderer();
        ResponseWriterWrapper writer = new ResponseWriterWrapper(facesContext.getResponseWriter());
        renderer.encode(microphone, writer, false);
        microphone.setButtonLabel(oldLabel);
    }
}

