/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.splitpane;

import java.io.IOException;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.mobi.component.splitpane.SplitPane;
import org.icefaces.mobi.renderkit.BaseLayoutRenderer;
import org.icefaces.mobi.renderkit.ResponseWriterWrapper;
import org.icefaces.mobi.utils.JSFUtils;
import org.icemobile.renderkit.IResponseWriter;
import org.icemobile.renderkit.SplitPaneCoreRenderer;

public class SplitPaneRenderer
extends BaseLayoutRenderer {
    private static Logger logger = Logger.getLogger(SplitPaneRenderer.class.getName());
    private static final String JS_NAME = "splitpane.js";
    private static final String JS_MIN_NAME = "splitpane-min.js";
    private static final String JS_LIBRARY = "org.icefaces.component.splitpane";

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String clientId = uiComponent.getClientId(facesContext);
        SplitPane pane = (SplitPane)uiComponent;
        UIComponent leftFacet = pane.getFacet("left");
        UIComponent rightFacet = pane.getFacet("right");
        if (leftFacet == null && rightFacet == null) {
            logger.warning("This component may ONLY have  both the left and right facets together");
            return;
        }
        SplitPaneCoreRenderer renderer = new SplitPaneCoreRenderer();
        ResponseWriterWrapper writer = new ResponseWriterWrapper(facesContext.getResponseWriter());
        renderer.encodeBegin(pane, writer);
        if (leftFacet != null && rightFacet != null) {
            this.writeJavascriptFile(facesContext, uiComponent, JS_NAME, JS_MIN_NAME, JS_LIBRARY);
        }
        renderer.encodePane(pane, (IResponseWriter)writer, "left");
        JSFUtils.renderChild(facesContext, leftFacet);
        renderer.encodePaneEnd(writer);
        renderer.encodeColumnDivider(pane, writer);
        renderer.encodePane(pane, (IResponseWriter)writer, "right");
        JSFUtils.renderChild(facesContext, rightFacet);
        renderer.encodePaneEnd(writer);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        SplitPane pane = (SplitPane)component;
        SplitPaneCoreRenderer renderer = new SplitPaneCoreRenderer();
        ResponseWriterWrapper writer = new ResponseWriterWrapper(facesContext.getResponseWriter());
        renderer.encodeEnd(pane, writer);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    private void encodeScript(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        SplitPane pane = (SplitPane)uiComponent;
        String clientId = pane.getClientId(facesContext);
        writer.startElement("span", uiComponent);
        writer.writeAttribute("class", (Object)"mobi-hidden", null);
        writer.startElement("script", uiComponent);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        StringBuilder sb = new StringBuilder("ice.mobi.splitpane.initClient('").append(clientId).append("'");
        sb.append(",{ scrollable: '").append(pane.isScrollable()).append("'");
        int width = pane.getColumnDivider();
        sb.append(",width: '").append(width).append("'");
        sb.append("});");
        writer.write(sb.toString());
        writer.endElement("script");
        writer.endElement("span");
    }
}

