/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.tabset;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.MethodExpression;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.ValueChangeEvent;
import org.icefaces.mobi.api.ContentPaneController;
import org.icefaces.mobi.component.pagepanel.PagePanel;
import org.icefaces.mobi.component.tabset.TabSetBase;
import org.icefaces.mobi.renderkit.InlineScriptEventListener;
import org.icefaces.mobi.utils.JSFUtils;
import org.icefaces.mobi.utils.MobiJSFUtils;
import org.icemobile.component.ITabSet;
import org.icemobile.util.ClientDescriptor;

public class TabSet
extends TabSetBase
implements ContentPaneController,
ITabSet {
    private static Logger logger = Logger.getLogger(TabSet.class.getName());
    private boolean isTop = false;
    private int index = 0;

    IdIndex resolveCurrentIdAndIndex() {
        UIComponent comp;
        String defaultId;
        String currentId = this.getSelectedId();
        int tabIndex = 0;
        if ((currentId == null || currentId.length() == 0) && (defaultId = this.getDefaultId()) != null && defaultId.length() > 0) {
            currentId = defaultId;
        }
        if ((comp = JSFUtils.getChildById((UIComponent)this, currentId)) != null) {
            tabIndex = this.getChildren().indexOf(comp);
        } else {
            comp = (UIComponent)this.getChildren().get(tabIndex);
            currentId = comp.getId();
        }
        this.index = tabIndex;
        return new IdIndex(currentId, tabIndex);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof ValueChangeEvent) {
            ValueChangeEvent vce = (ValueChangeEvent)event;
            MethodExpression method = this.getTabChangeListener();
            if (method != null) {
                method.invoke(this.getFacesContext().getELContext(), new Object[]{event});
            }
        } else {
            super.broadcast(event);
        }
    }

    public void queueEvent(FacesEvent event) {
        if (event.getComponent() == this) {
            boolean isImmediate = this.isImmediate();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("invoked event for immediate " + isImmediate);
            }
            if (isImmediate) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(event);
    }

    public boolean setIsTop(String orientation2) {
        if (orientation2 != null && orientation2.length() > 0) {
            this.isTop = !orientation2.equals(OrientationType.bottom.name());
        }
        return this.isTop;
    }

    public boolean getIsTop() {
        return this.isTop;
    }

    public void setParentHeaderFooter() {
        UIComponent parent = this.getParent();
        do {
            if (!(parent instanceof PagePanel)) continue;
            this.setHeaderFooter(parent);
            return;
        } while ((parent = parent.getParent()) != null);
    }

    private void setHeaderFooter(UIComponent parent) {
        if (parent.getFacetCount() > 0) {
            if (null != parent.getFacet("header")) {
                this.setParentHeader(true);
            } else {
                this.setParentHeader(false);
            }
            if (null != parent.getFacet("footer")) {
                this.setParentFooter(true);
            } else {
                this.setParentFooter(false);
            }
        }
    }

    public ClientDescriptor getClient() {
        return MobiJSFUtils.getClientDescriptor();
    }

    public int getIndex() {
        return this.index;
    }

    public String getJavascriptFileRequestPath() {
        String jsFname = "tabset.js";
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (FacesContext.getCurrentInstance().isProjectStage(ProjectStage.Production)) {
            jsFname = "tabset-min.js";
        }
        Resource jsFile = facesContext.getApplication().getResourceHandler().createResource(jsFname, "org.icefaces.component.tabset");
        return jsFile.getRequestPath();
    }

    public boolean isScriptLoaded() {
        return InlineScriptEventListener.isScriptLoaded(FacesContext.getCurrentInstance(), "tabset.js");
    }

    public void setScriptLoaded() {
        InlineScriptEventListener.setScriptLoaded(FacesContext.getCurrentInstance(), "tabset.js");
    }

    public static class IdIndex {
        private String id;
        private int index;

        public IdIndex(String id, int index) {
            this.id = id;
            this.index = index;
        }

        public String getId() {
            return this.id;
        }

        public int getIndex() {
            return this.index;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OrientationType {
        top,
        bottom;

        public static final OrientationType DEFAULT;

        public boolean equals(String deviceName) {
            return this.name().equals(deviceName);
        }

        static {
            DEFAULT = bottom;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum orientation {
        top,
        bottom;

    }
}

