/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.component.video;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;
import org.icefaces.mobi.component.video.VideoCapture;
import org.icefaces.mobi.renderkit.BaseInputResourceRenderer;
import org.icefaces.mobi.renderkit.ResponseWriterWrapper;
import org.icefaces.mobi.utils.MobiJSFUtils;
import org.icemobile.renderkit.DeviceCoreRenderer;

public class VideoCaptureRenderer
extends BaseInputResourceRenderer {
    private static final Logger logger = Logger.getLogger(VideoCaptureRenderer.class.getName());

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        VideoCapture camcorder = (VideoCapture)uiComponent;
        String clientId = camcorder.getClientId();
        if (!camcorder.isDisabled()) {
            try {
                HashMap map = new HashMap();
                boolean isValid = this.extractVideo(facesContext, map, clientId);
                if (isValid && map != null) {
                    camcorder.setValue(map);
                    uiComponent.queueEvent((FacesEvent)new ValueChangeEvent(uiComponent, null, map));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean extractVideo(FacesContext facesContext, Map map, String clientId) throws IOException {
        return MobiJSFUtils.decodeComponentFile(facesContext, clientId, map);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        VideoCapture camcorder = (VideoCapture)uiComponent;
        String oldLabel = camcorder.getButtonLabel();
        if (MobiJSFUtils.uploadInProgress((UIComponent)camcorder)) {
            camcorder.setButtonLabel(camcorder.getCaptureMessageLabel());
        }
        DeviceCoreRenderer renderer = new DeviceCoreRenderer();
        ResponseWriterWrapper writer = new ResponseWriterWrapper(facesContext.getResponseWriter());
        renderer.encode(camcorder, writer, false);
        camcorder.setButtonLabel(oldLabel);
    }
}

