/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.renderkit;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.mobi.renderkit.InlineScriptEventListener;
import org.icefaces.mobi.renderkit.MobileBaseRenderer;

public class CoreRenderer
extends MobileBaseRenderer {
    private static Logger logger = Logger.getLogger(CoreRenderer.class.getName());

    protected String buildAjaxRequest(FacesContext context, ClientBehaviorHolder component, String inEvent) {
        Map behaviorEvents = component.getClientBehaviors();
        if (behaviorEvents.isEmpty()) {
            return null;
        }
        String clientId = ((UIComponent)component).getClientId(context);
        StringBuilder req = new StringBuilder();
        List params = Collections.emptyList();
        Iterator eventIterator = behaviorEvents.keySet().iterator();
        while (eventIterator.hasNext()) {
            String event;
            String domEvent = event = (String)eventIterator.next();
            if (null != inEvent) {
                domEvent = inEvent;
            }
            domEvent = this.getDomEvent(event);
            if (behaviorEvents.get(event) == null) {
                logger.warning(" NO behavior for event=" + event + " component=" + ((UIComponent)component).getClientId());
                return null;
            }
            for (ClientBehavior behavior : (List)behaviorEvents.get(event)) {
                ClientBehaviorContext cbc;
                String script = behavior.getScript(cbc = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)((UIComponent)component), (String)event, (String)clientId, params));
                if (script == null) continue;
                req.append(script);
            }
            if (!eventIterator.hasNext()) continue;
            req.append(",");
        }
        return req.toString();
    }

    public boolean isValueEmpty(String value) {
        return value == null || "".equals(value);
    }

    public boolean isValueBlank(String value) {
        if (value == null) {
            return true;
        }
        return value.trim().equals("");
    }

    protected StringBuilder encodeClientBehaviors(FacesContext context, ClientBehaviorHolder component, String eventDef) throws IOException {
        StringBuilder sb = new StringBuilder(255);
        Map eventBehaviors = component.getClientBehaviors();
        if (!eventBehaviors.isEmpty()) {
            String clientId = ((UIComponent)component).getClientId(context);
            List params = Collections.emptyList();
            sb.append(",behaviors:{");
            Iterator eventIterator = eventBehaviors.keySet().iterator();
            while (eventIterator.hasNext()) {
                String event = (String)eventIterator.next();
                if (null == event) {
                    event = eventDef;
                }
                String domEvent = this.getDomEvent(event);
                sb.append(domEvent + ":");
                sb.append("function() {");
                ClientBehaviorContext cbContext = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)((UIComponent)component), (String)event, (String)clientId, params);
                for (ClientBehavior behavior : (List)eventBehaviors.get(event)) {
                    String script = behavior.getScript(cbContext);
                    if (script == null) continue;
                    sb.append(script);
                }
                sb.append("}");
                if (!eventIterator.hasNext()) continue;
                sb.append(",");
            }
            sb.append("}");
        }
        return sb;
    }

    private String getDomEvent(String event) {
        String domEvent = event;
        if (event.equalsIgnoreCase("valueChange")) {
            domEvent = "change";
        } else if (event.equalsIgnoreCase("action")) {
            domEvent = "click";
        }
        return domEvent;
    }

    protected void decodeBehaviors(FacesContext context, UIComponent component) {
        if (!(component instanceof ClientBehaviorHolder)) {
            return;
        }
        Map behaviors = ((ClientBehaviorHolder)component).getClientBehaviors();
        if (behaviors.isEmpty()) {
            return;
        }
        Map params = context.getExternalContext().getRequestParameterMap();
        String eventBehavior = (String)params.get("javax.faces.behavior.event");
        if (null != eventBehavior) {
            List eventBehaviorsList = (List)behaviors.get(eventBehavior);
            if (eventBehaviorsList == null || eventBehaviorsList.isEmpty()) {
                return;
            }
            String source = (String)params.get("javax.faces.source");
            String clientId = component.getClientId();
            if (source != null && source.startsWith(clientId)) {
                for (ClientBehavior behavior : eventBehaviorsList) {
                    behavior.decode(context, component);
                }
            }
        }
    }

    protected void writeJavascriptFile(FacesContext facesContext, UIComponent component, String JS_NAME, String JS_MIN_NAME, String JS_LIBRARY, String JS2_NAME, String JS2_MIN_NAME, String JS2_LIB) throws IOException {
        String src;
        Resource jsFile;
        String jsFname;
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = component.getClientId(facesContext);
        writer.startElement("span", component);
        writer.writeAttribute("class", (Object)"mobi-hidden", null);
        writer.writeAttribute("id", (Object)(clientId + "_libJS"), "id");
        if (!this.isScriptLoaded(facesContext, JS_NAME)) {
            jsFname = JS_NAME;
            if (facesContext.isProjectStage(ProjectStage.Production)) {
                jsFname = JS_MIN_NAME;
            }
            jsFile = facesContext.getApplication().getResourceHandler().createResource(jsFname, JS_LIBRARY);
            src = jsFile.getRequestPath();
            writer.startElement("script", component);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.writeAttribute("src", (Object)src, null);
            writer.endElement("script");
            this.setScriptLoaded(facesContext, JS_NAME);
        }
        if (!this.isScriptLoaded(facesContext, JS2_NAME)) {
            jsFname = JS2_NAME;
            if (facesContext.isProjectStage(ProjectStage.Production)) {
                jsFname = JS2_MIN_NAME;
            }
            jsFile = facesContext.getApplication().getResourceHandler().createResource(jsFname, JS2_LIB);
            src = jsFile.getRequestPath();
            writer.startElement("script", component);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.writeAttribute("src", (Object)src, null);
            writer.endElement("script");
            this.setScriptLoaded(facesContext, JS2_NAME);
        }
        writer.endElement("span");
    }

    protected void writeJavascriptFile(FacesContext facesContext, UIComponent component, String JS_NAME, String JS_MIN_NAME, String JS_LIBRARY) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = component.getClientId(facesContext);
        writer.startElement("span", component);
        writer.writeAttribute("id", (Object)(clientId + "_libJS"), "id");
        writer.writeAttribute("class", (Object)"mobi-hidden", null);
        if (!this.isScriptLoaded(facesContext, JS_NAME)) {
            String jsFname = JS_NAME;
            if (facesContext.isProjectStage(ProjectStage.Production)) {
                jsFname = JS_MIN_NAME;
            }
            Resource jsFile = facesContext.getApplication().getResourceHandler().createResource(jsFname, JS_LIBRARY);
            String src = jsFile.getRequestPath();
            writer.startElement("script", component);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.writeAttribute("src", (Object)src, null);
            writer.endElement("script");
            this.setScriptLoaded(facesContext, JS_NAME);
        }
        writer.endElement("span");
    }

    protected void setScriptLoaded(FacesContext facesContext, String JS_NAME) {
        InlineScriptEventListener.setScriptLoaded(facesContext, JS_NAME);
    }

    protected boolean isScriptLoaded(FacesContext facesContext, String JS_NAME) {
        return InlineScriptEventListener.isScriptLoaded(facesContext, JS_NAME);
    }
}

