/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.mobi.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletRequest;
import org.icemobile.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSFUtils {
    private static Logger logger = Logger.getLogger(JSFUtils.class.getName());

    public static UIComponent findChildComponent(UIComponent parent, String id) {
        if (id.equals(parent.getId())) {
            return parent;
        }
        UIComponent child = null;
        UIComponent retComp = null;
        Iterator children = parent.getFacetsAndChildren();
        while (children.hasNext() && retComp == null) {
            child = (UIComponent)children.next();
            if (id.equals(child.getId())) {
                retComp = child;
                break;
            }
            retComp = JSFUtils.findChildComponent(child, id);
            if (retComp == null) continue;
            break;
        }
        return retComp;
    }

    public static UIComponent getChildById(UIComponent parent, String id) {
        if (parent.getChildCount() > 0) {
            for (UIComponent child : parent.getChildren()) {
                if (!child.getId().equals(id)) continue;
                return child;
            }
        }
        return null;
    }

    public static String getIdOfChildByClientId(FacesContext context, UIComponent parent, String clientId) {
        if (parent.getChildCount() > 0) {
            for (UIComponent child : parent.getChildren()) {
                if (!child.getClientId(context).equals(clientId)) continue;
                return child.getId();
            }
        }
        return null;
    }

    public static void writeConcatenatedStyleClasses(ResponseWriter writer, String[] componentClasses, String applicationClass, boolean disabled) throws IOException {
        String disabledStr = "-disabled";
        int componentCount = componentClasses == null ? 0 : componentClasses.length;
        StringTokenizer st = new StringTokenizer(applicationClass, " ");
        int applicationCount = st.countTokens();
        if (componentCount == 1 && applicationCount == 0) {
            if (disabled) {
                String styleClass = (componentClasses[0].trim() + "-disabled").intern();
                writer.writeAttribute("class", (Object)styleClass, "styleClass");
            } else {
                writer.writeAttribute("class", (Object)componentClasses[0], "styleClass");
            }
        } else if (componentCount == 0 && applicationCount == 1 && !disabled) {
            writer.writeAttribute("class", (Object)applicationClass, "styleClass");
        } else if (componentCount > 0 || applicationCount > 0) {
            StringBuilder sb = new StringBuilder((componentCount + applicationCount) * 16);
            for (int i = 0; i < componentCount; ++i) {
                Utils.concatenateStyleClass(sb, componentClasses[i], disabled, "-disabled");
            }
            while (st.hasMoreTokens()) {
                Utils.concatenateStyleClass(sb, st.nextToken(), disabled, "-disabled");
            }
            sb.trimToSize();
            writer.writeAttribute("class", (Object)sb.toString(), "styleClass");
        }
    }

    public static void writeConcatenatedStyleClasses(ResponseWriter writer, String componentClass, String applicationClass) throws IOException {
        int applicationLen;
        int n;
        int componentLen;
        int n2;
        if (componentClass == null) {
            n2 = 0;
        } else {
            componentClass = componentClass.trim();
            n2 = componentLen = componentClass.length();
        }
        if (applicationClass == null) {
            n = 0;
        } else {
            applicationClass = applicationClass.trim();
            n = applicationLen = applicationClass.length();
        }
        if (componentLen > 0 && applicationLen == 0) {
            writer.writeAttribute("class", (Object)componentClass, "styleClass");
        } else if (componentLen == 0 && applicationLen > 0) {
            writer.writeAttribute("class", (Object)applicationClass, "styleClass");
        } else if (componentLen > 0 || applicationLen > 0) {
            int totalLen = componentLen + applicationLen;
            if (componentLen > 0 && applicationLen > 0) {
                ++totalLen;
            }
            StringBuilder sb = new StringBuilder(totalLen);
            if (componentLen > 0) {
                sb.append(componentClass);
            }
            if (applicationLen > 0) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(applicationClass);
            }
            writer.writeAttribute("class", (Object)sb.toString(), "styleClass");
        }
    }

    public static void writeConcatenatedStyleClasses(ResponseWriter writer, String componentClass, String applicationClass, boolean disabled) throws IOException {
        int applicationLen;
        int n;
        int componentLen;
        int n2;
        String disabledStr = "-disabled";
        if (componentClass == null) {
            n2 = 0;
        } else {
            componentClass = componentClass.trim();
            n2 = componentLen = componentClass.length();
        }
        if (applicationClass == null) {
            n = 0;
        } else {
            applicationClass = applicationClass.trim();
            n = applicationLen = applicationClass.length();
        }
        if (componentLen > 0 && applicationLen == 0) {
            if (disabled) {
                String styleClass = (componentClass + "-disabled").intern();
                writer.writeAttribute("class", (Object)styleClass, "styleClass");
            } else {
                writer.writeAttribute("class", (Object)componentClass, "styleClass");
            }
        } else if (componentLen == 0 && applicationLen > 0 && !disabled) {
            writer.writeAttribute("class", (Object)applicationClass, "styleClass");
        } else if (componentLen > 0 || applicationLen > 0) {
            int totalLen = componentLen + applicationLen;
            if (disabled && componentLen > 0) {
                totalLen += "-disabled".length();
            }
            if (disabled && applicationLen > 0) {
                totalLen += "-disabled".length();
            }
            if (componentLen > 0 && applicationLen > 0) {
                ++totalLen;
            }
            StringBuilder sb = new StringBuilder(totalLen);
            if (componentLen > 0) {
                sb.append(componentClass);
                if (disabled) {
                    sb.append("-disabled");
                }
            }
            if (applicationLen > 0) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(applicationClass);
                if (disabled) {
                    sb.append("-disabled");
                }
            }
            writer.writeAttribute("class", (Object)sb.toString(), "styleClass");
        }
    }

    public static HttpServletRequest getRequest() {
        return (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
    }

    public static void renderChildren(FacesContext facesContext, UIComponent component) throws IOException {
        if (component.getChildCount() > 0) {
            for (UIComponent child : component.getChildren()) {
                JSFUtils.renderChild(facesContext, child);
            }
        }
    }

    public static void renderChild(FacesContext facesContext, UIComponent child) throws IOException {
        if (!child.isRendered()) {
            return;
        }
        child.encodeBegin(facesContext);
        if (child.getRendersChildren()) {
            child.encodeChildren(facesContext);
        } else {
            JSFUtils.renderChildren(facesContext, child);
        }
        child.encodeEnd(facesContext);
    }

    public static void renderLayoutChild(FacesContext facesContext, UIComponent child) throws IOException {
        if (!child.isRendered()) {
            return;
        }
        child.encodeAll(facesContext);
    }

    public static UIComponent findNamingContainer(UIComponent uiComponent) {
        UIComponent parent;
        for (parent = uiComponent.getParent(); parent != null && !(parent instanceof NamingContainer); parent = parent.getParent()) {
        }
        return parent;
    }

    public static UIComponent findParentForm(UIComponent component) {
        UIComponent parent;
        for (parent = component; parent != null && !(parent instanceof UIForm); parent = parent.getParent()) {
        }
        return parent;
    }

    public static String findClientIds(FacesContext context, UIComponent component, String list) {
        if (list == null) {
            return "@none";
        }
        String[] ids = list.split("[,\\s]+");
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < ids.length; ++i) {
            String id;
            if (i != 0) {
                buffer.append(" ");
            }
            if ((id = ids[i].trim()).equals("@all") || id.equals("@none")) {
                buffer.append(id);
                continue;
            }
            if (id.equals("@this")) {
                buffer.append(component.getClientId(context));
                continue;
            }
            if (id.equals("@parent")) {
                buffer.append(component.getParent().getClientId(context));
                continue;
            }
            if (id.equals("@form")) {
                UIComponent form = JSFUtils.findParentForm(component);
                if (form == null) {
                    throw new FacesException("Component " + component.getClientId(context) + " needs to be enclosed in a form");
                }
                buffer.append(form.getClientId(context));
                continue;
            }
            UIComponent comp = component.findComponent(id);
            if (comp != null) {
                buffer.append(comp.getClientId(context));
                continue;
            }
            if (context.getApplication().getProjectStage().equals((Object)ProjectStage.Development)) {
                logger.log(Level.INFO, "Cannot find component with identifier \"{0}\" in view.", id);
            }
            buffer.append(id);
        }
        return buffer.toString();
    }

    public static List<UIParameter> captureParameters(UIComponent component) {
        List children = component.getChildren();
        ArrayList<UIParameter> returnVal = null;
        for (UIComponent child : children) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)child;
            if (returnVal == null) {
                returnVal = new ArrayList<UIParameter>();
            }
            returnVal.add(param);
        }
        return returnVal;
    }
}

