/*
 * Decompiled with CFR 0.152.
 */
package org.icemobile.renderkit;

import java.io.IOException;
import java.util.logging.Logger;
import org.icemobile.component.IAudio;
import org.icemobile.renderkit.BaseCoreRenderer;
import org.icemobile.renderkit.IResponseWriter;
import org.icemobile.util.ClientDescriptor;

public class AudioCoreRenderer
extends BaseCoreRenderer {
    public static final String AUDIO_CLASS = "mobi-audio";
    private static final Logger logger = Logger.getLogger(AudioCoreRenderer.class.toString());

    public void encodeEnd(IAudio audio, IResponseWriter writer) throws IOException {
        String mimeType;
        String clientId = audio.getClientId();
        ClientDescriptor client = audio.getClient();
        writer.startElement("span", audio);
        writer.writeAttribute("id", clientId);
        this.writeStandardLayoutAttributes(writer, audio, AUDIO_CLASS);
        writer.startElement("audio", audio);
        if (audio.isLoop()) {
            writer.writeAttribute("loop", "loop");
        }
        if (audio.isAutoPlay()) {
            writer.writeAttribute("autoplay", "autoplay");
        }
        String preloadVal = "none";
        if (audio.getPreload() != null) {
            String preload = audio.getPreload();
            if (preload.toLowerCase().trim().equals("auto")) {
                preloadVal = "auto";
            }
            if (preload.toLowerCase().trim().equals("metadata")) {
                preloadVal = "metadata";
            }
        }
        writer.writeAttribute("preload", preloadVal);
        if (audio.isControls()) {
            writer.writeAttribute("controls", "controls");
        }
        if (audio.isMuted()) {
            writer.writeAttribute("muted", "muted");
        }
        if (null == (mimeType = audio.getType())) {
            mimeType = "audio/mpeg";
        }
        writer.writeAttribute("type", mimeType);
        String srcAttribute = audio.getSrcAttribute();
        if (null == srcAttribute) {
            srcAttribute = audio.getUrl();
        }
        if (audio.isMuted()) {
            writer.writeAttribute("muted", "muted");
        }
        writer.writeAttribute("src", srcAttribute);
        writer.endElement("audio");
        if (!client.isIOS() && audio.getLinkLabel() != null) {
            writer.startElement("br", audio);
            writer.endElement("br");
            writer.startElement("a", audio);
            writer.writeAttribute("target", "_blank");
            writer.writeAttribute("href", srcAttribute);
            writer.writeText(audio.getLinkLabel());
            writer.endElement("a");
        }
        writer.endElement("span");
    }
}

