/*
 * Decompiled with CFR 0.152.
 */
package org.icemobile.renderkit;

import java.io.IOException;
import java.util.logging.Logger;
import org.icemobile.component.IButtonGroup;
import org.icemobile.renderkit.BaseCoreRenderer;
import org.icemobile.renderkit.IResponseWriter;

public class ButtonGroupCoreRenderer
extends BaseCoreRenderer {
    private static final Logger logger = Logger.getLogger(ButtonGroupCoreRenderer.class.toString());

    public void encodeBegin(IButtonGroup component, IResponseWriter writer) throws IOException {
        IButtonGroup buttonGroup = component;
        writer.startElement("div", component);
        writer.writeAttribute("id", buttonGroup.getClientId());
        writer.writeAttribute("name", buttonGroup.getClientId());
        String orientation2 = buttonGroup.getOrientation();
        StringBuilder styleClasses = new StringBuilder("mobi-button-group");
        if ("vertical".equals(orientation2)) {
            styleClasses.append(" mobi-button-group-vert");
        } else {
            styleClasses.append(" mobi-button-group-hor");
        }
        String userDefinedClass = buttonGroup.getStyleClass();
        if (userDefinedClass != null && userDefinedClass.length() > 0) {
            styleClasses.append(" ").append(userDefinedClass);
        }
        writer.writeAttribute("class", styleClasses);
        writer.writeAttribute("style", buttonGroup.getStyle());
        writer.startElement("div");
    }

    public void encodeEnd(IButtonGroup component, IResponseWriter writer) throws IOException {
        writer.endElement("div");
        if (component.getName() != null) {
            this.encodeHiddenSelected(writer, component.getClientId(), component.getSelectedId(), component.getName());
        }
        writer.endElement("div");
    }
}

