/*
 * Decompiled with CFR 0.152.
 */
package org.icemobile.renderkit;

import java.io.IOException;
import java.util.logging.Logger;
import org.icemobile.component.IPanelConfirmation;
import org.icemobile.renderkit.BaseCoreRenderer;
import org.icemobile.renderkit.IResponseWriter;

public class PanelConfirmationCoreRenderer
extends BaseCoreRenderer {
    private static final Logger logger = Logger.getLogger(PanelConfirmationCoreRenderer.class.toString());

    public void encodeEnd(IPanelConfirmation panel, IResponseWriter writer) throws IOException {
        this.encodePanel(panel, writer);
    }

    private void encodePanel(IPanelConfirmation panel, IResponseWriter writer) throws IOException {
        String clientId = panel.getClientId();
        writer.startElement("div", panel);
        writer.writeAttribute("id", clientId + "_bg");
        writer.writeAttribute("class", "mobi-panelconf-bg-hide");
        writer.endElement("div");
        writer.startElement("div", panel);
        writer.writeAttribute("id", clientId + "_popup");
        StringBuilder containerClass = new StringBuilder("mobi-panelconf-container-hide");
        if (null != panel.getStyleClass()) {
            containerClass.append(" ").append(panel.getStyleClass());
        }
        writer.writeAttribute("class", containerClass.toString());
        writer.writeAttribute("style", panel.getStyle());
        writer.startElement("div", panel);
        writer.writeAttribute("id", clientId + "_title");
        writer.writeAttribute("class", "mobi-panelconf-title-container ui-bar-b");
        writer.write(panel.getTitle());
        writer.endElement("div");
        writer.startElement("div", panel);
        writer.writeAttribute("class", "mobi-panelconf-body-container");
        writer.writeAttribute("id", clientId + "_msg");
        writer.write(panel.getMessage());
        writer.endElement("div");
        writer.startElement("div", panel);
        writer.writeAttribute("class", "mobi-panelconf-submit-container");
        String type = panel.getType();
        if (type != null) {
            if (type.equalsIgnoreCase("acceptOnly")) {
                this.renderAcceptButton(writer, panel, panel.getAcceptLabel(), clientId);
            } else if (type.equalsIgnoreCase("cancelOnly")) {
                this.renderCancelButton(writer, panel, panel.getCancelLabel(), clientId);
            } else {
                this.renderAcceptButton(writer, panel, panel.getAcceptLabel(), clientId);
                this.renderCancelButton(writer, panel, panel.getCancelLabel(), clientId);
            }
        } else {
            this.renderAcceptButton(writer, panel, panel.getAcceptLabel(), clientId);
            this.renderCancelButton(writer, panel, panel.getCancelLabel(), clientId);
        }
        writer.endElement("div");
        writer.startElement("script", panel);
        writer.writeAttribute("id", clientId + "_script");
        writer.endElement("script");
        writer.endElement("div");
    }

    private void renderAcceptButton(IResponseWriter writer, IPanelConfirmation panel, String value, String id) throws IOException {
        writer.startElement("input", panel);
        writer.writeAttribute("class", "mobi-button mobi-button-attention ");
        writer.writeAttribute("id", id + "_accept");
        writer.writeAttribute("type", "button");
        writer.writeAttribute("value", value);
        StringBuilder sb = new StringBuilder("ice.mobi.panelConf.confirm('");
        sb.append(id).append("');");
        writer.writeAttribute("onclick", sb.toString());
        writer.endElement("input");
    }

    private void renderCancelButton(IResponseWriter writer, IPanelConfirmation panel, String value, String id) throws IOException {
        writer.startElement("input", panel);
        writer.writeAttribute("class", "mobi-button mobi-button-important ");
        writer.writeAttribute("id", id + "_cancel");
        writer.writeAttribute("type", "button");
        writer.writeAttribute("value", value);
        writer.writeAttribute("onclick", "ice.mobi.panelConf.close('" + id + "');");
        writer.endElement("input");
    }
}

