/*
 * Decompiled with CFR 0.152.
 */
package org.icemobile.renderkit;

import java.io.IOException;
import java.util.logging.Logger;
import org.icemobile.component.IPanelPopup;
import org.icemobile.renderkit.BaseCoreRenderer;
import org.icemobile.renderkit.IResponseWriter;
import org.icemobile.util.Utils;

public class PanelPopupCoreRenderer
extends BaseCoreRenderer {
    private static final Logger logger = Logger.getLogger(PanelPopupCoreRenderer.class.toString());

    public void encodeBegin(IPanelPopup component, IResponseWriter writer) throws IOException {
        String userClass;
        IPanelPopup panelPopup = component;
        boolean visible = panelPopup.isVisible();
        boolean disabled = panelPopup.isDisabled();
        String clientId = panelPopup.getClientId();
        writer.startElement("div", component);
        writer.writeAttribute("id", clientId);
        StringBuilder popupBaseClass = new StringBuilder("mobi-panelpopup-container-hide ");
        StringBuilder popupBGClass = new StringBuilder("mobi-panelpopup-bg-hide ");
        if (visible) {
            popupBaseClass = new StringBuilder("mobi-panelpopup-container ");
            popupBGClass = new StringBuilder("mobi-panelpopup-bg ");
        }
        if (null != (userClass = panelPopup.getStyleClass())) {
            popupBaseClass.append(userClass);
        }
        writer.startElement("div", component);
        writer.writeAttribute("id", clientId + "_wrp");
        writer.startElement("div", component);
        writer.writeAttribute("id", clientId + "_bg");
        writer.writeAttribute("class", popupBGClass.toString());
        writer.endElement("div");
        writer.startElement("div", component);
        writer.writeAttribute("id", clientId + "_popup");
        writer.writeAttribute("class", popupBaseClass.toString());
        if (null != panelPopup.getStyle()) {
            writer.writeAttribute("style", panelPopup.getStyle());
        }
    }

    public void encodeEnd(IPanelPopup panelPopup, IResponseWriter writer) throws IOException {
        boolean clientSide = panelPopup.isClientSide();
        String clientId = panelPopup.getClientId();
        if (clientSide) {
            writer.startElement("input", panelPopup);
            writer.writeAttribute("type", "hidden");
            writer.writeAttribute("id", clientId + "_hidden");
            writer.writeAttribute("name", clientId + "_hidden");
            writer.endElement("input");
        }
        writer.endElement("div");
        writer.endElement("div");
        this.encodeScript(panelPopup, writer);
        writer.endElement("div");
    }

    public void encodeScript(IPanelPopup panelPopup, IResponseWriter writer) throws IOException {
        String clientId = panelPopup.getClientId();
        writer.startElement("div", panelPopup);
        writer.writeAttribute("id", clientId + "_scrDiv");
        writer.writeAttribute("class", "mobi-hidden");
        writer.startElement("span", panelPopup);
        writer.writeAttribute("id", clientId + "_scrSpan");
        writer.startElement("script", null);
        writer.writeAttribute("type", "text/javascript");
        StringBuilder builder = new StringBuilder(255);
        String hashString = String.valueOf(panelPopup.isClientSide()) + String.valueOf(panelPopup.isVisible()) + String.valueOf(panelPopup.isAutoCenter());
        int hashcode = Utils.generateHashCode(hashString);
        boolean disabled = panelPopup.isDisabled();
        if (disabled && !panelPopup.isClientSide()) {
            panelPopup.setVisible(false);
        }
        builder.append("ice.mobi.panelPopup.init('").append(clientId).append("', {visible: ").append(panelPopup.isVisible()).append(", hash: ").append(hashcode).append(", autocenter: ").append(panelPopup.isAutoCenter()).append(", client: ").append(panelPopup.isClientSide()).append(", id: '").append(panelPopup.getId()).append("'");
        if (panelPopup.getWidth() != Integer.MIN_VALUE) {
            builder.append(", width: ").append(panelPopup.getWidth());
        }
        if (panelPopup.getHeight() != Integer.MIN_VALUE) {
            builder.append(", height: ").append(panelPopup.getHeight());
        }
        if (null != panelPopup.getStyleClass()) {
            builder.append(", sclass: '").append(panelPopup.getStyleClass()).append("'");
        }
        if (panelPopup.getStyle() != null) {
            builder.append(", style: '").append(panelPopup.getStyle()).append("'");
        }
        if (disabled) {
            builder.append(", disabled: ").append(panelPopup.isDisabled());
        }
        builder.append("});");
        writer.write(builder.toString());
        writer.endElement("script");
        writer.endElement("span");
        writer.endElement("div");
    }
}

