/*
 * Decompiled with CFR 0.152.
 */
package org.icemobile.renderkit;

import java.io.IOException;
import java.util.logging.Logger;
import org.icemobile.component.IMobiComponent;
import org.icemobile.component.ITabSet;
import org.icemobile.renderkit.BaseCoreRenderer;
import org.icemobile.renderkit.IResponseWriter;

public class TabSetCoreRenderer
extends BaseCoreRenderer {
    private static final Logger logger = Logger.getLogger(TabSetCoreRenderer.class.toString());

    public void encodeBegin(IMobiComponent component, IResponseWriter writer, boolean isJSP, boolean isTop) throws IOException {
        String userDefinedClass;
        ITabSet tabset = (ITabSet)component;
        String clientId = tabset.getClientId();
        if (!isJSP) {
            super.writeExternalScript(component, writer, tabset.getJavascriptFileRequestPath(), !tabset.isScriptLoaded());
            tabset.setScriptLoaded();
        }
        writer.startElement("div", tabset);
        writer.writeAttribute("id", clientId);
        StringBuilder styleClass = new StringBuilder(ITabSet.TABSET_CONTAINER_CLASS);
        String orientation2 = tabset.getOrientation();
        if (isTop) {
            styleClass.append(" ").append((CharSequence)ITabSet.TABSET_CONTAINER_TOP_CLASS);
        } else {
            styleClass.append(" ").append((CharSequence)ITabSet.TABSET_CONTAINER_BOTTOM_CLASS);
        }
        boolean parentFooter = tabset.isParentFooter();
        if (!isTop && parentFooter) {
            styleClass.append(" ").append((CharSequence)ITabSet.TABSET_CONTAINER_BOTTOM_FOOTER_CLASS);
        }
        boolean parentHeader = tabset.isParentHeader();
        if (isTop && parentHeader) {
            styleClass.append(" ").append((CharSequence)ITabSet.TABSET_CONTAINER_TOP_HEADER_CLASS);
        }
        if ((userDefinedClass = tabset.getStyleClass()) != null && userDefinedClass.length() > 0) {
            styleClass.append(" ").append(userDefinedClass);
        }
        writer.writeAttribute("class", styleClass.toString());
        writer.writeAttribute("style", tabset.getStyle());
    }

    public void writeStartOfTabContents(IMobiComponent tabset, IResponseWriter writer, String clientId) throws IOException {
        writer.startElement("div", tabset);
        ITabSet its = (ITabSet)tabset;
        writer.writeAttribute("id", clientId + "_tabContent");
        writer.writeAttribute("class", ITabSet.TABSET_CONTENT_CLASS.toString());
        if (null != its.getHeight()) {
            writer.writeAttribute("style", "height:" + its.getHeight() + ";");
        }
    }

    public void writeEndOfTabContents(IMobiComponent tabset, IResponseWriter writer) throws IOException {
        writer.endElement("div");
        writer.endElement("div");
    }

    public void encodeEndContents(IMobiComponent component, IResponseWriter writer) throws IOException {
        writer.endElement("div");
    }

    public void encodeEnd(IMobiComponent component, IResponseWriter writer, boolean isJSP) throws IOException {
        ITabSet tabset = (ITabSet)component;
        this.writeHiddenInput(writer, component, String.valueOf(tabset.getIndex()));
        this.encodeScript(component, writer, isJSP);
        writer.endElement("div");
    }

    public void encodeTabSetHeaders(IMobiComponent component, IResponseWriter writer) throws IOException {
        ITabSet tabset = (ITabSet)component;
        writer.startElement("div", component);
        writer.writeAttribute("id", tabset.getClientId() + "_tabs");
        String baseTabsClass = ITabSet.TABSET_TABS_CLASS.toString();
        if (!tabset.isFixedPosition() || !component.getClient().isSupportsFixedPosition()) {
            baseTabsClass = baseTabsClass + " mobi-tabset-tabs-nonfixed";
        }
        writer.writeAttribute("class", baseTabsClass);
        writer.startElement("ul", component);
        writer.writeAttribute("id", tabset.getClientId() + "_dc");
    }

    public void encodeEndTabSetHeaders(IMobiComponent component, IResponseWriter writer) throws IOException {
        writer.endElement("ul");
        writer.endElement("div");
    }

    public void encodeScript(IMobiComponent component, IResponseWriter writer, boolean isJSP) throws IOException {
        ITabSet tabset = (ITabSet)component;
        int idIndex = tabset.getIndex();
        String clientId = tabset.getClientId();
        String height = tabset.getHeight();
        writer.startElement("span");
        writer.writeAttribute("class", "mobi-hidden");
        writer.writeAttribute("id", clientId + "_script");
        writer.startElement("script");
        writer.writeAttribute("type", "text/javascript");
        StringBuilder cfg = new StringBuilder("ice.mobi.tabsetController.initClient('");
        cfg.append(clientId).append("',").append("{singleSubmit: ");
        boolean singleSubmit = tabset.isSingleSubmit();
        cfg.append(singleSubmit);
        cfg.append(", tIndex: ").append(idIndex);
        if (!isJSP) {
            cfg.append(", hash: ").append(tabset.getHashVal());
        }
        cfg.append(", disabled: ").append(tabset.isDisabled());
        if (!this.isStringAttributeEmpty(height)) {
            cfg.append(",height: '").append(height).append("'");
        } else {
            cfg.append(", autoheight: ").append(tabset.isAutoHeight());
        }
        if (tabset.isAutoWidth()) {
            cfg.append(", autoWidth: ").append(tabset.isAutoWidth());
        }
        cfg.append("}").append(");");
        writer.writeText(cfg.toString());
        writer.endElement("script");
        writer.endElement("span");
    }
}

