/*
 * Decompiled with CFR 0.152.
 */
package org.icemobile.renderkit;

import java.io.IOException;
import java.util.logging.Logger;
import org.icemobile.component.IVideoPlayer;
import org.icemobile.renderkit.BaseCoreRenderer;
import org.icemobile.renderkit.IResponseWriter;
import org.icemobile.util.ClientDescriptor;

public class VideoPlayerCoreRenderer
extends BaseCoreRenderer {
    public static final String VIDEO_CLASS = "mobi-video";
    private static final Logger logger = Logger.getLogger(VideoPlayerCoreRenderer.class.toString());

    public void encodeEnd(IVideoPlayer video, IResponseWriter writer) throws IOException {
        String srcAttribute;
        String clientId = video.getClientId();
        ClientDescriptor client = video.getClient();
        writer.startElement("span", video);
        writer.writeAttribute("id", clientId);
        this.writeStandardLayoutAttributes(writer, video, VIDEO_CLASS);
        writer.startElement("video", video);
        if (video.isLoop()) {
            writer.writeAttribute("loop", "loop");
        }
        String preloadVal = "none";
        if (video.getPreload() != null) {
            String preload = video.getPreload();
            if (preload.toLowerCase().trim().equals("auto")) {
                preloadVal = "auto";
            }
            if (preload.toLowerCase().trim().equals("metadata")) {
                preloadVal = "metadata";
            }
        }
        if (video.isPlaysinline()) {
            writer.writeAttribute("webkit-playsinline", "yes");
        }
        writer.writeAttribute("preload", preloadVal);
        if (video.getHeight() > 0) {
            writer.writeAttribute("height", String.valueOf(video.getHeight()));
        }
        if (video.getWidth() > 0) {
            writer.writeAttribute("width", String.valueOf(video.getWidth()));
        }
        if (video.isControls()) {
            writer.writeAttribute("controls", "controls");
        }
        if (null != video.getType()) {
            writer.writeAttribute("type", video.getType());
        }
        if (video.isMuted()) {
            writer.writeAttribute("muted", "muted");
        }
        if ((srcAttribute = video.getSrcAttribute()) == null) {
            srcAttribute = video.getUrl();
        }
        if (null != video.getPoster()) {
            writer.writeAttribute("poster", video.getPoster());
        }
        writer.writeAttribute("src", srcAttribute);
        writer.endElement("video");
        if (!client.isIOS() && video.getLinkLabel() != null) {
            writer.startElement("br", video);
            writer.endElement("br");
            writer.startElement("a", video);
            writer.writeAttribute("target", "_blank");
            writer.writeAttribute("href", srcAttribute);
            writer.writeText(video.getLinkLabel());
            writer.endElement("a");
        }
        writer.endElement("span");
    }
}

