/*
 * Decompiled with CFR 0.152.
 */
package org.icemobile.util;

import java.io.IOException;
import java.util.Stack;
import org.icemobile.renderkit.IResponseWriter;

public class MockResponseWriter
implements IResponseWriter {
    private StringBuilder str = new StringBuilder();
    private Stack<String> elementStack = new Stack();
    private boolean lastElementClosed = true;

    public void writeAttribute(String name, Object value) throws IOException {
        this.str.append(" " + name + "='" + value + "'");
    }

    public void writeAttribute(String name, boolean value) throws IOException {
        this.str.append(" " + name + "='" + value + "'");
    }

    public void writeAttribute(String name, int value) throws IOException {
        this.str.append(" " + name + "='" + value + "'");
    }

    public void startElement(String name, Object component) throws IOException {
        if (!this.elementStack.isEmpty() && !this.lastElementClosed) {
            this.str.append(">");
        }
        this.str.append("<");
        this.str.append(name);
        this.lastElementClosed = false;
        this.elementStack.push(name);
    }

    public void startElement(String name) throws IOException {
        if (!this.elementStack.isEmpty() && !this.lastElementClosed) {
            this.str.append(">");
        }
        this.str.append("<");
        this.str.append(name);
        this.lastElementClosed = false;
        this.elementStack.push(name);
    }

    public void endElement(String name) throws IOException {
        String element = this.elementStack.pop();
        if (!element.equals(name)) {
            System.out.println("******************** mismatched tag: " + name + ", expected " + element);
        }
        if (!this.lastElementClosed) {
            this.str.append(">");
        }
        this.str.append("</");
        this.str.append(name);
        this.str.append(">");
        this.lastElementClosed = true;
    }

    public void writeText(String text) throws IOException {
        if (!this.lastElementClosed) {
            this.str.append(">");
        }
        this.str.append(text);
        this.lastElementClosed = true;
    }

    public void write(String input) throws IOException {
        if (!this.lastElementClosed) {
            this.str.append(">");
        }
        this.str.append(input);
        this.lastElementClosed = true;
    }

    public void closeOffTag() throws IOException {
        this.str.append(">");
        this.lastElementClosed = true;
    }

    public String toString() {
        return this.str.toString();
    }
}

