/*
 * Decompiled with CFR 0.152.
 */
package org.icemobile.zxing.common;

import java.util.Hashtable;
import org.icemobile.zxing.common.ECI;

public final class CharacterSetECI
extends ECI {
    private static Hashtable VALUE_TO_ECI;
    private static Hashtable NAME_TO_ECI;
    private final String encodingName;

    private static void initialize() {
        VALUE_TO_ECI = new Hashtable(29);
        NAME_TO_ECI = new Hashtable(29);
        CharacterSetECI.addCharacterSet(0, "Cp437");
        CharacterSetECI.addCharacterSet(1, new String[]{"ISO8859_1", "ISO-8859-1"});
        CharacterSetECI.addCharacterSet(2, "Cp437");
        CharacterSetECI.addCharacterSet(3, new String[]{"ISO8859_1", "ISO-8859-1"});
        CharacterSetECI.addCharacterSet(4, "ISO8859_2");
        CharacterSetECI.addCharacterSet(5, "ISO8859_3");
        CharacterSetECI.addCharacterSet(6, "ISO8859_4");
        CharacterSetECI.addCharacterSet(7, "ISO8859_5");
        CharacterSetECI.addCharacterSet(8, "ISO8859_6");
        CharacterSetECI.addCharacterSet(9, "ISO8859_7");
        CharacterSetECI.addCharacterSet(10, "ISO8859_8");
        CharacterSetECI.addCharacterSet(11, "ISO8859_9");
        CharacterSetECI.addCharacterSet(12, "ISO8859_10");
        CharacterSetECI.addCharacterSet(13, "ISO8859_11");
        CharacterSetECI.addCharacterSet(15, "ISO8859_13");
        CharacterSetECI.addCharacterSet(16, "ISO8859_14");
        CharacterSetECI.addCharacterSet(17, "ISO8859_15");
        CharacterSetECI.addCharacterSet(18, "ISO8859_16");
        CharacterSetECI.addCharacterSet(20, new String[]{"SJIS", "Shift_JIS"});
    }

    private CharacterSetECI(int value, String encodingName) {
        super(value);
        this.encodingName = encodingName;
    }

    public String getEncodingName() {
        return this.encodingName;
    }

    private static void addCharacterSet(int value, String encodingName) {
        CharacterSetECI eci = new CharacterSetECI(value, encodingName);
        VALUE_TO_ECI.put(new Integer(value), eci);
        NAME_TO_ECI.put(encodingName, eci);
    }

    private static void addCharacterSet(int value, String[] encodingNames) {
        CharacterSetECI eci = new CharacterSetECI(value, encodingNames[0]);
        VALUE_TO_ECI.put(new Integer(value), eci);
        for (int i = 0; i < encodingNames.length; ++i) {
            NAME_TO_ECI.put(encodingNames[i], eci);
        }
    }

    public static CharacterSetECI getCharacterSetECIByValue(int value) {
        if (VALUE_TO_ECI == null) {
            CharacterSetECI.initialize();
        }
        if (value < 0 || value >= 900) {
            throw new IllegalArgumentException("Bad ECI value: " + value);
        }
        return (CharacterSetECI)VALUE_TO_ECI.get(new Integer(value));
    }

    public static CharacterSetECI getCharacterSetECIByName(String name) {
        if (NAME_TO_ECI == null) {
            CharacterSetECI.initialize();
        }
        return (CharacterSetECI)NAME_TO_ECI.get(name);
    }
}

