/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.icepdf.core.pobjects.Catalog;
import org.icepdf.core.pobjects.CrossReference;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.PInfo;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.util.Library;

public class PTrailer
extends Dictionary {
    private CrossReference m_CrossReferenceTable;
    private CrossReference m_CrossReferenceStream;

    public PTrailer(Library library, Hashtable hashtable, CrossReference crossReference, CrossReference crossReference2) {
        super(library, hashtable);
        this.m_CrossReferenceTable = crossReference;
        this.m_CrossReferenceStream = crossReference2;
        if (this.m_CrossReferenceTable != null) {
            this.m_CrossReferenceTable.setTrailer(this);
        }
        if (this.m_CrossReferenceStream != null) {
            this.m_CrossReferenceStream.setTrailer(this);
        }
    }

    public int getNumberOfObjects() {
        return this.library.getInt(this.entries, "Size");
    }

    public long getPrev() {
        return this.library.getLong(this.entries, "Prev");
    }

    protected CrossReference getPrimaryCrossReference() {
        if (this.m_CrossReferenceTable != null) {
            return this.m_CrossReferenceTable;
        }
        this.loadXRefStmIfApplicable();
        return this.m_CrossReferenceStream;
    }

    protected CrossReference getCrossReferenceTable() {
        return this.m_CrossReferenceTable;
    }

    protected CrossReference getCrossReferenceStream() {
        return this.m_CrossReferenceStream;
    }

    public Reference getRootCatalogReference() {
        return this.library.getObjectReference(this.entries, "Root");
    }

    public Catalog getRootCatalog() {
        Object object = this.library.getObject(this.entries, "Root");
        if (object instanceof Catalog) {
            return (Catalog)this.library.getObject(this.entries, "Root");
        }
        if (object instanceof Hashtable) {
            return new Catalog(this.library, (Hashtable)object);
        }
        return null;
    }

    public Hashtable getEncrypt() {
        Object object = this.library.getObject(this.entries, "Encrypt");
        if (object instanceof Hashtable) {
            return (Hashtable)object;
        }
        return null;
    }

    public PInfo getInfo() {
        Object object = this.library.getObject(this.entries, "Info");
        if (object instanceof Hashtable) {
            return new PInfo(this.library.getSecurityManager(), (Hashtable)object);
        }
        return null;
    }

    public Vector getID() {
        return (Vector)this.library.getObject(this.entries, "ID");
    }

    protected void addNextTrailer(PTrailer pTrailer) {
        pTrailer.getPrimaryCrossReference().addToEndOfChainOfPreviousXRefs(this.getPrimaryCrossReference());
        Hashtable hashtable = pTrailer.getDictionary();
        Hashtable hashtable2 = this.getDictionary();
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (hashtable.contains(k)) continue;
            Object v = hashtable2.get(k);
            hashtable.put(k, v);
        }
    }

    protected void addPreviousTrailer(PTrailer pTrailer) {
        this.getPrimaryCrossReference().addToEndOfChainOfPreviousXRefs(pTrailer.getPrimaryCrossReference());
        Hashtable hashtable = this.getDictionary();
        Hashtable hashtable2 = pTrailer.getDictionary();
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (hashtable.contains(k)) continue;
            Object v = hashtable2.get(k);
            hashtable.put(k, v);
        }
    }

    protected void onDemandLoadAndSetupPreviousTrailer() {
        PTrailer pTrailer;
        long l = this.getPrev();
        if (l > 0L && (pTrailer = this.library.getTrailerByFilePosition(l)) != null) {
            this.addPreviousTrailer(pTrailer);
        }
    }

    protected void loadXRefStmIfApplicable() {
        PTrailer pTrailer;
        long l;
        if (this.m_CrossReferenceStream == null && (l = this.library.getLong(this.entries, "XRefStm")) > 0L && (pTrailer = this.library.getTrailerByFilePosition(l)) != null) {
            this.m_CrossReferenceStream = pTrailer.getCrossReferenceStream();
        }
    }

    public Hashtable getDictionary() {
        return this.entries;
    }

    public String toString() {
        return "PTRAILER= " + this.entries.toString() + " xref table=" + this.m_CrossReferenceTable + "  xref stream=" + this.m_CrossReferenceStream;
    }
}

