/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util;

import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Catalog;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.PRectangle;
import org.icepdf.core.pobjects.PTrailer;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.fonts.Font;
import org.icepdf.core.pobjects.fonts.FontDescriptor;
import org.icepdf.core.pobjects.graphics.ICCBased;
import org.icepdf.core.pobjects.security.SecurityManager;
import org.icepdf.core.util.CacheManager;
import org.icepdf.core.util.LazyObjectLoader;
import org.icepdf.core.util.MemoryManager;

public class Library {
    private static final Logger log = Logger.getLogger(Library.class.toString());
    private LazyObjectLoader m_LazyObjectLoader;
    private ConcurrentHashMap<Reference, Object> refs = new ConcurrentHashMap(1024);
    private ConcurrentHashMap<Reference, ICCBased> lookupReference2ICCBased = new ConcurrentHashMap(256);
    private Catalog catalog;
    public MemoryManager memoryManager = MemoryManager.getInstance();
    public CacheManager cacheManager = new CacheManager();
    public SecurityManager securityManager;
    private boolean isEncrypted = false;
    private boolean isLinearTraversal = false;

    public void setLazyObjectLoader(LazyObjectLoader lazyObjectLoader) {
        this.m_LazyObjectLoader = lazyObjectLoader;
        if (this.m_LazyObjectLoader != null) {
            this.memoryManager.registerMemoryManagerDelegate(this.m_LazyObjectLoader);
        }
    }

    public PTrailer getTrailerByFilePosition(long l) {
        if (this.m_LazyObjectLoader == null) {
            return null;
        }
        return this.m_LazyObjectLoader.loadTrailer(l);
    }

    public Object getObject(Reference reference) {
        Object object;
        while (true) {
            boolean bl;
            if ((object = this.refs.get(reference)) == null && this.m_LazyObjectLoader != null && (bl = this.m_LazyObjectLoader.loadObject(reference))) {
                object = this.refs.get(reference);
            }
            this.printObjectDebug(object);
            if (object == null || !(object instanceof Reference)) break;
            reference = (Reference)object;
        }
        return object;
    }

    private void printObjectDebug(Object object) {
        if (log.isLoggable(Level.FINER)) {
            if (object == null) {
                log.finer("null object found");
            } else if (object instanceof PObject) {
                PObject pObject = (PObject)object;
                log.finer(pObject.getReference() + " " + pObject.toString());
            } else if (object instanceof Dictionary) {
                Dictionary dictionary = (Dictionary)object;
                log.finer(dictionary.getPObjectReference() + " " + dictionary.toString());
            } else {
                log.finer(object.getClass() + " " + object.toString());
            }
        }
    }

    public Object getObject(Hashtable hashtable, String string) {
        if (hashtable == null) {
            return null;
        }
        Object object = hashtable.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Reference) {
            object = this.getObject((Reference)object);
        }
        return object;
    }

    public Object getObject(Object object) {
        if (object instanceof Reference) {
            return this.getObject((Reference)object);
        }
        return object;
    }

    public boolean isValidEntry(Hashtable hashtable, String string) {
        if (hashtable == null) {
            return false;
        }
        Object v = hashtable.get(string);
        return v != null && (!(v instanceof Reference) || this.isValidEntry((Reference)v));
    }

    public boolean isValidEntry(Reference reference) {
        Object object = this.refs.get(reference);
        return object != null || this.m_LazyObjectLoader != null && this.m_LazyObjectLoader.haveEntry(reference);
    }

    public Number getNumber(Hashtable hashtable, String string) {
        Object object = this.getObject(hashtable, string);
        if (object instanceof Number) {
            return (Number)object;
        }
        return null;
    }

    public Boolean getBoolean(Hashtable hashtable, String string) {
        Object object = this.getObject(hashtable, string);
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        return object instanceof Boolean && (Boolean)object != false;
    }

    public float getFloat(Hashtable hashtable, String string) {
        Number number = this.getNumber(hashtable, string);
        return number != null ? number.floatValue() : 0.0f;
    }

    public int getInt(Hashtable hashtable, String string) {
        Number number = this.getNumber(hashtable, string);
        return number != null ? number.intValue() : 0;
    }

    public long getLong(Hashtable hashtable, String string) {
        Number number = this.getNumber(hashtable, string);
        return number != null ? number.longValue() : 0L;
    }

    public String getName(Hashtable hashtable, String string) {
        Object object = this.getObject(hashtable, string);
        if (object != null && object instanceof Name) {
            return ((Name)object).getName();
        }
        return null;
    }

    public Hashtable getDictionary(Hashtable hashtable, String string) {
        Object object = this.getObject(hashtable, string);
        if (object instanceof Hashtable) {
            return (Hashtable)object;
        }
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            Hashtable hashtable2 = new Hashtable();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof Map)) continue;
                hashtable2.putAll((Map)e);
            }
            return hashtable2;
        }
        return null;
    }

    public Rectangle2D.Float getRectangle(Hashtable hashtable, String string) {
        Vector vector = (Vector)this.getObject(hashtable, string);
        if (vector != null) {
            return new PRectangle(vector).toJava2dCoordinates();
        }
        return null;
    }

    public ICCBased getICCBased(Reference reference) {
        Object object;
        ICCBased iCCBased = this.lookupReference2ICCBased.get(reference);
        if (iCCBased == null && (object = this.getObject(reference)) instanceof Stream) {
            Stream stream = (Stream)object;
            iCCBased = new ICCBased(this, stream);
            this.lookupReference2ICCBased.put(reference, iCCBased);
        }
        return iCCBased;
    }

    public Resources getResources(Hashtable hashtable, String string) {
        if (hashtable == null) {
            return null;
        }
        Object v = hashtable.get(string);
        if (v == null) {
            return null;
        }
        if (v instanceof Resources) {
            return (Resources)v;
        }
        if (v instanceof Reference) {
            Reference reference = (Reference)v;
            return this.getResources(reference);
        }
        if (v instanceof Hashtable) {
            Hashtable hashtable2 = (Hashtable)v;
            Resources resources = new Resources(this, hashtable2);
            hashtable.put(string, resources);
            return resources;
        }
        return null;
    }

    public Resources getResources(Reference reference) {
        Object object;
        while (true) {
            boolean bl;
            if ((object = this.refs.get(reference)) == null && this.m_LazyObjectLoader != null && (bl = this.m_LazyObjectLoader.loadObject(reference))) {
                object = this.refs.get(reference);
            }
            if (object == null) {
                return null;
            }
            if (object instanceof Resources) {
                return (Resources)object;
            }
            if (!(object instanceof Reference)) break;
            reference = (Reference)object;
        }
        if (object instanceof Hashtable) {
            Hashtable hashtable = (Hashtable)object;
            Resources resources = new Resources(this, hashtable);
            this.addObject(resources, reference);
            return resources;
        }
        return null;
    }

    public void addObject(Object object, Reference reference) {
        this.refs.put(reference, object);
    }

    public Reference getObjectReference(Hashtable hashtable, String string) {
        if (hashtable == null) {
            return null;
        }
        Object object = hashtable.get(string);
        if (object == null) {
            return null;
        }
        Reference reference = null;
        while (object != null && object instanceof Reference) {
            reference = (Reference)object;
            object = this.getObject(reference);
        }
        return reference;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setEncrypted(boolean bl) {
        this.isEncrypted = bl;
    }

    public void setLinearTraversal() {
        this.isLinearTraversal = true;
    }

    public boolean isLinearTraversal() {
        return this.isLinearTraversal;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    public void disposeFontResources() {
        Enumeration<Reference> enumeration = this.refs.keys();
        while (enumeration.hasMoreElements()) {
            Reference reference = enumeration.nextElement();
            Object object = this.refs.get(reference);
            if (!(object instanceof Font) && !(object instanceof FontDescriptor)) continue;
            this.refs.remove(reference);
        }
    }

    public void dispose() {
        if (this.memoryManager != null) {
            this.memoryManager.releaseAllByLibrary(this);
        }
        if (this.cacheManager != null) {
            this.cacheManager.dispose();
        }
        if (this.refs != null) {
            this.refs.clear();
        }
        if (this.lookupReference2ICCBased != null) {
            this.lookupReference2ICCBased.clear();
            this.lookupReference2ICCBased = null;
        }
        if (this.m_LazyObjectLoader != null) {
            this.m_LazyObjectLoader.dispose();
        }
    }
}

