/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.MemoryManageable;
import org.icepdf.core.util.MemoryManagerDelegate;

public class MemoryManager {
    private static final Logger logger = Logger.getLogger(MemoryManager.class.toString());
    private static MemoryManager instance;
    protected final Runtime runtime = Runtime.getRuntime();
    protected long minMemory = 5000000L;
    protected long maxMemory;
    protected int purgeSize;
    protected int maxSize;
    protected WeakHashMap locked;
    protected ArrayList leastRecentlyUsed;
    protected long cumulativeDurationManagingMemory;
    protected long cumulativeDurationNotManagingMemory;
    protected long previousTimestampManagedMemory;
    protected int percentageDurationManagingMemory;
    protected ArrayList delegates;

    public static void setInstance(MemoryManager memoryManager) {
        instance = memoryManager;
    }

    public static MemoryManager getInstance() {
        if (instance == null) {
            instance = new MemoryManager();
        }
        return instance;
    }

    protected MemoryManager() {
        try {
            int n = MemoryManager.parse("org.icepdf.core.minMemory");
            if (n > 0) {
                this.minMemory = n;
            }
        }
        catch (Throwable throwable) {
            logger.log(Level.FINE, "Error setting org.icepdf.core.minMemory");
        }
        this.maxMemory = Runtime.getRuntime().maxMemory();
        this.purgeSize = Defs.sysPropertyInt("org.icepdf.core.purgeSize", 5);
        this.maxSize = Defs.sysPropertyInt("org.icepdf.core.maxSize", 0);
        this.locked = new WeakHashMap();
        this.leastRecentlyUsed = new ArrayList(256);
        this.delegates = new ArrayList(64);
    }

    public synchronized void lock(Object object, MemoryManageable memoryManageable) {
        int n;
        int n2;
        if (object == null || memoryManageable == null) {
            return;
        }
        HashSet<MemoryManageable> hashSet = (HashSet<MemoryManageable>)this.locked.get(object);
        if (hashSet == null) {
            hashSet = new HashSet<MemoryManageable>(256);
            this.locked.put(object, hashSet);
        }
        hashSet.add(memoryManageable);
        this.leastRecentlyUsed.remove(memoryManageable);
        this.leastRecentlyUsed.add(memoryManageable);
        if (this.maxSize > 0 && (n2 = (n = this.leastRecentlyUsed.size()) - this.maxSize) > 0) {
            int n3 = Math.max(this.purgeSize, n2);
            int n4 = this.reduceMemory(n3);
        }
    }

    public synchronized void release(Object object, MemoryManageable memoryManageable) {
        if (object == null || memoryManageable == null) {
            return;
        }
        HashSet hashSet = (HashSet)this.locked.get(object);
        if (hashSet != null) {
            boolean bl = hashSet.remove(memoryManageable);
            if (hashSet.size() == 0) {
                this.locked.remove(object);
            }
        }
    }

    public synchronized void registerMemoryManagerDelegate(MemoryManagerDelegate memoryManagerDelegate) {
        if (!this.delegates.contains(memoryManagerDelegate)) {
            this.delegates.add(memoryManagerDelegate);
        }
    }

    public synchronized void releaseAllByLibrary(Library library) {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (library == null) {
            return;
        }
        for (int i = this.leastRecentlyUsed.size() - 1; i >= 0; --i) {
            object4 = (MemoryManageable)this.leastRecentlyUsed.get(i);
            object3 = object4.getLibrary();
            if (object3 == null || !object3.equals(library)) continue;
            this.leastRecentlyUsed.remove(i);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        object4 = this.locked.entrySet();
        object3 = object4.iterator();
        while (object3.hasNext()) {
            Map.Entry entry = (Map.Entry)object3.next();
            object2 = entry.getKey();
            HashSet hashSet = (HashSet)entry.getValue();
            if (hashSet == null) continue;
            object = new ArrayList();
            for (MemoryManageable memoryManageable : hashSet) {
                Library library2;
                if (memoryManageable == null || (library2 = memoryManageable.getLibrary()) == null || !library2.equals(library)) continue;
                ((ArrayList)object).add(memoryManageable);
            }
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                hashSet.remove(((ArrayList)object).get(i));
            }
            ((ArrayList)object).clear();
            if (hashSet.size() != 0) continue;
            arrayList.add(object2);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.locked.remove(arrayList.get(n));
        }
        arrayList.clear();
        for (n = this.delegates.size() - 1; n >= 0; --n) {
            object2 = (MemoryManagerDelegate)this.delegates.get(n);
            boolean bl = false;
            if (object2 == null) {
                bl = true;
            } else {
                object = object2.getLibrary();
                if (object == null) {
                    bl = true;
                } else if (object.equals(library)) {
                    bl = true;
                }
            }
            if (!bl) continue;
            this.delegates.remove(n);
        }
    }

    protected synchronized boolean reduceMemory() {
        int n = this.purgeSize;
        int n2 = 0;
        int n3 = this.leastRecentlyUsed.size();
        if (this.percentageDurationManagingMemory > 15 || n3 > 100) {
            n2 = n3 * 60 / 100;
        } else if (n3 > 50) {
            n2 = n3 * 50 / 100;
        } else if (n3 > 20) {
            n2 = n3 * 40 / 100;
        }
        if (n2 > n) {
            n = n2;
        }
        int n4 = this.reduceMemory(n);
        boolean bl = false;
        if (n4 == 0) {
            bl = this.reduceMemoryWithDelegates(true);
        } else if (n4 < n) {
            bl = this.reduceMemoryWithDelegates(false);
        }
        return n4 > 0 || bl;
    }

    protected synchronized int reduceMemory(int n) {
        int n2 = 0;
        try {
            int n3 = 0;
            while (n2 < n && n3 < this.leastRecentlyUsed.size()) {
                MemoryManageable memoryManageable = (MemoryManageable)this.leastRecentlyUsed.get(n3);
                if (!this.isLocked(memoryManageable)) {
                    memoryManageable.reduceMemory();
                    ++n2;
                    this.leastRecentlyUsed.remove(n3);
                    continue;
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "Problem while reducing memory", exception);
        }
        return n2;
    }

    protected synchronized boolean isLocked(MemoryManageable memoryManageable) {
        Set set = this.locked.entrySet();
        for (Map.Entry entry : set) {
            HashSet hashSet = (HashSet)entry.getValue();
            if (hashSet == null || !hashSet.contains(memoryManageable)) continue;
            return true;
        }
        return false;
    }

    protected synchronized boolean reduceMemoryWithDelegates(boolean bl) {
        int n = bl ? 1 : 0;
        boolean bl2 = false;
        for (int i = 0; i < this.delegates.size(); ++i) {
            MemoryManagerDelegate memoryManagerDelegate = (MemoryManagerDelegate)this.delegates.get(i);
            if (memoryManagerDelegate == null) continue;
            boolean bl3 = memoryManagerDelegate.reduceMemory(n);
            bl2 |= bl3;
        }
        return bl2;
    }

    private static final int parse(String string) {
        String string2 = Defs.sysProperty(string);
        if (string2 == null) {
            return -1;
        }
        int n = 1;
        char c = string2.charAt(string2.length() - 1);
        if (c == 'k' || c == 'K') {
            n = 1024;
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (c == 'm' || c == 'M') {
            n = 0x100000;
            string2 = string2.substring(0, string2.length() - 1);
        }
        return n * Integer.parseInt(string2);
    }

    public void setMinMemory(long l) {
        this.minMemory = l;
    }

    public long getMinMemory() {
        return this.minMemory;
    }

    public void setMaxMemory(long l) {
        this.maxMemory = l;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public long getFreeMemory() {
        return this.runtime.freeMemory();
    }

    private boolean canAllocate(int n, boolean bl) {
        long l = this.runtime.freeMemory();
        if (l - (long)n > this.minMemory) {
            return true;
        }
        long l2 = this.runtime.totalMemory();
        if (this.maxMemory > l2 && (l += this.maxMemory - l2) - (long)n > this.minMemory) {
            return true;
        }
        if (!bl) {
            return false;
        }
        System.gc();
        l = this.runtime.freeMemory();
        if (l - (long)n > this.minMemory) {
            return true;
        }
        System.runFinalization();
        System.gc();
        l = this.runtime.freeMemory();
        return l - (long)n > this.minMemory;
    }

    public boolean isLowMemory() {
        return !this.canAllocate(0, true);
    }

    public boolean checkMemory(int n) {
        long l = System.currentTimeMillis();
        int n2 = 0;
        while (!this.canAllocate(n, n2 > 0)) {
            boolean bl = this.reduceMemory();
            if (!bl && n2 > 0) {
                this.finishedMemoryProcessing(l);
                return false;
            }
            if (++n2 <= 10) continue;
            this.finishedMemoryProcessing(l);
            return false;
        }
        this.finishedMemoryProcessing(l);
        return true;
    }

    private void finishedMemoryProcessing(long l) {
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        if (l3 > 0L) {
            this.cumulativeDurationManagingMemory += l3;
        }
        if (this.previousTimestampManagedMemory != 0L && (l3 = l - this.previousTimestampManagedMemory) > 0L) {
            this.cumulativeDurationNotManagingMemory += l3;
        }
        this.previousTimestampManagedMemory = l2;
        long l4 = this.cumulativeDurationManagingMemory + this.cumulativeDurationNotManagingMemory;
        if (l4 > 0L) {
            this.percentageDurationManagingMemory = (int)(this.cumulativeDurationManagingMemory * 100L / l4);
        }
    }
}

