/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.util.Hashtable;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.util.Library;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dictionary {
    public static final Name TYPE_KEY = new Name("Type");
    public static final Name SUBTYPE_KEY = new Name("Subtype");
    protected Library library;
    protected Hashtable<Object, Object> entries;
    protected boolean inited;
    protected boolean isDeleted;
    protected boolean isNew;
    private Reference pObjectReference;

    public Dictionary(Library library, Hashtable entries) {
        this.library = library;
        this.entries = entries;
        if (this.entries == null) {
            this.entries = new Hashtable();
        }
    }

    public void setPObjectReference(Reference reference) {
        this.pObjectReference = reference;
    }

    public Reference getPObjectReference() {
        return this.pObjectReference;
    }

    public void init() {
    }

    public Hashtable<Object, Object> getEntries() {
        return this.entries;
    }

    public Object getObject(String key) {
        return this.library.getObject(this.entries, key);
    }

    public Object getObject(Name key) {
        return this.library.getObject(this.entries, key.getName());
    }

    protected Number getNumber(String key) {
        return this.library.getNumber(this.entries, key);
    }

    public int getInt(String key) {
        return this.library.getInt(this.entries, key);
    }

    public float getFloat(String key) {
        return this.library.getFloat(this.entries, key);
    }

    public Library getLibrary() {
        return this.library;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDeleted(boolean deleted) {
        this.isDeleted = deleted;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean aNew) {
        this.isNew = aNew;
    }

    public String toString() {
        return this.getClass().getName() + "=" + this.entries.toString();
    }
}

