/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.functions;

import java.util.Vector;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.functions.Function;

public class Function_3
extends Function {
    private float[] bounds;
    private float[] encode;
    private Function[] functions;

    Function_3(Dictionary d) {
        super(d);
        Vector encodeTemp;
        Vector boundTemp = (Vector)d.getObject("Bounds");
        if (boundTemp != null) {
            this.bounds = new float[boundTemp.size()];
            for (int i = 0; i < boundTemp.size(); ++i) {
                this.bounds[i] = ((Number)boundTemp.elementAt(i)).floatValue();
            }
        }
        if ((encodeTemp = (Vector)d.getObject("Encode")) != null) {
            this.encode = new float[encodeTemp.size()];
            for (int i = 0; i < encodeTemp.size(); ++i) {
                this.encode[i] = ((Number)encodeTemp.elementAt(i)).floatValue();
            }
        }
        Vector functionTemp = (Vector)d.getObject("Functions");
        if (encodeTemp != null) {
            this.functions = new Function[functionTemp.size()];
            for (int i = 0; i < functionTemp.size(); ++i) {
                this.functions[i] = Function.getFunction(d.getLibrary(), functionTemp.get(i));
            }
        }
    }

    public float[] calculate(float[] x) {
        int k = this.functions.length;
        if (k == 1 && this.bounds.length == 0 && this.domain[0] <= x[0] && x[0] <= this.domain[1]) {
            return this.encode(x, this.functions[0], 0);
        }
        for (int b = 0; b < this.bounds.length; ++b) {
            if (b == 0 && this.domain[0] <= x[0] && x[0] < this.bounds[b]) {
                return this.encode(x, this.functions[b], b);
            }
            if (b == k - 2 && this.bounds[b] <= x[0] && x[0] <= this.domain[1]) {
                return this.encode(x, this.functions[k - 1], k - 1);
            }
            if (!(this.bounds[b] <= x[0]) || !(x[0] < this.bounds[b + 1])) continue;
            return this.encode(x, this.functions[b], b);
        }
        return null;
    }

    private float[] encode(float[] x, Function function, int i) {
        int k = this.functions.length;
        if (i <= 0 && i < k && this.bounds.length > 0) {
            float b1 = i - 1 == -1 ? this.domain[0] : this.bounds[i - 1];
            float b2 = i == k - 1 ? this.domain[1] : this.bounds[i];
            if (k - 2 < this.bounds.length && this.bounds[k - 2] == this.domain[1]) {
                x[0] = this.encode[2 * i];
            }
            x[0] = Function_3.interpolate(x[0], b1, b2, this.encode[2 * i], this.encode[2 * i + 1]);
            x = function.calculate(x);
        } else {
            x[0] = Function_3.interpolate(x[0], this.domain[0], this.domain[1], this.encode[2 * i], this.encode[2 * i + 1]);
            x = function.calculate(x);
        }
        return this.validateAgainstRange(x);
    }

    private float[] validateAgainstRange(float[] values) {
        int max = values.length;
        for (int j = 0; j < max; ++j) {
            if (this.range != null && values[j] < this.range[2 * j]) {
                values[j] = this.range[2 * j];
                continue;
            }
            if (this.range != null && values[j] > this.range[2 * j + 1]) {
                values[j] = this.range[2 * j + 1];
                continue;
            }
            if (!(values[j] < 0.0f)) continue;
            values[j] = 0.0f;
        }
        return values;
    }
}

