/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.functions.postscript;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Stack;
import org.icepdf.core.pobjects.functions.postscript.Operator;
import org.icepdf.core.pobjects.functions.postscript.OperatorFactory;

public class Lexer {
    private Reader reader;
    private char[] buf = new char[2056];
    private int pos = 0;
    private int numRead = 0;
    private int startTokenPos = 0;
    private int tokenType = 0;
    private int expressionDepth;
    private static final int TOKEN_NUMBER = 1;
    private static final int TOKEN_OPERAND = 2;
    private static final int TOKEN_EXPRESSION = 3;
    private static final int TOKEN_BOOLEAN = 5;
    private Stack<Object> stack = new Stack();

    public void setInputStream(InputStream in) {
        this.setReader(new InputStreamReader(in));
    }

    protected void setReader(Reader reader) {
        this.reader = reader;
    }

    public void parse(float[] input) throws IOException {
        if (this.reader == null) {
            throw new IOException("Type 4 function, null input stream reader.");
        }
        float[] arr$ = input;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Float num = Float.valueOf(arr$[i$]);
            this.stack.push(num);
        }
        this.tokenType = 3;
        boolean done = false;
        while (!done) {
            int n;
            if (this.pos == this.buf.length) {
                System.arraycopy(this.buf, this.startTokenPos, this.buf, 0, this.pos - this.startTokenPos);
                this.pos = this.buf.length - this.startTokenPos;
                this.startTokenPos = 0;
                this.numRead = this.pos;
            }
            if ((n = this.reader.read(this.buf, this.pos, this.buf.length - this.pos)) <= 0) break;
            this.numRead += n;
            while (this.pos < this.numRead) {
                if (this.tokenType == 1) {
                    this.numberStart();
                    continue;
                }
                if (this.tokenType == 2) {
                    this.operandStart();
                    continue;
                }
                if (this.tokenType == 5) {
                    this.booleanStart();
                    continue;
                }
                if (this.tokenType != 3) continue;
                this.expressionStart();
            }
        }
    }

    public Stack getStack() {
        return this.stack;
    }

    private void parseNextState() {
        while (this.pos < this.numRead && (this.buf[this.pos] == ' ' || this.buf[this.pos] == '\t' || this.buf[this.pos] == '\n' || this.buf[this.pos] == '\r')) {
            ++this.pos;
        }
        if (this.pos < this.numRead) {
            this.startTokenPos = this.pos;
            if (this.buf[this.pos] < 'A') {
                this.tokenType = 1;
            } else if (this.buf[this.pos] == 'f' && this.buf[this.pos + 1] == 'a' || this.buf[this.pos] == 't' && this.buf[this.pos + 3] == 'e') {
                this.tokenType = 5;
            } else if (this.buf[this.pos] < '{') {
                this.tokenType = 2;
            } else if (this.buf[this.pos] == '{' || this.buf[this.pos] == '}') {
                this.tokenType = 3;
            } else {
                this.parseNextState();
            }
        }
    }

    private void expressionStart() {
        while (this.pos < this.numRead && (this.buf[this.pos] == '{' || this.buf[this.pos] == '}')) {
            ++this.pos;
        }
        if (this.pos < this.numRead) {
            Operator operand = OperatorFactory.getOperator(this.buf, this.startTokenPos, this.pos - this.startTokenPos);
            if (operand.getType() == 43) {
                ++this.expressionDepth;
            }
            if (this.expressionDepth > 1) {
                this.stack.push(operand);
            }
            if (operand.getType() == 44) {
                --this.expressionDepth;
            }
        }
        this.parseNextState();
    }

    private void operandStart() {
        this.startTokenPos = this.pos;
        while (this.pos < this.numRead && !Lexer.isDelimiter(this.buf[this.pos])) {
            ++this.pos;
        }
        if (this.pos < this.numRead && this.pos > this.startTokenPos) {
            Operator operand = OperatorFactory.getOperator(this.buf, this.startTokenPos, this.pos - this.startTokenPos);
            if (this.expressionDepth > 1) {
                this.stack.push(operand);
            } else {
                operand.eval(this.stack);
            }
        }
        this.parseNextState();
    }

    private void numberStart() {
        this.startTokenPos = this.pos;
        while (this.pos < this.numRead && !Lexer.isDelimiter(this.buf[this.pos])) {
            ++this.pos;
        }
        if (this.pos < this.numRead) {
            this.stack.push(Float.valueOf(Float.parseFloat(new String(this.buf, this.startTokenPos, this.pos - this.startTokenPos))));
        }
        this.parseNextState();
    }

    private void booleanStart() {
        while (this.pos < this.numRead && !Lexer.isDelimiter(this.buf[this.pos])) {
            ++this.pos;
        }
        if (this.pos < this.numRead) {
            this.stack.push(Boolean.valueOf(new String(this.buf, this.startTokenPos, this.pos - this.startTokenPos)));
        }
        this.parseNextState();
    }

    private static boolean isDelimiter(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '{' || c == '}';
    }
}

