/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Form;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.graphics.TextSprite;
import org.icepdf.core.pobjects.graphics.TilingPattern;
import org.icepdf.core.pobjects.graphics.text.PageText;
import org.icepdf.core.util.Defs;
import org.icepdf.core.views.swing.PageViewComponentImpl;

public class Shapes {
    private static final Logger logger = Logger.getLogger(Shapes.class.toString());
    private static int paintDelay = 200;
    private static boolean scaleImages = Defs.sysPropertyBoolean("org.icepdf.core.scaleImages", true);
    protected Vector<Object> shapes = new Vector(1000);
    private Vector<Image> images = new Vector();
    private Page parentPage;
    private PageText pageText = new PageText();

    public PageText getPageText() {
        return this.pageText;
    }

    public int getShapesCount() {
        if (this.shapes != null) {
            return this.shapes.size();
        }
        return 0;
    }

    public void setPageParent(Page parent) {
        this.parentPage = parent;
    }

    public void dispose() {
        for (Image image : this.images) {
            image.flush();
        }
        this.images.clear();
        this.images.trimToSize();
        if (this.shapes != null) {
            for (Object tmp : this.shapes) {
                if (tmp instanceof Image) {
                    Image image = (Image)tmp;
                    image.flush();
                    continue;
                }
                if (tmp instanceof TextSprite) {
                    ((TextSprite)tmp).dispose();
                    continue;
                }
                if (!(tmp instanceof Shapes)) continue;
                ((Shapes)tmp).dispose();
            }
            this.shapes.clear();
            this.shapes.trimToSize();
            this.shapes = null;
        }
        if (this.pageText != null) {
            this.pageText.dispose();
            this.pageText = null;
        }
    }

    public void add(Object o) {
        Object tmp;
        if (o instanceof Image) {
            Image scaledImage;
            Image image = (Image)o;
            int width = image.getWidth(null);
            if (scaleImages) {
                double scaleFactor = 1.0;
                if (width > 1000 && width < 1500) {
                    scaleFactor = 0.75;
                } else if (width > 1500) {
                    scaleFactor = 0.5;
                }
                if (scaleFactor < 1.0) {
                    scaledImage = image.getScaledInstance((int)((double)width * scaleFactor), -1, 4);
                    image.flush();
                } else {
                    scaledImage = image;
                }
            } else {
                scaledImage = image;
            }
            this.images.add(scaledImage);
            this.shapes.add(scaledImage);
            return;
        }
        if (o instanceof Vector) {
            tmp = (Vector)o;
            Iterator iterator = ((Vector)tmp).iterator();
            while (iterator.hasNext()) {
                Object tmpImage = iterator.next();
                if (!(tmpImage instanceof Image)) continue;
                this.images.addElement((Image)tmpImage);
            }
        }
        if (o instanceof Shapes) {
            tmp = (Shapes)o;
            this.pageText.getPageLines().addAll(((Shapes)tmp).getPageText().getPageLines());
        }
        this.shapes.add(o);
    }

    public void addDrawCommand() {
        this.shapes.add(new Draw());
    }

    public void addFillCommand() {
        this.shapes.add(new Fill());
    }

    public void addClipCommand() {
        this.shapes.add(new Clip());
    }

    public void addNoClipCommand() {
        this.shapes.add(new NoClip());
    }

    public synchronized void paint(Graphics2D g) {
        this.paint(g, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void paint(Graphics2D g, PageViewComponentImpl.PagePainter pagePainter) {
        disableClipping = Defs.sysPropertyBoolean("org.icepdf.core.paint.disableClipping", false);
        disableAlpha = Defs.sysPropertyBoolean("org.icepdf.core.paint.disableAlpha", false);
        shape = null;
        base = new AffineTransform(g.getTransform());
        clip = g.getClip();
        clipArea = new Area(g.getClip());
        lastPaintTime = System.currentTimeMillis();
        shapesEnumeration = this.shapes.iterator();
        try {
            while (true) lbl-1000:
            // 32 sources

            {
                if (!shapesEnumeration.hasNext()) {
                    if (pagePainter == null) return;
                    if (pagePainter.isStopPaintingRequested() == false) return;
                }
                if ((nextShape = shapesEnumeration.next()) instanceof TextSprite) {
                    if (!((TextSprite)nextShape).intersects(clipArea)) continue;
                    ((TextSprite)nextShape).paint(g);
                    currentTime = System.currentTimeMillis();
                    if (currentTime - lastPaintTime <= (long)Shapes.paintDelay) continue;
                    lastPaintTime = currentTime;
                    if (this.parentPage == null) continue;
                    this.parentPage.notifyPaintPageListeners();
                    continue;
                }
                if (nextShape instanceof Shape) {
                    shape = (Shape)nextShape;
                    continue;
                }
                if (nextShape instanceof Fill) {
                    if (!clipArea.intersects(shape.getBounds2D())) continue;
                    g.fill(shape);
                    currentTime = System.currentTimeMillis();
                    if (currentTime - lastPaintTime <= (long)Shapes.paintDelay) continue;
                    lastPaintTime = currentTime;
                    this.parentPage.notifyPaintPageListeners();
                    continue;
                }
                if (nextShape instanceof AffineTransform) {
                    af = new AffineTransform(base);
                    af.concatenate((AffineTransform)nextShape);
                    g.setTransform(af);
                    if (g.getClip() == null) continue;
                    clipArea = new Area(g.getClip());
                    continue;
                }
                if (nextShape instanceof AlphaComposite && !disableAlpha) {
                    g.setComposite((AlphaComposite)nextShape);
                    continue;
                }
                if (nextShape instanceof Paint) {
                    g.setPaint((Paint)nextShape);
                    continue;
                }
                if (nextShape instanceof Clip) {
                    af = new AffineTransform(g.getTransform());
                    g.setTransform(base);
                    g.setClip(clip);
                    g.setTransform(af);
                    if (shape != null && !disableClipping) {
                        g.clip(shape);
                    }
                    clipArea = new Area(g.getClip());
                    continue;
                }
                if (nextShape instanceof Draw) {
                    if (!shape.intersects(clipArea.getBounds2D()) && !(shape.getBounds2D().getWidth() < 1.0) && !(shape.getBounds2D().getHeight() < 1.0)) continue;
                    g.draw(shape);
                    currentTime = System.currentTimeMillis();
                    if (currentTime - lastPaintTime <= (long)Shapes.paintDelay) continue;
                    lastPaintTime = currentTime;
                    this.parentPage.notifyPaintPageListeners();
                    continue;
                }
                if (nextShape instanceof NoClip) {
                    af = new AffineTransform(g.getTransform());
                    g.setTransform(base);
                    g.setClip(clip);
                    g.setTransform(af);
                    clipArea = new Area(g.getClip());
                    continue;
                }
                if (nextShape instanceof Stroke) {
                    g.setStroke((Stroke)nextShape);
                    continue;
                }
                if (nextShape instanceof Image) {
                    tmpImage = (Image)nextShape;
                    if (!clipArea.intersects(0.0, 0.0, 1.0, 1.0)) continue;
                    try {
                        g.drawImage(tmpImage, 0, 0, 1, 1, null);
                    }
                    catch (OutOfMemoryError memErr) {
                        width = tmpImage.getWidth(null);
                        height = tmpImage.getHeight(null);
                        if (width < 600 || height < 600) ** GOTO lbl-1000
                        at = g.getTransform();
                        scaleX = (int)at.getScaleX();
                        scaleY = (int)at.getScaleX();
                        if (scaleX >= width && scaleY >= height) ** GOTO lbl-1000
                        renderingHints = g.getRenderingHints();
                        oldInterpolation = renderingHints.get(RenderingHints.KEY_INTERPOLATION);
                        try {
                            renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                            g.setRenderingHints(renderingHints);
                            g.drawImage(tmpImage, 0, 0, 1, 1, null);
                        }
                        catch (OutOfMemoryError memErr2) {
                            shapesEnumeration.remove();
                            Shapes.logger.log(Level.FINE, "Image too large to draw", memErr);
                        }
                        finally {
                            renderingHints.put(RenderingHints.KEY_INTERPOLATION, oldInterpolation);
                            g.setRenderingHints(renderingHints);
                            currentTime = System.currentTimeMillis();
                            if (currentTime - lastPaintTime <= (long)Shapes.paintDelay) ** GOTO lbl-1000
                            lastPaintTime = currentTime;
                            this.parentPage.notifyPaintPageListeners();
                        }
                    }
                    continue;
                }
                if (nextShape instanceof Shapes) {
                    ((Shapes)nextShape).setPageParent(this.parentPage);
                    ((Shapes)nextShape).paint(g);
                    ((Shapes)nextShape).setPageParent(null);
                    continue;
                }
                if (nextShape instanceof Form) {
                    xForm = (Form)nextShape;
                    bBox = xForm.getBBox();
                    width = (int)bBox.getWidth();
                    height = (int)bBox.getHeight();
                    if (width == 0) {
                        width = 1;
                    }
                    if (height == 0) {
                        height = 1;
                    }
                    bi = new BufferedImage(width, height, 2);
                    canvas = bi.createGraphics();
                    canvas.setRenderingHints(g.getRenderingHints());
                    xFormShapes = xForm.getShapes();
                    if (xFormShapes != null) {
                        xFormShapes.setPageParent(this.parentPage);
                        canvas.translate(-((int)bBox.getX()), -((int)bBox.getY()));
                        canvas.setClip(bBox);
                        xFormShapes.paint(canvas);
                        xFormShapes.setPageParent(null);
                    }
                    g.drawImage(bi, null, (int)bBox.getX(), (int)bBox.getY());
                    continue;
                }
                if (nextShape instanceof Color) {
                    g.setColor((Color)nextShape);
                    continue;
                }
                if (!(nextShape instanceof TilingPattern)) continue;
                tilingPattern = (TilingPattern)nextShape;
                tilingPattern.paintPattern(g, this.parentPage);
            }
        }
        catch (NoSuchElementException e) {
            return;
        }
        catch (Exception e) {
            Shapes.logger.log(Level.FINE, "Error painting shapes.", e);
        }
    }

    public Vector getImages() {
        return this.images;
    }

    public void contract() {
        if (this.shapes != null && this.shapes.capacity() - this.shapes.size() > 200) {
            this.shapes.trimToSize();
        }
    }

    static {
        try {
            paintDelay = Defs.intProperty("org.icepdf.core.views.refreshfrequency", 200);
        }
        catch (NumberFormatException e) {
            logger.log(Level.FINE, "Error reading buffered scale factor");
        }
    }

    class NoClip {
        NoClip() {
        }
    }

    class Clip {
        Clip() {
        }
    }

    class Fill {
        Fill() {
        }
    }

    class Draw {
        Draw() {
        }
    }
}

