/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.SeekableInput;
import org.icepdf.core.pobjects.CrossReference;
import org.icepdf.core.pobjects.ObjectStream;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.PTrailer;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.MemoryManagerDelegate;
import org.icepdf.core.util.Parser;

public class LazyObjectLoader
implements MemoryManagerDelegate {
    private static final Logger logger = Logger.getLogger(LazyObjectLoader.class.toString());
    private Library library;
    private SeekableInput m_SeekableInput;
    private CrossReference m_CrossReference;
    protected ArrayList<ObjectStream> leastRecentlyUsed;
    private final Object leastRectlyUsedLock = new Object();

    public LazyObjectLoader(Library lib, SeekableInput seekableInput, CrossReference xref) {
        this.library = lib;
        this.m_SeekableInput = seekableInput;
        this.m_CrossReference = xref;
        this.leastRecentlyUsed = new ArrayList(256);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean loadObject(Reference reference) {
        if (reference == null) return false;
        if (this.library == null) return false;
        if (this.m_CrossReference == null) {
            return false;
        }
        int objNum = reference.getObjectNumber();
        CrossReference.Entry entry = this.m_CrossReference.getEntryForObject(objNum);
        if (entry == null) {
            return false;
        }
        boolean gotSomething = false;
        if (entry instanceof CrossReference.UsedEntry) {
            try {
                if (this.m_SeekableInput == null) return gotSomething;
                this.m_SeekableInput.beginThreadAccess();
                CrossReference.UsedEntry usedEntry = (CrossReference.UsedEntry)entry;
                long position = usedEntry.getFilePositionOfObject();
                long savedPosition = this.m_SeekableInput.getAbsolutePosition();
                this.m_SeekableInput.seekAbsolute(position);
                Parser parser = new Parser(this.m_SeekableInput);
                Object ob = parser.getObject(this.library);
                gotSomething = ob != null;
                this.m_SeekableInput.seekAbsolute(savedPosition);
                return gotSomething;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error loading object instance: " + reference.toString(), e);
                return gotSomething;
            }
            finally {
                if (this.m_SeekableInput != null) {
                    this.m_SeekableInput.endThreadAccess();
                }
            }
        }
        if (!(entry instanceof CrossReference.CompressedEntry)) return gotSomething;
        try {
            CrossReference.CompressedEntry compressedEntry = (CrossReference.CompressedEntry)entry;
            int objectStreamsObjectNumber = compressedEntry.getObjectNumberOfContainingObjectStream();
            int objectIndex = compressedEntry.getIndexWithinObjectStream();
            Reference objectStreamRef = new Reference(objectStreamsObjectNumber, 0);
            ObjectStream objectStream = (ObjectStream)this.library.getObject(objectStreamRef);
            if (objectStream == null) return gotSomething;
            Object object = this.leastRectlyUsedLock;
            synchronized (object) {
                this.leastRecentlyUsed.remove(objectStream);
                this.leastRecentlyUsed.add(objectStream);
                return objectStream.loadObject(this.library, objectIndex);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error loading object instance: " + reference.toString(), e);
        }
        return gotSomething;
    }

    public boolean haveEntry(Reference reference) {
        if (reference == null || this.m_CrossReference == null) {
            return false;
        }
        int objNum = reference.getObjectNumber();
        CrossReference.Entry entry = this.m_CrossReference.getEntryForObject(objNum);
        return entry != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PTrailer loadTrailer(long position) {
        PTrailer trailer = null;
        try {
            if (this.m_SeekableInput != null) {
                this.m_SeekableInput.beginThreadAccess();
                long savedPosition = this.m_SeekableInput.getAbsolutePosition();
                this.m_SeekableInput.seekAbsolute(position);
                Parser parser = new Parser(this.m_SeekableInput);
                Object obj = parser.getObject(this.library);
                if (obj instanceof PObject) {
                    obj = ((PObject)obj).getObject();
                }
                if ((trailer = (PTrailer)obj) != null) {
                    trailer.setPosition(position);
                }
                this.m_SeekableInput.seekAbsolute(savedPosition);
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Error loading PTrailer instance: " + position, e);
        }
        finally {
            if (this.m_SeekableInput != null) {
                this.m_SeekableInput.endThreadAccess();
            }
        }
        return trailer;
    }

    public void dispose() {
        this.library = null;
        this.m_SeekableInput = null;
        this.m_CrossReference = null;
        if (this.leastRecentlyUsed != null) {
            this.leastRecentlyUsed.clear();
            this.leastRecentlyUsed = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reduceMemory(int reductionPolicy) {
        int numToDo = 0;
        Object object = this.leastRectlyUsedLock;
        synchronized (object) {
            int lruSize = this.leastRecentlyUsed.size();
            if (reductionPolicy == 1) {
                numToDo = lruSize * 75 / 100;
            } else if (reductionPolicy == 0) {
                if (lruSize > 5) {
                    numToDo = lruSize * 50 / 100;
                } else if (lruSize > 0) {
                    numToDo = 1;
                }
            }
            for (int i = 0; i < numToDo; ++i) {
                ObjectStream objStm = this.leastRecentlyUsed.remove(0);
                if (objStm == null) continue;
                objStm.dispose(true);
            }
        }
        return numToDo > 0;
    }

    public Library getLibrary() {
        return this.library;
    }
}

